<?php

include 'sv/config.php';
include 'sv/clases/Notificacion.php';
include 'sv/clases/Suscripcion.php';
include 'sv/clases/Logo.php';
include 'sv/clases/Marquesina.php';
include 'sv/clases/Reporte.php';

include 'sv/funciones_index.php';
include 'sv/clases/Usuario.php'; // Asegúrate de que esta clase esté incluida si no lo estaba

session_start();

$obj_notificacion = new Notificacion();
$obj_logo = new Logo();
$obj_usuario = new Usuario();

if (!(isset($_SESSION['usuario'])) || ($_SESSION['tipo_usuario'] == 5)
	|| $obj_usuario->verificarStatus($_SESSION['id_usuario'], $_SESSION['tipo_usuario']) == 1)
{
	header('Location: sv/controladores/logout.php');
}
else
{
	if ($obj_usuario->consultarValorIp($_SESSION['id_usuario']) != $_SESSION['ip'])
		header('Location: cl/responder.php');
	else
	{
		switch ($obj_usuario->inicio($_SESSION['id_usuario']))
		{
			case 0: # Usuario nuevo
			case 2: # Preguntas de seguridad restablecidas
				header('Location: cl/preguntas.php');
				break;
		}
	}
}

$obj_usuario->actualizarOnline(time(), $_SESSION['id_usuario']);

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="https://www.w3.org/1999/xhtml">
<head>
<meta https-equiv="Content-Type" content="text/html; charset=utf-8" />
<link href="recursos/logo-shorcut.png" rel="shortcut icon" type="image/x-icon" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php printf($obj_logo->getNombreBd()) ?></title>
<link type="text/css" rel="stylesheet" href="librerias/bootstrap/css/bootstrap.min.css" />
<link type="text/css" rel="stylesheet" href="<?php echo 'librerias/'.MAIN_CSS ?>" />
<script type="application/javascript" src="librerias/jquery/jquery/jquery-1.10.2.js"></script>
<script type="text/javascript" src="<?php echo 'librerias/flowplayer/'.FLOWPLAYER_JS ?>"></script>
<style type="text/css">
	body{ padding-top:60px;padding-bottom:55px }
	/* NUEVO: Estilo para la vista 2x2. Asegura que el reproductor de video se vea bien */
	.contenedor-player .player {
		/* Ajusta la altura para el 2x2. Necesitarás ajustar esta proporción en tu CSS principal */
		height: 300px; /* Valor de ejemplo, ajusta al diseño */
	}
	@media (min-width: 992px) { /* Por ejemplo, para lg/md */
	    /* Si estás en modo 4 canales, ajusta el alto para que quepan 2 arriba y 2 abajo */
		.col-lg-6 .contenedor-player .player {
			height: 40vh; /* O un valor fijo que funcione bien en 2x2 */
		}
	}
</style>
</head>

<body id="index">

	<?php require 'sv/headers/menu_principal_index.php' ?>
	<?php require 'sv/headers/marquesina.php' ?>

	<div class="container-fluid">
	   <div class="row">
	      <div id="contenido">

	      	<div class="col-xs-12 col-sm-8 col-md-8 col-lg-7 col-lg-offset-1">
					<div class="contenedor-player" data-player="1" data-sala="-1" data-canal="-1">
						<button class="btn btn-default actualizar-canal" data-toggle="actualizar1">
							<i class="glyphicon glyphicon-refresh"></i> Actualizar canal
						</button>
						<h2 class="titulo"></h2>
						<a class="player" href="https://e1h13.simplecdn.net/flowplayer/flowplayer.flv" id="player"></a>
						<div class="video-usuario">
							<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
						</div>
				      <div class="video-usuario2">
				      	<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
				      </div>
				      <div class="video-usuario3">
				      	<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
				      </div>
				      <div class="video-nombre-web">
				      	<?php printf($obj_logo->getNombreBd()) ?>
				      </div>
				   </div> </div> <?php if ($_SESSION['tipo_usuario'] == 1 || $_SESSION['tipo_usuario'] == 2 || $_SESSION['tipo_usuario'] == 4) { ?>
					<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 hide" id="contenedor-canal2">
						<div class="contenedor-player" data-player="2" data-sala="2" data-canal="2">
							<button class="btn btn-default actualizar-canal" data-toggle="actualizar2">
								<i class="glyphicon glyphicon-refresh"></i> Actualizar canal
							</button>
							<h2 class="titulo">Americanas<small> - canal 2</small></h2>
							<a class="player" href="https://e1h13.simplecdn.net/flowplayer/flowplayer.flv" id="player2"></a>
							<div class="video-usuario">
								<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
							</div>
					      <div class="video-usuario2">
					      	<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
					      </div>
					      <div class="video-usuario3">
					      	<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
					      </div>
					      <div class="video-nombre-web">
					      	<?php printf($obj_logo->getNombreBd()) ?>
					      </div>
					   </div> </div> <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 hide" id="contenedor-canal3">
						<div class="contenedor-player" data-player="3" data-sala="2" data-canal="3">
							<button class="btn btn-default actualizar-canal" data-toggle="actualizar3">
								<i class="glyphicon glyphicon-refresh"></i> Actualizar canal
							</button>
							<h2 class="titulo">Americanas<small> - canal 3</small></h2>
							<a class="player" href="https://e1h13.simplecdn.net/flowplayer/flowplayer.flv" id="player3"></a>
							<div class="video-usuario">
								<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
							</div>
					      <div class="video-usuario2">
					      	<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
					      </div>
					      <div class="video-usuario3">
					      	<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
					      </div>
					      <div class="video-nombre-web">
					      	<?php printf($obj_logo->getNombreBd()) ?>
					      </div>
					   </div> </div> <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 hide" id="contenedor-canal4">
						<div class="contenedor-player" data-player="4" data-sala="2" data-canal="4">
							<button class="btn btn-default actualizar-canal" data-toggle="actualizar4">
								<i class="glyphicon glyphicon-refresh"></i> Actualizar canal
							</button>
							<h2 class="titulo">Americanas<small> - canal 4</small></h2>
							<a class="player" href="https://e1h13.simplecdn.net/flowplayer/flowplayer.flv" id="player4"></a>
							<div class="video-usuario">
								<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
							</div>
					      <div class="video-usuario2">
					      	<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
					      </div>
					      <div class="video-usuario3">
					      	<i class="glyphicon glyphicon-user"></i> <?php echo $_SESSION["usuario"] ?>
					      </div>
					      <div class="video-nombre-web">
					      	<?php printf($obj_logo->getNombreBd()) ?>
					      </div>
					   </div> </div> <?php } ?>

				<div class="col-xs-12 col-sm-4 col-md-4 col-lg-3">
	        		<div id="menu" class="contenedor-menu">
	            	<a class="contraer-menu">SALAS Y CANALES</a>
	         		<div class="menu"><?php echo salas_canales(); ?></div>
            	</div>         		</div>       	<script type="text/javascript">

	      		var canal_1y2 = 0;
	      		var canal_1a4 = 0; // NUEVO: Variable para 4 canales
	      		var flowplayer_swf  = '/librerias/flowplayer/v-3.2.18/flowplayer-3.2.18.swf';
	      		var flowplayer_rtmp = '/librerias/flowplayer/v-3.2.18/flowplayer.rtmp-3.2.13.swf';

	      		function player1(c,d){
			  			flowplayer("player", flowplayer_swf,
			  				{
								play: null , canvas: { backgroundImage: "url()"
							},
							clip:{
			  					provider:'rtmp',live:true,url:c
			  				},
			  				plugins:{
			  					rtmp:{
			  						url:flowplayer_rtmp,
			  						netConnectionUrl:d
			  					}
			  				}
			  			});
			  		}

			  		function player2(c,d){
			  			flowplayer("player2", flowplayer_swf,
							{
								play: null , canvas: { backgroundImage: "url()"
							},
				         clip: {
				         	url: c,
							   live: true,
							   provider: "rtmp"
							},
				         plugins: {
								rtmp: {
									url: flowplayer_rtmp,
									netConnectionUrl: d
								}
							}
						});
			  		}

					// NUEVO: Función para inicializar Player 3
					function player3(c,d){
						flowplayer("player3", flowplayer_swf,
							{
								play: null , canvas: { backgroundImage: "url()"
							},
							clip: {
								url: c,
								live: true,
								provider: "rtmp"
							},
							plugins: {
								rtmp: {
									url: flowplayer_rtmp,
									netConnectionUrl: d
								}
							}
						});
					}

					// NUEVO: Función para inicializar Player 4
					function player4(c,d){
						flowplayer("player4", flowplayer_swf,
							{
								play: null , canvas: { backgroundImage: "url()"
							},
							clip: {
								url: c,
								live: true,
								provider: "rtmp"
							},
							plugins: {
								rtmp: {
									url: flowplayer_rtmp,
									netConnectionUrl: d
								}
							}
						});
					}

			  		function modificar_menu(tipo_vista) // MODIFICADA para 1, 2 o 4 canales
			  		{
			  			// tipo_vista: 0 = 1 canal, 1 = 2 canales, 2 = 4 canales
			  			if (tipo_vista > 0)
			  			{
			  				$('#menu').addClass('menu-oculto');
							$('#menu').css('width','300px');
				  			$(".contraer-menu").next("div").toggle(200);
							$(".contraer-menu").toggleClass("toggle-activo");
			  			}
			  			else
			  			{
			  				$('#menu').removeClass('menu-oculto');
			  				$('#menu').removeAttr('style');
			  			}
			  		}

					// NUEVO: Función para actualizar Player 3
					function actualizar_player3()
					{
						$.ajax({
							cache: false,
							dataType: 'JSON',
							type: 'POST',
							url: '/sv/consultas_canales.php',
							data: 'accion=actualizar_player3',
							beforeSend:function(){
								$("[data-toggle=actualizar3]").attr("disabled","disabled");
							},
							success:function(data) {
								if (data.iframe == 0)
								{
									if (data.url == null || data.rtmp == null)
									{
										$('[data-player=3]').find('h2').html('Americanas <small> - canal inactivo</small>');
										player3(null, null);
									}
									else
									{
										$('[data-player=3]').find('h2').html('Americanas <small> - canal 3</small>');
										$('[data-player=3] #player3').remove();
										$('[data-player=3]').children('h2').after(
											'<a class="player" href="https://e1h13.simplecdn.net/flowplayer/flowplayer.flv" id="player3"></a>');
										player3(data.url, data.rtmp);
									}
								}
								else
								{
									if (data.src_iframe == '')
										$('[data-player=3]').find('h2').html('Americanas <small> - canal inactivo</small>');
									else
										$('[data-player=3]').find('h2').html('Americanas <small> - canal 3</small>');

									$('[data-player=3] #player3').remove();
									$('[data-player=3]').children('h2').after(
										'<iframe id="player3" class="player" frameborder="0" src="'+data.src_iframe+'"allowfullscreen></iframe>');
								}

								$("[data-toggle=actualizar3]").removeAttr("disabled");
							}
						});
					}
					
					// NUEVO: Función para actualizar Player 4
					function actualizar_player4()
					{
						$.ajax({
							cache: false,
							dataType: 'JSON',
							type: 'POST',
							url: '/sv/consultas_canales.php',
							data: 'accion=actualizar_player4',
							beforeSend:function(){
								$("[data-toggle=actualizar4]").attr("disabled","disabled");
							},
							success:function(data) {
								if (data.iframe == 0)
								{
									if (data.url == null || data.rtmp == null)
									{
										$('[data-player=4]').find('h2').html('Americanas <small> - canal inactivo</small>');
										player4(null, null);
									}
									else
									{
										$('[data-player=4]').find('h2').html('Americanas <small> - canal 4</small>');
										$('[data-player=4] #player4').remove();
										$('[data-player=4]').children('h2').after(
											'<a class="player" href="https://e1h13.simplecdn.net/flowplayer/flowplayer.flv" id="player4"></a>');
										player4(data.url, data.rtmp);
									}
								}
								else
								{
									if (data.src_iframe == '')
										$('[data-player=4]').find('h2').html('Americanas <small> - canal inactivo</small>');
									else
										$('[data-player=4]').find('h2').html('Americanas <small> - canal 4</small>');

									$('[data-player=4] #player4').remove();
									$('[data-player=4]').children('h2').after(
										'<iframe id="player4" class="player" frameborder="0" src="'+data.src_iframe+'"allowfullscreen></iframe>');
								}

								$("[data-toggle=actualizar4]").removeAttr("disabled");
							}
						});
					}

			  		function actualizar_player1(sala, canal)
			  		{
			  			if (sala == null)
			  			{
			  				sala  = -1;
			  				canal = -1;
			  			}
			  			$.ajax({
			  				cache: false,
			  				dataType: 'JSON',
			  				type: 'POST',
			  				url: '/sv/consultas_canales.php',
			  				data: 'accion=actualizar_player1&sala='+sala+'&canal='+canal+'&canal_1y2='+canal_1y2+'&canal_1a4='+canal_1a4, // MODIFICADO
			  				beforeSend:function(){
			  					$("[data-toggle=actualizar1]").attr("disabled","disabled");
			  				},
			  				success:function(b){

			  					// Si el numero de sala recibido es null, significa que todos los canales están inactivos
			  					if (!b.nro_sala)
			  					{
			  						$('[data-player=1]').find('h2').html('SALA INACTIVA');
			  						$('[data-player=1]').attr('data-sala', -1);
			  						$('[data-player=1]').attr('data-canal', -1);
			  						$('[data-player=1]').find('iframe').attr('src', '');
			  						player1(null, null);
			  					}
			  					else
			  					{
			  						$('[data-player=1]').attr('data-sala', b.nro_sala); // Asigno el número de sala al contenedor player1
			  						$('[data-player=1]').attr('data-canal', b.nro_canal); // Asigno el número de canal al contenedor player1

			  						if (b.iframe == 0)
					  				{
					  					if (canal_1y2 == 1 || canal_1a4 == 1) // MODIFICADO: Incluye 4 canales
					  					{
					  						if (b.url == null || b.rtmp == null)
							  					$('[data-player=1]').find('h2').html('Americanas <small> - canal inactivo</small>');
							  				else
							  					$('[data-player=1]').find('h2').html('Americanas <small> - canal 1</small>');
					  					}
					  					else
					  						$('[data-player=1]').find('h2').html(b.nombre_sala + '<small> - canal ' + b.nro_canal + '</small>');

					  					$('[data-player=1] #player').remove();
					  					$('[data-player=1]').children('h2').after(
					  						'<a class="player" href="https://e1h13.simplecdn.net/flowplayer/flowplayer.flv" id="player"></a>');
					  					player1(b.url, b.rtmp);
					  				}
					  				else
					  				{
					  					if (canal_1y2 == 1 || canal_1a4 == 1) // MODIFICADO: Incluye 4 canales
					  					{
					  						if (b.src_iframe == '')
							  					$('[data-player=1]').find('h2').html('Americanas <small> - canal inactivo</small>');
							  				else
							  					$('[data-player=1]').find('h2').html('Americanas <small> - canal 1</small>');
					  					}
					  					else
					  						$('[data-player=1]').find('h2').html(b.nombre_sala + '<small> - canal ' + b.nro_canal + '</small>');

					  					$('[data-player=1] #player').remove();
					  					$('[data-player=1]').children('h2').after(
					  					'<iframe id="player" class="player" frameborder="0" src="'+b.src_iframe+'"allowfullscreen ></iframe>');
					  				}
			  					}

			  					$("[data-toggle=actualizar1]").removeAttr("disabled");
			  				}
			  			});
			  		}

			  		function actualizar_player2()
			  		{
			  			$.ajax({
			  				cache: false,
			  				dataType: 'JSON',
			  				type: 'POST',
			  				url: '/sv/consultas_canales.php',
			  				data: 'accion=actualizar_player2',
			  				beforeSend:function(){
			  					$("[data-toggle=actualizar2]").attr("disabled","disabled");
			  				},
			  				success:function(data) {

			  					if (data.iframe == 0)
					  			{
					  				if (data.url == null || data.rtmp == null)
					  				{
					  					$('[data-player=2]').find('h2').html('Americanas <small> - canal inactivo</small>');
					  					player2(null, null);
					  				}
					  				else
					  				{
					  					$('[data-player=2]').find('h2').html('Americanas <small> - canal 2</small>');
					  					$('[data-player=2] #player2').remove();
						  				$('[data-player=2]').children('h2').after(
						  					'<a class="player" href="https://e1h13.simplecdn.net/flowplayer/flowplayer.flv" id="player2"></a>');
						  				player2(data.url, data.rtmp);
					  				}
					  			}
					  			else
					  			{
					  				if (data.src_iframe == '')
					  					$('[data-player=2]').find('h2').html('Americanas <small> - canal inactivo</small>');
					  				else
					  					$('[data-player=2]').find('h2').html('Americanas <small> - canal 2</small>');

					  				$('[data-player=2] #player2').remove();
					  				$('[data-player=2]').children('h2').after(
					  					'<iframe id="player2" class="player" frameborder="0" src="'+data.src_iframe+'"allowfullscreen></iframe>');
					  			}

			  					$("[data-toggle=actualizar2]").removeAttr("disabled");
			  				}
			  			});
			  		}

			  		function consultar_senal(sala, canal) {
			  			if (sala == null)
			  			{
			  				sala  = -1;
			  				canal = -1;
			  			}
			  			$.ajax({
			  				cache: false,
			  				dataType: 'JSON',
			  				type: 'POST',
			  				url: '/sv/consultas_canales.php',
			  				data: 'accion=url_rtmp_index&sala='+sala+"&canal="+canal,
			  				beforeSend:function(){
			  					$("[data-toggle=actualizar1]").attr("disabled","disabled");
			  				},
			  				success:function(b){

			  					canal_1y2 = b.canal_1y2;
								canal_1a4 = b.canal_1a4; // NUEVO: Obtener estado de 4 canales

			  					// LÓGICA DE LAYOUT MODIFICADA PARA 4 CANALES
								
								// 1. VISTA DE 4 CANALES
			  					if (canal_1a4 == 1)
			  					{
			  						$('[data-player=1]').find('h2').html('Americanas <small> - canal 1</small>');
										
									// Mostrar los 4 contenedores y darles 50% de ancho (col-xs-6 para móviles)
			  						$('[data-player=1]').parent().attr('class','col-xs-6 col-sm-6 col-md-6 col-lg-6');
			  						$('#contenedor-canal2').attr('class','col-xs-6 col-sm-6 col-md-6 col-lg-6');
									$('#contenedor-canal3').attr('class','col-xs-6 col-sm-6 col-md-6 col-lg-6'); // Mostrar Canal 3
									$('#contenedor-canal4').attr('class','col-xs-6 col-sm-6 col-md-6 col-lg-6'); // Mostrar Canal 4
									
			  						actualizar_player2();
									actualizar_player3(); // Cargar Canal 3
									actualizar_player4(); // Cargar Canal 4
			  					}
								// 2. VISTA DE 2 CANALES (Lógica Original)
			  					else if (canal_1y2 == 1)
			  					{
			  						$('[data-player=1]').find('h2').html('Americanas <small> - canal 1</small>');
			  						$('[data-player=1]').parent().attr('class','col-xs-12 col-sm-6 col-md-6 col-lg-6');
			  						$('#contenedor-canal2').attr('class','col-xs-12 col-sm-6 col-md-6 col-lg-6');
									
									// Ocultar Canal 3 y 4
									$('#contenedor-canal3').attr('class','col-xs-12 col-sm-6 col-md-6 col-lg-6 hide');
									$('#contenedor-canal4').attr('class','col-xs-12 col-sm-6 col-md-6 col-lg-6 hide');
									
			  						actualizar_player2();
			  					}
								// 3. VISTA DE 1 CANAL (Lógica Original)
			  					else
			  					{
			  						$('[data-player=1]').parent().attr('class','col-xs-12 col-sm-8 col-md-8 col-lg-7 col-lg-offset-1');
									
									// Ocultar Canal 2, 3 y 4
			  						$('#contenedor-canal2').attr('class','col-xs-12 col-sm-6 col-md-6 col-lg-6 hide');
									$('#contenedor-canal3').attr('class','col-xs-12 col-sm-6 col-md-6 col-lg-6 hide');
									$('#contenedor-canal4').attr('class','col-xs-12 col-sm-6 col-md-6 col-lg-6 hide');
			  					}

			  					// Si el numero de sala recibido es null, significa que todos los canales están inactivos
			  					if (!b.nro_sala)
			  					{
			  						$('[data-player=1]').find('h2').html('SALA INACTIVA');
			  						$('[data-player=1]').attr('data-sala', -1);
			  						$('[data-player=1]').attr('data-canal', -1);
			  						player1(null, null);
			  					}
			  					else
			  					{
			  						$('[data-player=1]').attr('data-sala', b.nro_sala);
			  						$('[data-player=1]').attr('data-canal', b.nro_canal);

			  						if (b.iframe == 0)
					  				{
					  					if (b.url == null || b.rtmp == null)
						  					$('[data-player=1]').find('h2').html(b.nombre_sala + '<small> - canal inactivo</small>');
						  				else if (canal_1a4 == 0 && canal_1y2 == 0) // Si no es multivista, mostrar nombre completo
						  					$('[data-player=1]').find('h2').html(b.nombre_sala + '<small> - canal ' + b.nro_canal + '</small>');
											// Si es multivista, ya se asignó el título arriba
											
					  					$('[data-player=1] #player').remove();
					  					$('[data-player=1]').children('h2').after(
					  						'<a class="player" href="https://e1h13.simplecdn.net/flowplayer/flowplayer.flv" id="player"></a>');
					  					player1(b.url, b.rtmp);
					  				}
					  				else
					  				{
					  					if (b.src_iframe == '')
						  					$('[data-player=1]').find('h2').html(b.nombre_sala + '<small> - canal inactivo</small>');
						  				else if (canal_1a4 == 0 && canal_1y2 == 0)
						  					$('[data-player=1]').find('h2').html(b.nombre_sala + '<small> - canal ' + b.nro_canal + '</small>');

					  					$('[data-player=1] #player').remove();
					  					$('[data-player=1]').children('h2').after(
					  						'<iframe id="player" class="player" frameborder="0" src="'+b.src_iframe+'"allowfullscreen ></iframe>');
					  				}
			  					}

								// MODIFICADO: Pasar 0, 1 o 2 (si 4 canales está activo, pasa 2)
			  					modificar_menu(canal_1a4 == 1 ? 2 : canal_1y2); 

			  					$("[data-toggle=actualizar1]").removeAttr("disabled");
			  				}
			  			});
			  		}

			  		consultar_senal();

			  		$(function() {
			  			$('#menu').on('click', 'li.sub-menu ul a', function(e) {
							e.preventDefault();
							var nro_sala = $(this).attr('toggle_sala');
							var nro_canal = $(this).attr('toggle_canal');
							consultar_senal(nro_sala, nro_canal);
						});
			  		});

			  		$(function() {
			  			$(".actualizar-canal").click(function(){
				  			n = $(this).attr("data-toggle");
				  			if (n == 'actualizar2')
				  				actualizar_player2();
				  			else if (n == 'actualizar3') // NUEVO
								actualizar_player3();
							else if (n == 'actualizar4') // NUEVO
								actualizar_player4();
				  			else if (n == 'actualizar1')
				  			{
				  				s = $(this).parent().attr('data-sala');
				  				c = $(this).parent().attr('data-canal');
				  				actualizar_player1(s, c);
				  			}
				  		});
			  		});

					// MODIFICADA para incluir la lógica de 4 canales (canal_1a4)
			  		$(function(){setSizeAlerts();$(window).resize(function(){setSizeAlerts();});});function setSizeAlerts(){if(canal_1y2!=0 || canal_1a4!=0){if ($(window).width()<= 750){$("#contenido #menu").css("width","auto");$("#contenido #menu").attr("class","contenedor-menu");}else{$("#contenido #menu").removeClass("toggle-activo");$("#contenido #menu").css("width","300px");$("#contenido #menu").attr("class","contenedor-menu menu-oculto");$("#contenido #menu").parent().attr("class","col-xs-12 col-sm-3 col-md-3 col-lg-12");}}}

	      	</script>

		   </div>    </div></div><?php if ($_SESSION['tipo_usuario'] != 1) { ?>
		<script type="application/javascript">
			document.oncontextmenu = function(){
				return false
			}
			document.onkeypress = function (event) {
				event = (event || window.event);
				if (event.keyCode == 123) {
					return false;
				}
    		}
			document.onmousedown = function (event) {
				event = (event || window.event);
				if (event.keyCode == 123) {
					return false;
				}
			}
			document.onkeydown = function (event) {
				event = (event || window.event);
				if (event.keyCode == 123) {
					return false;
				}
			}
		</script>
	<?php } ?>

  <script type="application/javascript" src="librerias/bootstrap/js/bootstrap.min.js"></script>
  <script type="application/javascript" src="<?php echo 'js/'.INDEX_JS ?>"></script>

</body>
</html>