<?php

define('PAGINA', 'pago_enviado');

include '../sv/config.php';
include '../sv/clases/Notificacion.php';
include '../sv/clases/Logo.php';
include '../sv/clases/Pago.php';
include '../sv/clases/Usuario.php';

session_start();

$obj_notificacion = new Notificacion();
$obj_logo = new Logo();
$obj_usuario = new Usuario();
$obj_pago = new Pago();

if (!(isset($_SESSION['usuario'])) || !($_SESSION['tipo_usuario'])
   || $obj_usuario->verificarStatus($_SESSION['id_usuario'], $_SESSION['tipo_usuario']) == 0)
{
   header('Location: ../sv/controladores/logout.php');
}
else
{
   if ($obj_pago->status_pago($_SESSION['id_usuario']) == 'POR PAGAR')
      header('Location: pago_suscripcion.php');
}

$obj_notificacion->resetSessionCantidadCargada();

?>

<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta https-equiv="X-UA-Compatible" content="IE=edge">
	<title><?php printf($obj_logo->getNombreBd()) ?> - Pago enviado</title>
	<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/bootstrap/css/'.BOOTSTRAP_CSS ?>" />
	<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/'.MAIN_CSS ?>" />
	<style type="text/css">
		body { padding-top: 80px }
		.pago_enviado { text-align: center }
	</style>
</head>
<body>
	<?php require '../sv/headers/menu_principal_pago_suscripcion.php' ?>

	<div class="container-fluid">
		<div class="pago_enviado">
			<h3>El formulario de pago ha sido enviado satisfactoriamente.</h3>
			<p>En cuanto hayamos procesado su pago, le activaremos nuevamente su cuenta.</p>
		</div>
	</div> <!-- ./container-fluid -->

	<script type="application/javascript" src="/librerias/jquery/jquery/jquery-1.10.2.js"></script>
   <script type="application/javascript" src="/librerias/bootstrap/js/bootstrap.min.js"></script>
   <script type="application/javascript" src="<?php echo '/js/'.GLOBAL_JS ?>"></script>
</body>
</html>