<?php

define('PAGINA', 'pago_suscripcion');

include '../sv/config.php';
include '../sv/clases/Notificacion.php';
include '../sv/clases/Logo.php';
include '../sv/clases/Pago.php';
include '../sv/clases/Usuario.php';

session_start();

$obj_notificacion = new Notificacion();
$obj_logo = new Logo();
$obj_usuario = new Usuario();
$obj_pago = new Pago();

if (!(isset($_SESSION['usuario'])) || !($_SESSION['tipo_usuario'])
   || $obj_usuario->verificarStatus($_SESSION['id_usuario'], $_SESSION['tipo_usuario']) == 0)
{
   header('Location: ../sv/controladores/logout.php');
}
else
{
   if ($obj_pago->status_pago($_SESSION['id_usuario']) == 'ENVIADO')
      header('Location: pago_enviado.php');
}

$obj_notificacion->resetSessionCantidadCargada();

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="https://www.w3.org/1999/xhtml">
<head>
<meta https-equiv="Content-Type" content="text/html; charset=utf-8" />
<link href="../recursos/logo-shorcut.png" rel="shortcut icon" type="image/x-icon" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php printf($obj_logo->getNombreBd()) ?> - Formulario de pago</title>
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/bootstrap/css/'.BOOTSTRAP_CSS ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/'.MAIN_CSS ?>" />
<style type="text/css">
   body { padding-top: 80px }
   input[type=text]::-webkit-input-placeholder { color: #757575 }
   input[type=text]:-moz-placeholder { color: #757575 }
   input[type=text]::-moz-placeholder { color: #757575 }
   input[type=text]:-ms-input-placeholder { color: #757575 }
</style>
</head>

<body>
   <?php require '../sv/headers/menu_principal_pago_suscripcion.php' ?>
   <div class="container-fluid">
      <div class="row">
         <div id="contenido">
            <div class="col-xs-12 col-sm-8 col-sm-offset-2 col-md-8 col-md-offset-2 col-lg-6 col-lg-offset-3">
               <form id="form-pago-suscripcion">
                  <div class="formulario">
                     <div class="formulario-cbz">
                        <h4 class="panel-title">Anuncie su pago para ser activado:</h4>
                     </div>
                     <div class="formulario-cuerpo">
                        <span class="error"></span>
                        <div class="form-group">
                           <p>Banco cliente</p>
                           <select id="banco_cliente" data-toggle="requerido">
                              <option value="">Seleccionar</option>
                              <option value="0156">100%BANCO</option>
                              <option value="0196">ABN AMRO BANK</option>
                              <option value="0172">BANCAMIGA BANCO MICROFINANCIERO, C.A.</option>
                              <option value="0171">BANCO ACTIVO BANCO COMERCIAL, C.A.</option>
                              <option value="0166">BANCO AGRICOLA</option>
                              <option value="0175">BANCO BICENTENARIO</option>
                              <option value="0128">BANCO CARONI, C.A. BANCO UNIVERSAL</option>
                              <option value="0164">BANCO DE DESARROLLO DEL MICROEMPRESARIO</option>
                              <option value="0102">BANCO DE VENEZUELA S.A.I.C.A.</option>
                              <option value="0114">BANCO DEL CARIBE C.A.</option>
                              <option value="0149">BANCO DEL PUEBLO SOBERANO C.A.</option>
                              <option value="0163">BANCO DEL TESORO</option>
                              <option value="0176">BANCO ESPIRITO SANTO, S.A.</option>
                              <option value="0115">BANCO EXTERIOR C.A.</option>
                              <option value="0003">BANCO INDUSTRIAL DE VENEZUELA.</option>
                              <option value="0173">BANCO INTERNACIONAL DE DESARROLLO, C.A.</option>
                              <option value="0105">BANCO MERCANTIL C.A.</option>
                              <option value="0191">BANCO NACIONAL DE CREDITO</option>
                              <option value="0116">BANCO OCCIDENTAL DE DESCUENTO.</option>
                              <option value="0138">BANCO PLAZA</option>
                              <option value="0108">BANCO PROVINCIAL BBVA</option>
                              <option value="0104">BANCO VENEZOLANO DE CREDITO S.A.</option>
                              <option value="0168">BANCRECER S.A. BANCO DE DESARROLLO</option>
                              <option value="0134">BANESCO BANCO UNIVERSAL</option>  
                              <option value="0177">BANFANB</option>
                              <option value="0146">BANGENTE</option>
                              <option value="0174">BANPLUS BANCO COMERCIAL C.A</option>
                              <option value="0190">CITIBANK.</option>
                              <option value="0121">CORP BANCA.</option>
                              <option value="0157">DELSUR BANCO UNIVERSAL</option>
                              <option value="0151">FONDO COMUN</option>
                              <option value="0601">INSTITUTO MUNICIPAL DE CR&#201;DITO POPULAR</option>
                              <option value="0169">MIBANCO BANCO DE DESARROLLO, C.A.</option>
                              <option value="0137">SOFITASA</option>
                           </select>
                           <span class="error"></span>
                        </div> <!-- /.form-group -->
                        <div class="form-group">
                           <p>Banco depositado</p>
                           <select id="banco_deposito" data-toggle="requerido">
                              <option value="">Seleccionar</option>
                              <option value="0156">100%BANCO</option>
                              <option value="0196">ABN AMRO BANK</option>
                              <option value="0172">BANCAMIGA BANCO MICROFINANCIERO, C.A.</option>
                              <option value="0171">BANCO ACTIVO BANCO COMERCIAL, C.A.</option>
                              <option value="0166">BANCO AGRICOLA</option>
                              <option value="0175">BANCO BICENTENARIO</option>
                              <option value="0128">BANCO CARONI, C.A. BANCO UNIVERSAL</option>
                              <option value="0164">BANCO DE DESARROLLO DEL MICROEMPRESARIO</option>
                              <option value="0102">BANCO DE VENEZUELA S.A.I.C.A.</option>
                              <option value="0114">BANCO DEL CARIBE C.A.</option>
                              <option value="0149">BANCO DEL PUEBLO SOBERANO C.A.</option>
                              <option value="0163">BANCO DEL TESORO</option>
                              <option value="0176">BANCO ESPIRITO SANTO, S.A.</option>
                              <option value="0115">BANCO EXTERIOR C.A.</option>
                              <option value="0003">BANCO INDUSTRIAL DE VENEZUELA.</option>
                              <option value="0173">BANCO INTERNACIONAL DE DESARROLLO, C.A.</option>
                              <option value="0105">BANCO MERCANTIL C.A.</option>
                              <option value="0191">BANCO NACIONAL DE CREDITO</option>
                              <option value="0116">BANCO OCCIDENTAL DE DESCUENTO.</option>
                              <option value="0138">BANCO PLAZA</option>
                              <option value="0108">BANCO PROVINCIAL BBVA</option>
                              <option value="0104">BANCO VENEZOLANO DE CREDITO S.A.</option>
                              <option value="0168">BANCRECER S.A. BANCO DE DESARROLLO</option>
                              <option value="0134">BANESCO BANCO UNIVERSAL</option>  
                              <option value="0177">BANFANB</option>
                              <option value="0146">BANGENTE</option>
                              <option value="0174">BANPLUS BANCO COMERCIAL C.A</option>
                              <option value="0190">CITIBANK.</option>
                              <option value="0121">CORP BANCA.</option>
                              <option value="0157">DELSUR BANCO UNIVERSAL</option>
                              <option value="0151">FONDO COMUN</option>
                              <option value="0601">INSTITUTO MUNICIPAL DE CR&#201;DITO POPULAR</option>
                              <option value="0169">MIBANCO BANCO DE DESARROLLO, C.A.</option>
                              <option value="0137">SOFITASA</option>
                           </select>
                           <span class="error"></span>
                        </div> <!-- /.form-group -->
                        <div class="form-group">
                           <p>Fecha de operación</p>
                           <input type="text" id="fecha" data-toggle="requerido"
                              placeholder="Ejemplo: 26/01/2016">
                           <span class="error"></span>
                        </div> <!-- /.form-group -->
                        <div class="form-group">
                           <p>Número de depósito</p>
                           <input type="text" id="referencia" data-toggle="requerido">
                           <span class="error"></span>
                        </div> <!-- /.form-group -->
                        <div class="form-group">
                           <p>Monto total</p>
                           <input type="text" id="monto" data-toggle="requerido">
                           <span class="error"></span>
                        </div> <!-- /.form-group -->
                        <div class="form-group">
                           <p>Comentario</p>
                           <textarea id="comentario"></textarea>
                           <span class="error"></span>
                        </div> <!-- /.form-group -->
                     </div> <!-- /.formulario-cuerpo -->
                     <div class="formulario-pie">
                        <button type="reset" class="btn btn-info" id="limpiar">Limpiar</button>
                        <button type="submit" class="btn btn-info" id="enviar_preguntas">Enviar</button>
                     </div> <!-- /.formulario-pie -->
                  </div> <!-- /.formulario -->
               </form>
            </div> <!-- /col-* -->
         </div>  <!-- #contenido -->
      </div> <!-- /.row -->
   </div> <!-- /.container-fuild -->

   <div class="modal" id="confirmar_pago_suscripcion" tabindex="-1" role="dialog"
      aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
         <div class="modal-content">
            <div class="modal-header">
               <button type="button" class="close" data-dismiss="modal">
                  <span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
               </button>
               <h4 class="modal-title" id="myModalLabel">Confirmar pago</h4>
            </div>
            <div class="modal-body">
               <p>
                  <span class="glyphicon glyphicon-warning-sign"></span>
                  Se enviará el formulario de pago. ¿Desea continuar?
               </p>
            </div>
            <div class="modal-footer">
               <button type="button" id="cancelar_btn" data-dismiss="modal"
                  class="btn btn-info">Cancelar</button>
               <button type="button" id="continuar_btn" class="btn btn-info">Continuar</button>
            </div>
         </div> <!-- /.modal-content -->
      </div> <!-- /.modal-dialog -->
   </div> <!-- /.modal -->

   <script type="application/javascript" src="/librerias/jquery/jquery/jquery-1.10.2.js"></script>
   <script type="application/javascript" src="/librerias/bootstrap/js/bootstrap.min.js"></script>
   <script type="application/javascript" src="<?php echo '/js/'.GLOBAL_JS ?>"></script>
   
   <script type="text/javascript">
      function validar_form() {
         var aux = true;
         $('[data-toggle="requerido"]').each(function () {
            if (!$('#banco_cliente').val()) {
               aux = false;
               $('#banco_cliente').addClass('requerido');
               $('#banco_cliente').next('.error').html('Seleccione el banco cliente');
            }
            if (!$('#banco_deposito').val()) {
               aux = false;
               $('#banco_deposito').addClass('requerido');
               $('#banco_deposito').next('.error').html('Seleccione el banco depositado');
            }
            if ($('#fecha').val() == null || $('#fecha').val().length == 0 ||
               /^\s+$/.test($('#fecha').val()))
            {
               aux = false;
               $('#fecha').addClass('requerido');
               $('#fecha').next('.error').html('Ingrese fecha de operación');
            }
            else if (!/(^(((0[1-9])|(1[0-9])|(2[0-9])|(3[0-1])|([1-9]))[-|/]((0[1-9])|(1[0-2])|([1-9]))[-|/]([0-9]{4}))$)/.test($('#fecha').val()))
            {
               aux = false;
               $('#fecha').addClass('requerido');
               $('#fecha').next('.error').html('Ingrese una fecha de válida');
            }
            if ($('#referencia').val() == null || $('#referencia').val().length == 0 ||
               /^\s+$/.test($('#referencia').val()))
            {
               aux = false;
               $('#referencia').addClass('requerido');
               $('#referencia').next('.error').html('Ingrese número de depósito');
            }
            else if (!/(^([0-9]+)$)/.test($('#referencia').val())) {
               aux = false;
               $('#referencia').addClass('requerido');
               $('#referencia').next('.error').html('Ingrese número de depósito válido');
            }
            if ($('#monto').val() == null || $('#monto').val().length == 0 ||
               /^\s+$/.test($('#monto').val()))
            {
               aux = false;
               $('#monto').addClass('requerido');
               $('#monto').next('.error').html('Ingrese el monto');
            }
            else if (!/(^([0-9]+([.|,]{1}[0-9]+){0,1})$)/.test($('#monto').val())) {
               aux = false;
               $('#monto').addClass('requerido');
               $('#monto').next('.error').html('Ingrese un monto válido');
            }
         });
         return aux;
      }

      function enviar_form() {
         $.ajax({
            cache: false,
            dataType: 'JSON',
            type: 'POST',
            url: url_controladores,
            data: {
               accion: 'enviar_pago_suscripcion',
               banco_cliente: $('#banco_cliente option:selected').text(),
               banco_deposito: $('#banco_deposito option:selected').text(),
               fecha: $('#fecha').val(),
               referencia: $('#referencia').val(),
               monto: $('#monto').val(),
               comentario: $('#comentario').val()
            },
            beforeSend: function() {
               $('button, input, select, textarea').attr('disabled', 'disabled');
            },
            success: function(data) {
               if (data.datos == 1)
                  window.location = '/cl/pago_enviado.php';
               else
                  alert(error_general);
               $('button, input, select, textarea').removeAttr('disabled');
               $('#confirmar_pago_suscripcion').modal('hide');
            },
            error: function() {
               alert(error_general);
            }
         });
      }

      $('#form-pago-suscripcion').submit(function (event) {
         event.preventDefault();
         if (validar_form() == true)
           $('#confirmar_pago_suscripcion').modal('show');
      });

      $('#confirmar_pago_suscripcion #continuar_btn').click( function() {
         enviar_form();
      });
   </script>

</body>
</html>