<?php

define('PAGINA', 'preguntas');

include '../sv/config.php';
include '../sv/clases/Notificacion.php';
include '../sv/clases/Logo.php';
include '../sv/clases/Usuario.php';

session_start();

$obj_notificacion = new Notificacion();
$obj_logo = new Logo();
$obj_usuario = new Usuario();

if (!(isset($_SESSION['usuario'])) || !($_SESSION['tipo_usuario'])
   || $obj_usuario->verificarStatus($_SESSION['id_usuario'], $_SESSION['tipo_usuario']) == 1)
{
   header('Location: ../sv/controladores/logout.php');
}
else
{
   switch ($obj_usuario->inicio($_SESSION['id_usuario']))
   {
		case 1:
			if ($_SESSION['tipo_usuario'] == 5)
            header('Location: ../mix/index.php');
         else
            header('Location: /');
         break;
	}
}

$obj_usuario->actualizarOnline(time(), $_SESSION['id_usuario']);

$obj_notificacion->resetSessionCantidadCargada();

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="https://www.w3.org/1999/xhtml">
<head>
<meta https-equiv="Content-Type" content="text/html; charset=utf-8" />
<link href="/recursos/logo-shorcut.png" rel="shortcut icon" type="image/x-icon" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php printf($obj_logo->getNombreBd()) ?> - preguntas de seguridad</title>
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/bootstrap/css/'.BOOTSTRAP_CSS ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/'.MAIN_CSS ?>" />
<style type="text/css"> body { padding-top:72px; padding-bottom:20px } </style>
</head>

<body>

   <?php require '../sv/headers/menu_principal_preguntas.php' ?>

   <div class="container-fluid">
      <div class="row">
         <div id="contenido">
            <div class="col-xs-12 col-sm-8 col-sm-offset-2 col-md-8 col-md-offset-2 col-lg-6 col-lg-offset-3">
               <h4 class="text-warning">
                  <strong>IMPORTANTE:</strong>
                     La pregunta de seguridad sirve para evitar que su cuenta
                     sea vulnerada. Por ello, frecuentemente el sistema le solicitará
                     que ingrese la respuesta a la pregunta de seguridad que usted haya seleccionado.<br><br>
                     <strong>Le recomendamos seleccionar una pregunta y una respuesta
                     que pueda recordar fácilmente.</strong>
               </h4>
               <form id="formPreguntas" name="formPreguntas">
                  <div class="formulario">
                     <div class="formulario-cbz">
                        <h4 class="panel-title">Seleccione y responda la pregunta de seguridad:</h4>
                     </div>
                     <div class="formulario-cuerpo">
                        <span class="error"></span>
                        <div class="form-group">
                           <p>Seleccione una pregunta</p>
                           <select id="pregunta1" name="pregunta1" data-toggle="requerido">
                              <option value="">Seleccionar</option>
                              <option value="1">¿Donde nació tu padre?</option>
                              <option value="2">¿Nombre de tu mejor amigo de la infancia?</option>
                              <option value="3">¿Nombre de tu abuela materna?</option>
                              <option value="4">¿Cuál es el personaje histórico favorito de tu madre?</option>
                              <option value="5">¿Nombre de tu abuelo paterno?</option>
                           </select>
                           <span class="error"></span>
                        </div> <!-- /.form-group -->
                        <div class="form-group">
                           <p>Escriba su respuesta</p>
                           <input type="text" id="respuesta1" name="respuesta1" data-toggle="requerido">
                           <span class="error"></span>
                        </div> <!-- /.form-group -->
                        <div class="form-group">
                           <p>Escriba nuevamente su respuesta</p>
                           <input type="text" id="respuesta1_conf" name="respuesta1_conf" data-toggle="requerido">
                           <span class="error"></span>
                        </div> <!-- /.form-group -->
                     </div> <!-- /.formulario-cuerpo -->
                     <div class="formulario-pie">
                        <button type="reset" class="btn btn-info" id="limpiar">Limpiar</button>
                        <button type="submit" class="btn btn-info" id="enviar_preguntas">Guardar</button>
                     </div> <!-- /.formulario-pie -->
                  </div> <!-- /.formulario -->
               </form>
            </div> <!-- /col-* -->
         </div>  <!-- #contenido -->
      </div> <!-- /.row -->
   </div> <!-- /.container-fuild -->

   <div class="modal" id="confirmar_respuestas" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
         <div class="modal-content">
            <div class="modal-header">
               <button type="button" class="close" data-dismiss="modal">
                  <span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
               </button>
               <h4 class="modal-title" id="myModalLabel">Confirmar pregunta de seguridad</h4>
            </div>
            <div class="modal-body">
               <p>
                  <span class="glyphicon glyphicon-warning-sign"></span>
                  Su pregunta y respuesta quedará registrado en el sistema. ¿Desea continuar?
               </p>
            </div>
            <div class="modal-footer">
               <button type="button" id="cancelar_btn" class="btn btn-info">Cancelar</button>
               <button type="button" id="continuar_btn" class="btn btn-info">Continuar</button>
            </div>
         </div> <!-- /.modal-content -->
      </div> <!-- /.modal-dialog -->
   </div> <!-- /.modal -->

   <script type="application/javascript" src="/librerias/jquery/jquery/jquery-1.10.2.js"></script>
   <script type="application/javascript" src="/librerias/bootstrap/js/bootstrap.min.js"></script>
   <script type="application/javascript" src="<?php echo '/js/'.GLOBAL_JS ?>"></script>
   <script type="application/javascript" src="<?php echo '/js/'.PREGUNTAS_JS ?>"></script>

</body>
</html>