<?php

define('PAGINA', 'susp');

include '../sv/config.php';
include '../sv/clases/Notificacion.php';
include '../sv/clases/Suscripcion.php';
include '../sv/clases/Logo.php';
include '../sv/clases/Session.php';

session_start();

switch ($_SESSION['tipo_usuario'])
{
   case 1:
      include '../sv/clases/SuperAdministrador.php';
      $obj_usuario = new SuperAdministrador();
      break;
   case 2:
      include '../sv/clases/Administrador.php';
      $obj_usuario = new Administrador();
      break;
}

$obj_notificacion = new Notificacion();
$obj_suscripcion = new Suscripcion();
$obj_logo = new Logo();

if (!(isset($_SESSION['usuario'])) || ($_SESSION['tipo_usuario'] > 2)
   || $obj_usuario->verificarStatus($_SESSION['id_usuario'], $_SESSION['tipo_usuario']) == 1)
{
   header('Location: ../sv/controladores/logout.php');
}
else
{
   /*if ( consultar_ip($_SESSION['id_usuario']) != $_SESSION['ip'] ) # Para versión sin preguntas de seguridad
      header("Location: ../sv/logout.php");*/

   if ($obj_usuario->consultarValorIp($_SESSION['id_usuario']) != $_SESSION['ip'])
      header('Location: responder.php');
   else
   {
      switch ($obj_usuario->inicio($_SESSION['id_usuario']))
      {
         case 0: # Usuario nuevo
         case 2: # Preguntas de seguridad restablecidas
            header("Location: preguntas.php");
            break;
      }
   }
}

$obj_usuario->actualizarOnline(time(), $_SESSION['id_usuario']);
$obj_suscripcion->entradaSuscripcion();

$id_usuario_get = (isset($_GET['id_usuario']) && $_GET['id_usuario'] >=1) ? $_GET['id_usuario'] : 0;
$filtro_priv_get = (isset($_GET['priv'])) ? $obj_usuario->procesarFiltroPriv($_GET['priv']) : 0;
$pag_num_get = (isset($_GET['pag']) && $_GET['pag'] >=1) ? $_GET['pag'] : 1;
$busqueda_get = (isset($_GET['buscar']) && $_GET['buscar'] != null) ? $_GET['buscar'] : null;
$id_administrador_get = (isset($_GET['administrador']) && $_GET['administrador'] >=1) ? $_GET['administrador'] : 0;

$obj_notificacion->resetSessionCantidadCargada();

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="https://www.w3.org/1999/xhtml">
<head>
<meta https-equiv="Content-Type" content="text/html; charset=utf-8" />
<link href="../recursos/logo-shorcut.png" rel="shortcut icon" type="image/x-icon" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php printf($obj_logo->getNombreBd()) ?> - usuarios suspendidos</title>
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/bootstrap/css/'.BOOTSTRAP_CSS ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/'.MAIN_CSS ?>" />
<link type="text/css" rel="stylesheet" href="/librerias/jquery/css/jquery-ui-1.10.4.custom.min.css" />
<style type="text/css"> body { padding-top: 107px } </style>
</head>

<body>
   <input id="campo_hidden" type="hidden" value="<?php echo PAGINA ?>" />
   <input id="sesion_hidden" type="hidden" value="<?php echo $_SESSION['tipo_usuario'] ?>" />
   <input id="id_usuario_hidden" type="hidden" value="<?php echo $id_usuario_get ?>" />
   <input id="filtro_priv_hidden" type="hidden" value="<?php echo $filtro_priv_get ?>" />
   <input id="pag_num_hidden" type="hidden" value="<?php echo $pag_num_get ?>" />
   <input id="busqueda_hidden" type="hidden" value="<?php echo $busqueda_get ?>" />
   <input id="administrador_hidden" type="hidden" value="<?php echo $id_administrador_get ?>" />

   <?php require '../sv/headers/menu_principal_admin.php' ?>

   <div class="container-fluid">
      <div class="row">
         <div id="contenido">
            <?php echo $obj_usuario->__vistaUsuariosHtml(PAGINA, $id_usuario_get, $busqueda_get,
               $id_administrador_get, $pag_num_get, $filtro_priv_get) ?>
         </div> <!-- /#contenido -->
      </div> <!-- /.row -->
   </div> <!-- /.container -->

   <div class="modal" id="modal_usuario" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
         <div class="modal-content">
            <!-- -->
         </div> <!-- /.modal-content -->
      </div> <!-- /.modal-dialog -->
   </div> <!-- /.modal #usuario_usuario -->

   <div class="modal bs-example-modal-lg" id="modal_canales" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog modal-lg">
         <div class="modal-content">
            <!-- -->
         </div> <!-- /.modal-content -->
      </div> <!-- /.modal-dialog -->
   </div> <!-- /.modal -->

   <div class="modal" id="modal_confirmar" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
         <div class="modal-content">
            <div class="modal-header">
               <button type="button" class="close" data-dismiss="modal">
                  <span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
               </button>
               <h4 class="modal-title" id="myModalLabel"></h4>
            </div> <!-- /.modal-header -->
            <div class="modal-body">
               <!-- -->
            </div> <!-- /.modal-body -->
            <div class="modal-footer">
               <button type="button" class="btn btn-info" data-dismiss="modal">Cancelar</button>
               <button type="button" id="btn_confirmar" class="btn btn-info">Continuar</button>
            </div> <!-- /.modal-footer -->
         </div> <!-- /.modal-content -->
      </div> <!-- /.modal-dialog -->
   </div> <!-- /.modal confirmar-->

   <?php if ($_SESSION['tipo_usuario'] == 1) { ?>

      <div class="modal bs-example-modal-sm" id="modal_logo" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel" aria-hidden="true">
         <div class="modal-dialog modal-sm">
            <div class="modal-content">
               <form id="form-logo">
                  <div class="modal-header">
                     <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
                     </button>
                     <h4 class="modal-title" id="myModalLabel">Modificar logo</h4>
                  </div>
                  <div class="modal-body" >
                     <div class="form-group">
                        <p>Nombre</p>
                        <input type="text" id="nombre_logo" data-toggle="requerido" /><span class="error"></span>
                     </div>
                  </div>
                  <div class="modal-footer">
                     <button type="button" class="btn btn-info" data-dismiss="modal">Cancelar</button>
                     <button type="submit" id="continuar_btn_logo" class="btn btn-info">Guardar cambios</button>
                  </div>
               </form>
            </div> <!-- /.modal-content -->
         </div> <!-- /.modal-dialog -->
      </div> <!-- /#modal-logo -->

      <div class="modal bs-example-modal-lg" id="modal_responsable" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel" aria-hidden="true">
         <div class="modal-dialog modal-lg">
            <div class="modal-content">
               <!-- -->
            </div> <!-- /.modal-content -->
         </div> <!-- /.modal-dialog -->
      </div> <!-- /.modal #usuario_usuario -->

      <div class="modal bs-example-modal-md" id="modal_marquesina" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel" aria-hidden="true">
         <div class="modal-dialog modal-md">
            <div class="modal-content">
               <!-- -->
            </div> <!-- /.modal-content -->
         </div> <!-- /.modal-dialog -->
      </div> <!-- /#modal-marquesina -->

   <?php } ?>

   <?php if ($_SESSION['tipo_usuario'] != 1) { ?>
      <script type="application/javascript">
         document.oncontextmenu = function(){
            return false
         }
         document.onkeypress = function (event) {
            event = (event || window.event);
            if (event.keyCode == 123) {
               return false;
            }
         }
         document.onmousedown = function (event) {
            event = (event || window.event);
            if (event.keyCode == 123) {
               return false;
            }
         }
         document.onkeydown = function (event) {
            event = (event || window.event);
            if (event.keyCode == 123) {
               return false;
            }
         }
      </script>
   <?php } ?>

   <script type="application/javascript" src="/librerias/jquery/jquery/jquery-1.10.2.js"></script>
   <script type="application/javascript" src="/librerias/bootstrap/js/bootstrap.min.js"></script>
   <script type="application/javascript"
      src="/librerias/jquery/js/jquery-ui-1.10.4.custom.min.js"></script>
   <script type="application/javascript"
      src="/librerias/bootstrap-switch-master/dist/js/bootstrap-switch.min.js"></script>
   <script type="application/javascript" src="<?php echo '/js/'.GLOBAL_JS ?>"></script>
   <script type="application/javascript" src="<?php echo '/js/'.ADMIN_JS ?>"></script>
   <script type="application/javascript" src="<?php echo '/js/'.CANALES_JS ?>"></script>

</body>
</html>