/**
 * ¡¡¡ Variables globales temporales !!!
 */
var checkboxes_seleccionados = [];
var checkboxes_seleccionados2 = [];
var array_fixed = [];

$(document).ready(function () {

	function actualizarPagina() {
		$.ajax({
			cache: false,
			dataType: 'JSON',
			type: 'POST',
			url: url_controladores,
			data: { accion: 'actualizar_pagina_set_interval' },
			success: function(data) {
				if (data.datos != 0) {
					window.location = url_controlador_logout;
				}
				if (data.notificaciones > 0) {
					$('li.notificaciones a').empty().append(
						'Notificaciones <span class="badge">'+data.notificaciones+'</span>');
				}
			}
		});
	} setInterval(actualizarPagina, 210000);

	/**
	 * [Estructura de la clase Autocompletar]
	 */
	var Autocompletar = function()
	{
		var __this = this;

		this.busquedaTodos = function()
		{
			var vista = $("#campo_hidden").val();
			var administrador = $('#administrador_hidden').val();

			$('#campo_busqueda').autocomplete({
				source: '/sv/autocompletar.php?'+vista+'&administrador='+administrador, delay: 0, minLength: 1,
				select: function(event, ui) {
					$("#campo_busqueda").val(ui.item.label);
					administrador = (administrador != 0) ? 'administrador='+administrador+'&' : '';
					location.assign('/cl/'+vista+'.php?'+administrador+'id_usuario='+ui.item.id);
					return false;
				}
			}).data('ui-autocomplete')._renderItem = function(ul, item) {
				if (vista == 'todos' || vista == 'mis_usuarios')
				{
					return $('<li>').append(
						'<a style="padding:8px 0 8px 15px"><i style="padding-right:7px" class="glyphicon glyphicon-user"></i>'+
						item.label+'<span style="color:'+item.color+'"> '+item.estado+'</span></a>').appendTo(ul);
				}
				else
				{
					return $('<li>').append(
						'<a style="padding:8px 0 8px 15px"><i style="padding-right:7px" class="glyphicon glyphicon-user"></i>'+
						item.label+'</a>').appendTo(ul);
				}
			};
		} // [busquedaTodos::Autocompletar]

	} // [fin Clase Autocompletar]

	function initElementos() {
		$("[name*='my-checkbox']").bootstrapSwitch({'size': 'small', 'onColor': 'default', 'offColor': 'primary'});
		$("button, a, i, .estado").tooltip();
		new Autocompletar().busquedaTodos();
	} initElementos();

	function bloquear() {
		$('.modal input, .modal button, .modal textarea, .modal a, .modal select').attr('disabled', 'disabled');
	}

	function desbloquear() {
		$('.modal input, .modal button, .modal textarea, .modal a, .modal select').removeAttr('disabled');
	}

	function cerrarModal() {
		$('.modal').modal('hide');
	}

	$(function() {
		$(window).scroll(function () {
			$('#campo_busqueda').autocomplete('close');
		});
	});

	$(function() {
		var modal_usuario = $('#modal_usuario');
		$(modal_usuario).on('hidden.bs.modal', function () {
			modal_usuario.find('.modal-content').html('');
		});
	});

	/**
	 * [Una solución momentánea para el problema
	 *  (el código se ejecuta varias veces cuando envío el form)]
	 */
	function restablecerModalConfirmar()
	{
		$('#modal_confirmar').remove();
		$('#modal_canales').after(
			'<div class="modal" id="modal_confirmar" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"'+
			'aria-hidden="true"><div class="modal-dialog"><div class="modal-content"><div class="modal-header">'+
			'<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span>'+
			'<span class="sr-only">Close</span></button><h4 class="modal-title" id="myModalLabel"></h4></div>'+
			'<div class="modal-body"></div><div class="modal-footer"><button type="button" class="btn btn-info"'+
			'data-dismiss="modal">Cancelar</button><button type="button" id="btn_confirmar" class="btn btn-info">'+
			'Continuar</button></div></div></div></div>');
	}

	/**
	 * [Seleccionar todos los check]
	 */
	$(document).on('click', '.marcar-todos', function(event) {
		event.preventDefault();
		var accion_marcar = $(this).attr('data-accion');
		if (accion_marcar == 'unchecked')
		{
			$(this).attr('data-accion', 'onchecked');
			$(this).children('i').attr('class', 'glyphicon glyphicon-check');
			$('input[name="my-checkbox"], input[name="my-checkbox2"], input[name="my-checkbox-todos1"], ' +
				'input[name="my-checkbox-todos2"]').bootstrapSwitch('state', false);
		}
		if (accion_marcar == 'onchecked')
		{
			$(this).attr('data-accion', 'unchecked');
			$(this).children('i').attr('class', 'glyphicon glyphicon-unchecked');
			$('input[name="my-checkbox"], input[name="my-checkbox2"], input[name="my-checkbox-todos1"], ' +
				'input[name="my-checkbox-todos2"]').bootstrapSwitch('state', true);
		}
	});

	/**
	 * [Estructura de la clase UsuarioAdmin]
	 */
	var UsuarioAdmin = function()
	{
		var __this = this;

		function consultaNombreResponsable(id_responsable)
		{
			if (id_responsable != 0)
			{
				$('.responsable a').hide();
				$.post(url_controladores, { accion: 'consultar_nombre_responsable',
		         id_responsable: id_responsable }, function (data) {
		         $('#id_responsable').val(id_responsable);
					$('#nombre_responsable').removeAttr('class');
					$('#nombre_responsable').html('Responsable: ' + data.datos);
		      }, 'json');
			}
		}

		function seleccionUsuariosPermitidos()
	   {
	      var seleccion = [];

	      $('.permitidos input[name="check_permitidos"]').each(function () {
	         if ($(this).prop('checked') == true)
	            seleccion.push($(this).val());
	      });

	      return (seleccion.length) ? seleccion : [null];
	   }

	   function cantidadUsuariosPermitidos()
	   {
	   	var cantidades = [0, 0, 0];
	   	var i = 0;

	   	$('input[name="cantidad_permitidos"]').each(function () {
	   		cantidades[i] = parseInt($(this).val());
	   		i++;
	   	});

	   	return (cantidades.length) ? cantidades : '';
	   }

	   function seleccionDiasSuscripcion()
	   {
	      var seleccion = [];

	      $('input[name="checkdias"]').each(function () {
	         if ($(this).prop('checked') == true)
	            seleccion.push($(this).val());
	      });

	      return (seleccion.length) ? seleccion : '';
	   }

		this.nuevoUsuario = function()
		{
			var accion = 'nuevo_usuario';
			var pag_actual_get = $("#campo_hidden").val();
			var busqueda_get = $('#busqueda_hidden').val();
			var administrador_get = $('#administrador_hidden').val();
			var nro_pag_get = $('#pag_num_hidden').val();
			var filtro_priv_get = $('#filtro_priv_hidden').val();
			var id_usuario_get = $('#id_usuario_hidden').val();
			var nombre = $("#nombre").val();
			var clave = $("#clave").val();
			var privilegios = $("#tipo_usuario").val();
			var control_cantidad = $("#control_cantidad").val();
			var suscripcion = $("#modal_usuario #suscripcion").val();
			var tiempo_suscripcion = $("#modal_usuario #tiempo_suscripcion").val();
			var dias_suscripcion = seleccionDiasSuscripcion();
			var usuarios_permitidos = seleccionUsuariosPermitidos();
			var cantidad_usuarios_permitidos = cantidadUsuariosPermitidos();
			var id_responsable = $('#id_responsable').val();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: "POST",
				url: url_controladores,
				data: {
					accion: accion,
					pag_actual_get: pag_actual_get,
					administrador_get: administrador_get,
					nro_pag_get: nro_pag_get,
					busqueda_get: busqueda_get,
					filtro_priv_get: filtro_priv_get,
					id_usuario_get: id_usuario_get,
					nombre: nombre,
					clave: clave,
					privilegios: privilegios,
					control_cantidad: control_cantidad,
					suscripcion: suscripcion,
					tiempo_suscripcion: tiempo_suscripcion,
					dias_suscripcion: dias_suscripcion,
					usuarios_permitidos: usuarios_permitidos,
					cantidad_usuarios_permitidos: cantidad_usuarios_permitidos,
					id_responsable: id_responsable
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					if (data.datos == 1)
					{
						$('#contenido').html(data.table);
						cerrarModal();
						initElementos();
					}
					if (data.datos == 2)
						$('#nombre').next('.error').html('Ya existe un usuario con este nombre.');
					if (data.datos == 3)
						$('#tipo_usuario').next('.error').html('Has excedido el límite de cuentas.');
					if (data.datos == 4)
						$('#tipo_usuario').next('.error').html('No tienes permitido crear este tipo de usuario.');
					if (data.datos == 5)
					{
						$('[data-toggle="expandir_responsable"] .responsable').next('.error')
							.html('Verifique los usuarios permitidos del responsable y su tope.');
					}
					desbloquear();
				},
				error: function() {
					alert(error_general);
				}
			});
		} // [nuevoUsuario::UsuarioAdmin]

		this.modificarUsuario = function(id_usuario_modificar)
		{
			var accion = 'modificar_usuario';
			var pag_actual_get = $("#campo_hidden").val();
			var nro_pag_get = $('#pag_num_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();
			var administrador_get = $('#administrador_hidden').val();
			var filtro_priv_get = $('#filtro_priv_hidden').val();
			var id_usuario_get = $('#id_usuario_hidden').val();
			var nombre = $("#nombre").val();
			var clave_nueva = $("#clave_nueva").val();
			var clave_confirmar = $("#clave_confirmar").val();
			var privilegios = $("#tipo_usuario").val();
			var control_cantidad = $("#control_cantidad").val();
			var suscripcion = $("#modal_usuario #suscripcion").val();
			var tiempo_suscripcion = $("#modal_usuario #tiempo_suscripcion").val();
			var dias_suscripcion = seleccionDiasSuscripcion();
			var usuarios_permitidos = seleccionUsuariosPermitidos();
			var cantidad_usuarios_permitidos = cantidadUsuariosPermitidos();
			var id_responsable = $('#id_responsable').val();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: "POST",
				url: url_controladores,
				data: {
					accion: accion,
					pag_actual_get: pag_actual_get,
					busqueda_get: busqueda_get,
					administrador_get: administrador_get,
					nro_pag_get: nro_pag_get,
					filtro_priv_get: filtro_priv_get,
					id_usuario_get: id_usuario_get,
					id_usuario_modificar: id_usuario_modificar,
					nombre: nombre,
					clave_nueva: clave_nueva,
					clave_confirmar: clave_confirmar,
					privilegios: privilegios,
					control_cantidad: control_cantidad,
					suscripcion: suscripcion,
					tiempo_suscripcion: tiempo_suscripcion,
					dias_suscripcion: dias_suscripcion,
					usuarios_permitidos: usuarios_permitidos,
					cantidad_usuarios_permitidos: cantidad_usuarios_permitidos,
					id_responsable: id_responsable
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					if (data.datos == 1)
					{
						$('#contenido').html(data.table);
						cerrarModal();
						initElementos();
						new Notificacion().mostrarCantidadPendientes(data.notificaciones);
					}
					if (data.datos == 2)
						$('#nombre').next('.error').html('Ya existe un usuario con este nombre.');
					if (data.datos == 3)
						$('#tipo_usuario').next('.error').html('Has excedido el límite de cuentas.');
					if (data.datos == 4)
						$('#tipo_usuario').next('.error').html('No tienes permitido crear este tipo de usuario.');
					if (data.datos == 5)
					{
						$('[data-toggle="expandir_responsable"] .responsable').next('.error')
							.html('Verifique los usuarios permitidos del responsable y su tope.');
					}
					desbloquear();
				},
				error: function() {
					alert(error_general);
				}
			});
		} // [modificarUsuario::UsuarioAdmin]

		this.eliminarUsuario = function(id_usuario_eliminar)
		{
			var accion = 'eliminar_usuario';
			var pag_actual_get = $("#campo_hidden").val();
			var busqueda_get = $('#busqueda_hidden').val();
			var administrador_get = $('#administrador_hidden').val();
			var filtro_priv_get = $('#filtro_priv_hidden').val();
			var nro_pag_get = $('#pag_num_hidden').val();
			var id_usuario_get = $('#id_usuario_hidden').val();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: accion,
					pag_actual_get: pag_actual_get,
					id_usuario_eliminar: id_usuario_eliminar,
					busqueda_get: busqueda_get,
					filtro_priv_get: filtro_priv_get,
					nro_pag_get: nro_pag_get,
					id_usuario_get: id_usuario_get,
					administrador_get: administrador_get
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					$('#contenido').html(data.table);
					initElementos();
					cerrarModal();
					desbloquear();
					restablecerModalConfirmar();
				},
				error: function() {
					alert(error_general);
				}
			});
		} // [eliminarUsuario::UsuarioAdmin]

		this.eliminarUsuariosArray = function()
		{
			var accion = 'eliminar_usuarios_array';
			var pag_actual_get = $('#campo_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();
			var administrador_get = $('#administrador_hidden').val();
			var filtro_priv_get = $('#filtro_priv_hidden').val();
			var nro_pag_get = $('#pag_num_hidden').val();
			var id_usuario_get = $('#id_usuario_hidden').val();

			if (checkboxes_seleccionados != '' || array_fixed != '')
			{
				$.ajax({
					cache: false,
					dataType: 'JSON',
					url: url_controladores,
					type: 'POST',
					data: {
						accion: accion,
						pag_actual_get: pag_actual_get,
						busqueda_get: busqueda_get,
						administrador_get: administrador_get,
						nro_pag_get: nro_pag_get,
						filtro_priv_get: filtro_priv_get,
						id_usuario_get: id_usuario_get,
						seleccion: checkboxes_seleccionados,
						seleccion2: checkboxes_seleccionados2
					},
					beforeSend: function(){
						bloquear();
					},
					success: function(data) {
						$('div.container-fluid #contenido').html(data.table);
						initElementos();
						$('#modal_confirmar').modal('hide');
						desbloquear();
						restablecerModalConfirmar();

						/**
						 * Ir cambiando prograsivamente.
						 */
						array_fixed.length = 0;
						checkboxes_seleccionados.length = 0;
						checkboxes_seleccionados2.length = 0;
					}
				});
			}
			else
				alert(error_general);
		} // [eliminarUsuariosArray::UsuarioAdmin]

		this.suspenderUsuariosArray = function()
		{
			var accion = 'suspender_usuarios_array';
			var pag_actual_get = $('#campo_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();
			var administrador_get = $('#administrador_hidden').val();
			var filtro_priv_get = $('#filtro_priv_hidden').val();
			var nro_pag_get = $('#pag_num_hidden').val();
			var id_usuario_get = $('#id_usuario_hidden').val();

			if (checkboxes_seleccionados != '' || array_fixed != '')
			{
				$.ajax({
					cache: false,
					dataType: 'JSON',
					url: url_controladores,
					type: 'POST',
					data: {
						accion: accion,
						pag_actual_get: pag_actual_get,
						busqueda_get: busqueda_get,
						administrador_get: administrador_get,
						nro_pag_get: nro_pag_get,
						filtro_priv_get: filtro_priv_get,
						id_usuario_get: id_usuario_get,
						seleccion: checkboxes_seleccionados,
						seleccion2: checkboxes_seleccionados2
					},
					beforeSend: function(){
						bloquear();
					},
					success: function(data) {
						$('div.container-fluid #contenido').html(data.table);
						initElementos();
						$('#modal_confirmar').modal('hide');
						desbloquear();
						restablecerModalConfirmar();

						/**
						 * Ir cambiando prograsivamente.
						 */
						array_fixed.length = 0;
						checkboxes_seleccionados.length = 0;
						checkboxes_seleccionados2.length = 0;
					}
				});
			}
			else
				alert(error_general);
		} // [suspenderUsuariosArray::UsuarioAdmin]

		this.activarUsuariosArray = function()
		{
			var accion = 'activar_usuarios_array';
			var pag_actual_get = $('#campo_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();
			var administrador_get = $('#administrador_hidden').val();
			var filtro_priv_get = $('#filtro_priv_hidden').val();
			var nro_pag_get = $('#pag_num_hidden').val();
			var id_usuario_get = $('#id_usuario_hidden').val();

			if (checkboxes_seleccionados != '' || array_fixed != '')
			{
				$.ajax({
					cache: false,
					dataType: 'JSON',
					url: url_controladores,
					type: 'POST',
					data: {
						accion: accion,
						pag_actual_get: pag_actual_get,
						busqueda_get: busqueda_get,
						administrador_get: administrador_get,
						nro_pag_get: nro_pag_get,
						filtro_priv_get: filtro_priv_get,
						id_usuario_get: id_usuario_get,
						seleccion: checkboxes_seleccionados,
						seleccion2: checkboxes_seleccionados2
					},
					beforeSend: function(){
						bloquear();
					},
					success: function(data) {
						$('div.container-fluid #contenido').html(data.table);
						initElementos();
						$('#modal_confirmar').modal('hide');
						desbloquear();
						restablecerModalConfirmar();

						/**
						 * Ir cambiando prograsivamente.
						 */
						array_fixed.length = 0;
						checkboxes_seleccionados.length = 0;
						checkboxes_seleccionados2.length = 0;
					}
				});
			}
			else
				alert(error_general);
		} // [activarUsuariosArray::UsuarioAdmin]

		this.restablecerPreguntas = function(id_usuario)
		{
			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: 'restablecer_preguntas',
					id_usuario: id_usuario
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					$('#modal_confirmar').modal('hide');
					desbloquear();
					new Notificacion().mostrarCantidadPendientes(data.notificaciones);
					restablecerModalConfirmar();
				}
			});
		} // [restablecerPreguntas::UsuarioAdmin]

		this.restablecerPreguntasArray = function()
		{
			if (checkboxes_seleccionados != '' || array_fixed != '')
			{
				$.ajax({
					cache: false,
					dataType: 'JSON',
					url: url_controladores,
					type: 'POST',
					data: {
						accion: 'restablecer_preguntas_array',
						seleccion: checkboxes_seleccionados,
						seleccion2: checkboxes_seleccionados2
					},
					beforeSend: function(){
						bloquear();
					},
					success: function(data) {
						$('#modal_confirmar').modal('hide');
						desbloquear();
						new Notificacion().mostrarCantidadPendientes(data.notificaciones);
						restablecerModalConfirmar();
						$('input[name="my-checkbox"], input[name="my-checkbox2"], input[name="my-checkbox-todos1"], ' +
							'input[name="my-checkbox-todos2"]').bootstrapSwitch('state', true);
						$('.marcar-todos').attr('data-accion', 'unchecked');
						$('.marcar-todos').children('i').attr('class', 'glyphicon glyphicon-unchecked');

						/**
						 * Ir cambiando prograsivamente.
						 */
						array_fixed.length = 0;
						checkboxes_seleccionados.length = 0;
						checkboxes_seleccionados2.length = 0;
					}
				});
			}
			else
				alert(error_general);
		} // [restablecerPreguntasArray::UsuarioAdmin]

		this.actualizarHtml = function(accion)
		{
			var pag_actual_get = $('#campo_hidden').val();
			var filtro_priv_get = $('#filtro_priv_hidden').val();
			var nro_pag_get = $('#pag_num_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();
			var administrador_get = $('#administrador_hidden').val();
			var id_usuario_get = $('#id_usuario_hidden').val();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				url: url_controladores,
				type: 'POST',
				data: {
					accion: accion,
					pag_actual_get: pag_actual_get,
					busqueda_get: busqueda_get,
					filtro_priv_get: filtro_priv_get,
					nro_pag_get: nro_pag_get,
					administrador_get: administrador_get,
					id_usuario_get: id_usuario_get
				},
				beforeSend: function() {
					$('.barra-botones [data-toggle="actualizar_html"]').attr('disabled','disabled');
				},
				success: function(data) {
					$('#contenido').html('').append(data.datos);
					initElementos();
					new Notificacion().mostrarCantidadPendientes(data.notificaciones);
					$('.barra-botones [data-toggle="actualizar_html"]').removeAttr('disabled');
				}
			});
		} // [actualizarHtml::UsuarioAdmin]

		this.validarUsuario = function(accion)
		{
			var aux = true;

			$("[data-toggle='requerido']").each(function() {
				if ( $("#nombre").val() == null || $("#nombre").val().length == 0 || /^\s+$/.test($("#nombre").val()) )
				{
					aux = false;
					$("#nombre").addClass("requerido");
					$("#nombre").next(".error").html("Debe ingresar un nombre de usuario");
				}
				else
				{
					if (!(/^[\s\S]{3,15}$/.test($("#nombre").val()))) {
						aux = false;
						$("#nombre").addClass("requerido");
						$("#nombre").next(".error").html("El nombre de usuario debe tener 3 y 15 caracteres");
					}
					else if (!(/(^(?=.*[a-z]).+$)/.test($("#nombre").val()))) {
						aux = false;
						$("#nombre").addClass("requerido");
						$("#nombre").next(".error").html("Debe ingresar al menos una letra");
					}
				}
				if (accion == 'crear_usuario')
				{
					if ( $("#clave").val() == null || $("#clave").val().length == 0 || /^\s+$/.test($("#clave").val()) )
					{
						aux = false;
						$("#clave").addClass("requerido");
						$("#clave").next(".error").html("Debe ingresar una contraseña");
					}
					else
					{
						if (!(/^[\s\S]{3,20}$/.test($("#clave").val()))) {
							aux = false;
							$("#clave").addClass("requerido");
							$("#clave").next(".error").html("La contraseña debe tener entre 3 y 20 caracteres");
						}
					}
				}
				if ((!($("#clave_nueva").val() == null || $("#clave_nueva").val().length == 0 ||
						/^\s+$/.test($("#clave_nueva").val()))) || (!($("#clave_confirmar").val() == null ||
						$("#clave_confirmar").val().length == 0 || /^\s+$/.test($("#clave_confirmar").val()))))
				{
					if (!(/^[\s\S]{3,20}$/.test($("#clave_nueva").val()))) {
						aux = false;
						$("#clave_nueva").addClass("requerido");
						$("#clave_nueva").next(".error").html("La contraseña debe tener entre 3 y 20 caracteres");
					}
					else if ($("#clave_nueva").val() != $("#clave_confirmar").val()) {
						aux = false;
						$("#clave_confirmar").addClass("requerido");
						$("#clave_confirmar").next(".error").html("¡Las contraseñas no coinciden!");
					}
				}
				if ($("#tipo_usuario").val() == "") {
					aux = false;
					$("#tipo_usuario").addClass("requerido");
					$("#tipo_usuario").next(".error").html("Asigne un privilegio a este usuario");
				}
				if ($("#tipo_usuario").val() == "2" && parseInt($("#sesion_hidden").val()) == 1)
				{
					if (seleccionUsuariosPermitidos()[0] == null)
					{
						aux = false;
						$("#modal_usuario .permitidos").addClass("requerido");
						$("#modal_usuario .permitidos").next(".error").html("Seleccione al menos un tipo de usuario");
					}
					else
					{
						$('.permitidos input[name="check_permitidos"]').each(function () {
				         if ($(this).prop('checked') == true)
				         {
				            cantidad = $(this).parent().next();
				            if ($(cantidad).val() == 0)
				            {
				            	aux = false;
									$(cantidad).addClass('requerido');
									$(cantidad).next('.error').html('La cantidad debe ser mayor que 0');
				            }
				         }
				      });
					}
				}
				if ($('#tipo_usuario').val() >= 2) {
					if ($("#modal_usuario #suscripcion").val() == "") {
						aux = false;
						$("#modal_usuario #suscripcion").addClass("requerido");
						$("#modal_usuario #suscripcion").next(".error").html("Asigne un tipo de suscripción");
					}
					if ($("#modal_usuario #suscripcion").val() == "1" || $("#modal_usuario #suscripcion").val() == "3") {
						if (!(/^(?:\+|-)?\d+$/.test($("#modal_usuario #tiempo_suscripcion").val()))) {
							aux = false;
							$("#modal_usuario #tiempo_suscripcion").addClass("requerido");
							$("#modal_usuario #tiempo_suscripcion").next(".error").html("Ingrese el tiempo de suscripción");
						}
					}
					if ($("#modal_usuario #suscripcion").val() == "2") {
						if (!seleccionDiasSuscripcion().length) {
							aux = false;
							$("#modal_usuario .dias").addClass("requerido");
							$("#modal_usuario .dias").next(".error").html("Seleccione al menos un día de la semana");
						}
					}
					if ($('#tipo_usuario').val() > 2 && !$('#id_responsable').val()
						&& parseInt($("#sesion_hidden").val()) == 1)
					{
						aux = false;
						$('[data-toggle="expandir_responsable"] .responsable').addClass('requerido');
						$('[data-toggle="expandir_responsable"] .responsable').next('.error').html('Asigne un responsable');
					}
				}
			});

			return aux;
		} // [validarUsuario::UsuarioAdmin]

		this.cambiarElementosSelectHtml = function(valor)
		{
			switch(valor)
			{
				case (1):
					$('#tipo_usuario').empty().append(
						'<option value="">Seleccionar</option>',
						'<option value="1">Super administrador</option>',
						'<option value="2">Administrador</option>',
						'<option value="3">Nacionales</option>',
						'<option value="4">Americanas</option>',
						'<option value="5">Americanas-Nacionales</option>');
					break;
				case (2):
					$('#tipo_usuario').empty().append(
						'<option value="">Seleccionar</option>',
						'<option value="3">Nacionales</option>',
						'<option value="4">Americanas</option>',
						'<option value="5">Americanas-Nacionales</option>');
					break;
				case (3):
					$('#tipo_usuario').empty().append(
						'<option value="">Seleccionar</option>',
						'<option value="2">Administrador</option>');
					break;
			}
		} // [cambiarElementosSelectHtml::UsuarioAdmin]

		this.expandirResponsableModificarUsuario = function(privilegios, id_responsable, accion)
		{
			if (privilegios > 2 && parseInt($("#sesion_hidden").val()) == 1)
			{
				$('[data-toggle="expandir_responsable"]').removeClass();
				consultaNombreResponsable(id_responsable);
			}
		}

		this.cargarUsuariosPermitidos = function(modal, array_usuarios_permitidos, max_nacionales,
			max_americanas, max_an)
		{
			array_usuarios_permitidos = array_usuarios_permitidos.split(',');

			for(var i=0; i<array_usuarios_permitidos.length; i++)
			{
				check = modal.find('#check_permitidos[value="'+array_usuarios_permitidos[i]+'"]');
				$(check).prop('checked', true);
				$(check).parent().next().removeAttr('disabled');
			}

			modal.find('#cantidad_nacionales').val(max_nacionales);
			modal.find('#cantidad_americanas').val(max_americanas);
			modal.find('#cantidad_an').val(max_an);
		}

	} /* [fin clase UsuarioAdmin] */

	/**
	 * [Estructura de la clase UsuarioAdministrador]
	 */
	var UsuarioAdministrador = function()
	{
		var _this = this;
		var array_seleccion_modal = [];
		var array_usuarios_permitidos = []; // almacena los usuarios que podrá crear
		var cantidad_usuarios_administrados = 0;

		$('#modal_usuario').on('change', '#check_permitidos', function() {
			array_permitidos_temp = [];
			$('#modal_usuario #check_permitidos').each(function() {
				if ($(this).is(':checked'))
					array_permitidos_temp.push($(this).val());
			});
			array_usuarios_permitidos = array_permitidos_temp;
		});

		this.getCantidadUsuariosAdministrados = function()
		{
			return cantidad_usuarios_administrados;
		}

		this.getArraySeleccionModal = function()
		{
			return array_seleccion_modal;
		}

		this.activarAccionesEnModal = function(id_administrador, modal,
			nombre_usuario_administrador)
		{
			cargarMisUsuariosModal(id_administrador);
			seleccionMisUsuariosModal();
			activarEliminarDesvincular(modal, nombre_usuario_administrador, id_administrador);
		}

		this.getArrayUsuariosPermitidos = function()
		{
			return array_usuarios_permitidos;
		}

		this.setArrayUsuariosPermitidos = function(array)
		{
			array_usuarios_permitidos = array;
		}

		this.validarEliminarDesvincularUsuariosEnModal = function()
		{
			var aux = true;
			var control_cantidad = parseInt($('#control_cantidad').val());
			var privilegios = parseInt($("#tipo_usuario").val());
			var resto = cantidad_usuarios_administrados - control_cantidad;

			if (cantidad_usuarios_administrados > control_cantidad)
			{
				aux = false;
				$('#administrados .page-header').next('.error').html(
					'Elimine o desvincule al menos ' + ((resto > 1) ? resto + ' cuentas'
						: resto + ' cuenta'));
			}
			else if (cantidad_usuarios_administrados > 0 && (privilegios > 0 && privilegios != 2))
			{
				aux = false;
				$('#administrados .page-header').next('.error').html(
					'Elimine o desvincule al menos ' + ((cantidad_usuarios_administrados > 1)
						? cantidad_usuarios_administrados + ' cuentas'
						: cantidad_usuarios_administrados + ' cuenta'));
			}

			return aux;
		} // [validarEliminarDesvincularUsuariosEnModal::UsuarioAdministrador]

		this.cargarSelectUsuariosPermitidos = function(seleccion)
		{
			var array_tipos_usuarios = ['', '', '', 'Nacionales', 'Americanas', 'Americanas-Nacionales'];

			if ($('#sesion_hidden').val() == 2)
			{
				var option = '<option value="">Seleccionar</option>';
				$.post(url_controladores, { accion: 'consultar_usuarios_permitidos' }, function(data) {
					for (var i=0; i<data.datos.length; i++)
					{
						selected = (seleccion != null && seleccion == data.datos[i]) ? 'selected' : '';
						option += '<option '+selected+' value="'+data.datos[i]+'">'+
							array_tipos_usuarios[data.datos[i]]+'</option>';
					}
					$('#tipo_usuario').empty().append(option);
				}, 'json');
			}
		} // [cargarSelectUsuariosPermitidos::UsuarioAdministrador]

		function eliminarMisUsuariosModal(id_administrador)
		{
			$.ajax({
				cache: false,
				dataType: 'JSON',
				url: url_controladores,
				type: 'POST',
				data: {
					accion: 'eliminar_usuario_desde_modal',
					array_seleccion_modal: array_seleccion_modal,
					id_administrador: id_administrador
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					$('#modal_confirmar').modal('hide');
					desbloquear();
					$('#administrados .btn-group').css('display', 'none');
					$('#administrados div.contenido-administrados').html(data.table);
					$('.page-header small').html(data.datos.conteo + ' de ' + data.datos.max);
					cantidad_usuarios_administrados.length = 0;
					cantidad_usuarios_administrados = data.datos.conteo;
				}
			});
		} // [eliminarMisUsuariosModal::UsuarioAdministrador]

		function desvincularMisUsuariosModal(id_administrador)
		{
			$.ajax({
				cache: false,
				dataType: 'JSON',
				url: url_controladores,
				type: 'POST',
				data: {
					accion: 'desvincular_usuario_desde_modal',
					array_seleccion_modal: array_seleccion_modal,
					id_administrador: id_administrador
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					$('#modal_confirmar').modal('hide');
					desbloquear();
					$('#administrados .btn-group').css('display', 'none');
					$('#administrados div.contenido-administrados').html(data.table);
					$('.page-header small').html(data.datos.conteo + ' de ' + data.datos.max);
					cantidad_usuarios_administrados.length = 0;
					cantidad_usuarios_administrados = data.datos.conteo;
				}
			});
		} // [desvincularMisUsuariosModal::UsuarioAdministrador]

		function cargarMisUsuariosModal(id_administrador)
		{
			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: 'cargar_mis_usuarios_en_modal',
					id_administrador: id_administrador
				},
				beforeSend: function() {
					$('#administrados').attr('class', 'show');
					$('#administrados div.contenido-administrados').html('Cargando registros...');
				},
				success: function(data) {
					$('#administrados div.contenido-administrados').html(data.table);
					$('.page-header small').html(data.datos.conteo + ' de ' + data.datos.max);
					cantidad_usuarios_administrados = data.datos.conteo;
				}
			});
		} // [cargarMisUsuariosModal::UsuarioAdministrador]

		function seleccionMisUsuariosModal()
		{
			$('#modal_usuario').on('change', 'input[name="check_administrados"]', function(){
				var array_temp_1 = [];
				$("#modal_usuario input[name='check_administrados']").each(function() {
					if ($(this).is(':checked') == true)
					{
						array_temp_1.push($(this).val());
						$(this).parent().parent().attr('class', 'list-group-item list-group-item-warning');
					}
					else
						$(this).parent().parent().attr('class', 'list-group-item');
				});
				(array_temp_1 == '') ? $('#administrados .btn-group').css('display', 'none')
					: $('#administrados .btn-group').css('display', 'inline');
				array_seleccion_modal = array_temp_1;
			});

			$(document).on('change', '#administrados .marcar-admin', function(event) {
				var array_temp = [];
				if ($(this).is(":checked") == true)
				{
					$("#administrados input[name='check_administrados']").prop("checked",true);
					$("#administrados input[name='check_administrados']").each(function() {
						if ($(this).is(':checked') == true)
						{
							array_temp.push($(this).val());
							$(this).parent().parent().attr("class", "list-group-item list-group-item-warning");
						}
						else
							$(this).parent().parent().attr("class", "list-group-item");
					});
					array_seleccion_modal = array_temp;
				}
				else
				{
					$("#administrados input[name='check_administrados']").each(function() {
						$(this).parent().parent().attr("class","list-group-item");
					});
					array_seleccion_modal.length = 0;
					$("#administrados input[name='check_administrados']").prop("checked", false);
				}
				(array_temp == '') ? $('#administrados .btn-group').css('display', 'none')
					: $('#administrados .btn-group').css('display', 'inline');
			});
		} // [seleccionMisUsuariosModal::UsuarioAdministrador]

		function activarEliminarDesvincular(modal, nombre_usuario_administrador, id_administrador)
		{
			$('[data-toggle="confirmar_en_modal"]').click(function(event) {
				event.preventDefault();
				var accion = $(this).attr('data-accion');
				switch(accion)
				{
					case 'eliminar':
						eliminarMisUsuariosModal(id_administrador);
						break;
					case 'desvincular':
						desvincularMisUsuariosModal(id_administrador);
						break;
				}
			});
		} // [activarEliminarDesvincular::UsuarioAdministrador]

	} /* [fin clase UsuarioAdministrador] */

	/**
	 * [Estructura de la clase Suscripcion]
	 */
	var Suscripcion = function()
	{
		var _this = this;
		var array_dias = [];

		$('#modal_usuario').on('change', '#checkdias', function() {
			array_dias_temp = [];
			$('#modal_usuario #checkdias').each(function() {
				if ($(this).is(':checked'))
					array_dias_temp.push($(this).val());
			});
			array_dias = array_dias_temp;
		});

		this.setArrayDias = function(nuevo_array_dias)
		{
			array_dias = nuevo_array_dias;
		}

		this.getArrayDias = function()
		{
			return array_dias;
		}

		this.cargarDiasSuscripcion = function(modal, array_dias)
		{
			array_dias = array_dias.split(',');

			for(var i=0; i<array_dias.length; i++)
				modal.find('#checkdias[value="'+array_dias[i]+'"]').prop('checked', true);
		}

		this.cambiarSuscripcionSinEventoHtml = function(tipo_suscripcion)
		{
			if (tipo_suscripcion == 1 || tipo_suscripcion == 3)
			{
				$('#modal_usuario #suscripcion').parent().attr('class', 'form-group col-xs-12 col-sm-7 col-md-7 col-lg-7');
				$('#modal_usuario #form_suscripcion').show();
				$('#modal_usuario .dias').hide();
				if (tipo_suscripcion == 1)
					$('#form_suscripcion > p').html('N° minutos');
				else
					$('#form_suscripcion > p').html('N° meses');
				$('#modal_usuario .dias').removeAttr('data-toggle');
				$('#modal_usuario .dias').next('.error').html('');
			}
			if (tipo_suscripcion == 2)
			{
				$('#modal_usuario #suscripcion').parent().attr('class', 'form-group col-xs-12 col-sm-12 col-md-12 col-lg-12');
				$('#modal_usuario #form_suscripcion').hide();
				$('#modal_usuario .dias').show();
			}
		} // [cambiarSuscripcionSinEventoHtml::Suscripcion]

	} /* fin clase Suscripcion */

	/**
	 * [Estructura de la clase Notificacion]
	 */
	var Notificacion = function()
	{
		var _this = this;

		function nombreActividad(numero_actividad)
		{
			var nombre_actividad = [
				'',
				'Inició sesión por primera vez con el número de IP: ', // 1
				'Inició sesión con nuevo número de IP: ', // 2
				'Inició sesión', // 3
				'Intentó iniciar sesión con un número de IP diferente: ', // 4
				'Intentó iniciar sesión con la cuenta suspendida', // 5
				'',
				'Pregunta de seguridad restablecida', // 7
				'Intento fallido de conexión simultánea', // 8
				'La suscripción ha caducado', // 9
				'Intentó iniciar sesión con la suscripción caducada', // 10
				'Suscripción renovada', // 11
				'Intentó iniciar sesión con suscripción semanal inválida', // 12
				'Intentó iniciar sesión con suscripción de administrador caducada', // 13
				'Intentó iniciar sesión con la cuenta de administrador suspendida' ]; // 14

			return nombre_actividad[numero_actividad];
		}

		function listItemActividad(numero_actividad)
		{
			var list_item = [
				'',
				'list-group-item',
				'list-group-item',
				'list-group-item',
				'list-group-item list-group-item-warning',
				'list-group-item list-group-item-warning',
				'list-group-item',
				'list-group-item',
				'list-group-item list-group-item-warning',
				'list-group-item list-group-item-success',
				'list-group-item list-group-item-warning',
				'list-group-item',
				'list-group-item list-group-item-warning',
				'list-group-item list-group-item-warning',
				'list-group-item list-group-item-warning' ];

			return list_item[numero_actividad];
		}

		this.cargarVerDetalles = function()
		{
			var accion = 'cargar_notificaciones_scroll_ver_detalles';
			var id_usuario_get = $('#id_usuario_hidden').val();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: accion,
					id_usuario_get: id_usuario_get
				},
				beforeSend: function() {
					$('#cargar_entradas_footer span').html('Cargando datos...');
				},
				success: function(data) {
					if (data.datos)
					{
						for (var i=0; i<data.datos.length; i++)
						{
							direccion_ip = (data.datos[i]['direccion_ip']) ? data.datos[i]['direccion_ip'] : '';

							fila = '<li class="'+listItemActividad(data.datos[i]['actividad'])+'">'+
								'<span style="font-weight: bold">'+data.datos[i]['fecha']+'</span>'+
								'<span class="badge">'+data.datos[i]['fecha_formato_hora']+'</span>'+
								'<p class="list-group-item-text">'+
								nombreActividad(data.datos[i]['actividad'])+direccion_ip+'</p></li>';

							$('.list-group li:last').after(fila);
						}
					}
					$('#cargar_entradas_footer span').html('...');
				}
			});
		} // [cargarVerDetalles::Notificacion]

		this.mostrarCantidadPendientes = function(cantidad_notificaciones)
		{
			if (cantidad_notificaciones > 0)
			{
				$('li.notificaciones a').empty().append(
					'Notificaciones <span class="badge">'+cantidad_notificaciones+'</span>');
			}
		} // [mostrarCantidadPendientes::Notificacion]

	} /* [fin clase Notificación] */

	/**
	 * [Acción que se genera al presionar el botón para crear nuevos usuarios.]
	 */
	$(document).on('click', '.barra-botones [data-toggle="modal"]', function() {
		var modal = $('#modal_usuario');
		var accion = $(this).attr('data-accion');
		var obj_usuario = new UsuarioAdmin();
		var obj_usuario_administrador = new UsuarioAdministrador();
		var form_load = ($('#sesion_hidden').val() == 1) ? '../cl/formularios/form_usuario_super_administrador.html'
			: '../cl/formularios/form_usuario_administrador.html';
		switch(accion)
		{
			case 'crear_usuario':
				modal.find('.modal-content').load(form_load, function() {
					modal.attr('class', 'modal');
					modal.find('.modal-dialog').attr('class', 'modal-dialog');
					modal.find('.modal-title').text('Nuevo usuario');
					modal.find('#enviar_datos_btn').text('Guardar');
					obj_usuario_administrador.cargarSelectUsuariosPermitidos(null);
					$('#datos_clave').attr('class', 'hide');
					$('#form-usuario').submit(function (event) {
						event.preventDefault();
						if (obj_usuario.validarUsuario(accion))
							obj_usuario.nuevoUsuario();
					});
				});
				break;
		}
		modal.modal('show');
	});

	/**
	 * [Accion que se genera al presionar el botón de actualizar cualquier usuario.]
	 */
	$(document).on('click', '#contenido [data-toggle="actualizar_usuario"]', function (event) {
		event.preventDefault();
		var accion = 'actualizar_usuario';
		var modal = $('#modal_usuario');
		var id_usuario = $(this).attr('href');
		var nombre = $(this).attr('dbd_nombre');
		var clave = $(this).attr('dbd_clave');
		var privilegio = $(this).attr('dbd_priv');
		var tipo_suscripcion = $(this).attr('dbd_susc_tipo');
		var dias = $(this).attr('dbd_susc_dias');
		var suscripcion_tiempo2 = $(this).attr('dbd_susc_tiempo2');
		var max_nacionales = $(this).attr('dbd_max_nacionales');
		var max_americanas = $(this).attr('dbd_max_americanas');
		var max_an = $(this).attr('dbd_max_an');
		var usuarios_permitidos = $(this).attr('dbd_usuarios_permitidos');
		var id_administrador = $(this).attr('dbd_id_administrador');
		var obj_usuario = new UsuarioAdmin();
		var obj_usuario_administrador = new UsuarioAdministrador();
		var obj_suscripcion = new Suscripcion();
		var form_load = ($('#sesion_hidden').val() == 1) ? '/cl/formularios/form_usuario_super_administrador.html'
			: '/cl/formularios/form_usuario_administrador.html';
		modal.find('.modal-content').load(form_load, function() {
			modal.find('#clave').attr('type', 'password');
			modal.find('#limpiar_btn').hide();
			modal.find('.modal-title').text('Modificar usuario');
			modal.find('#enviar_datos_btn').html('Guardar cambios');
			modal.find('a.cl').css('display', 'inline');
			modal.find('#nombre').val(nombre);
			modal.find('#clave').val(clave);
			modal.find('#tipo_usuario').val(privilegio);
			modal.find('#suscripcion').val(tipo_suscripcion);
			modal.find('#tiempo_suscripcion').val(suscripcion_tiempo2);
			obj_usuario.expandirResponsableModificarUsuario(privilegio, id_administrador);
			if (tipo_suscripcion == 2)
				obj_suscripcion.cargarDiasSuscripcion(modal, dias);
			if (privilegio == 2)
			{
				if (parseInt($('#sesion_hidden').val()) != 2)
				{
					modal.attr('class', 'modal bs-example-modal-lg');
					modal.find('.modal-dialog').attr('class', 'modal-dialog modal-lg');
					modal.find('[data-toggle="expandir"]').attr('class', 'col-xs-12 col-sm-6 col-md-6 col-lg-6');
					modal.find('[data-toggle="row"]').attr('class', 'row');
					modal.find('[data-toggle="expandir_suscripcion"]').attr('class', 'show');
					modal.find('[data-toggle="expandir_usuarios_permitidos"]').attr('class', 'show');
					obj_suscripcion.cambiarSuscripcionSinEventoHtml(tipo_suscripcion);
					obj_usuario.cargarUsuariosPermitidos(modal, usuarios_permitidos, max_nacionales, max_americanas, max_an);
				}
				(parseInt($('#sesion_hidden').val()) == 2) ? obj_usuario.cambiarElementosSelectHtml(3)
					: obj_usuario_administrador.cargarSelectUsuariosPermitidos();
				modal.find('#tipo_usuario').val(privilegio);
				obj_usuario_administrador.activarAccionesEnModal(id_usuario, modal, nombre);
			}
			else
			{
				modal.attr('class', 'modal');
				modal.find('.modal-dialog').attr('class', 'modal-dialog');
				modal.find('#form_number').hide();
				modal.find('#administrados').attr('class', 'hide');
				(parseInt($('#sesion_hidden').val()) == 2 && privilegio > 2)
					? obj_usuario_administrador.cargarSelectUsuariosPermitidos(privilegio)
					: obj_usuario.cambiarElementosSelectHtml(1);
				modal.find('#tipo_usuario').val(privilegio);
				if (privilegio > 2)
				{
					$('[data-toggle="expandir_suscripcion"]').attr('class', 'show');
					obj_suscripcion.cambiarSuscripcionSinEventoHtml(tipo_suscripcion);
				}
			}
			$('#form-usuario').submit(function (event) {
				event.preventDefault();
				if (obj_usuario.validarUsuario(accion))
				{
					if (obj_usuario_administrador.getCantidadUsuariosAdministrados() > 0)
					{
						if (obj_usuario_administrador.validarEliminarDesvincularUsuariosEnModal())
							obj_usuario.modificarUsuario(id_usuario);
					}
					else
						obj_usuario.modificarUsuario(id_usuario);
				}
			});
		});
		modal.modal('show');
	});

	/**
	 * [Acciones a realizar al presionar cualquier botón de confirmar
	 *  en las ventanas principales. Excluidas las ventanas modal.]
	 */
	$(document).on('click', '[data-toggle="confirmar"]', function (event) {
		event.preventDefault();
		var modal = $('#modal_confirmar');
		var accion = $(this).attr('data-accion');
		var id_usuario = $(this).attr('href');
		switch (accion)
		{
			case 'eliminar_usuario':
				modal.find('.modal-title').html('Eliminar usuario');
				modal.find('.modal-body').empty().append(
					'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
					'Este usuario será eliminado permanentemente del sistema. ¿Desea continuar?</p>' );
				modal.find('#btn_confirmar').on('click', function (event) {
					event.preventDefault();
					var obj_usuario = new UsuarioAdmin().eliminarUsuario(id_usuario);
				});
				break;
			case 'restablecer_preguntas':
				modal.find('.modal-title').html('Restablecer pregunta de seguridad');
				modal.find('.modal-body').empty().append(
					'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
					'La pregunta de seguridad de este usuario será restablecida. ¿Desea continuar?</p>' );
				modal.find('#btn_confirmar').on('click', function () {
					var obj_usuario = new UsuarioAdmin().restablecerPreguntas(id_usuario);
				});
				break;
			case 'eliminar_usuarios_array':
				modal.find('.modal-title').html('Eliminar usuario');
				modal.find('.modal-body').empty().append(
					'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
					'Los usuarios que ha seleccionado serán eliminados permanentemente del sistema. ¿Desea continuar?</p>' );
				modal.find('#btn_confirmar').on('click', function (event) {
					event.preventDefault();
					var obj_usuario = new UsuarioAdmin().eliminarUsuariosArray();
				});
				break;
			case 'restablecer_preguntas_array':
				modal.find('.modal-title').html('Restablecer pregunta de seguridad');
				modal.find('.modal-body').empty().append(
					'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
					'La pregunta de seguridad del usuario seleccionado será restablecida. ¿Desea continuar?</p>' );
				modal.find('#btn_confirmar').on('click', function (event) {
					event.preventDefault();
					var obj_usuario = new UsuarioAdmin();
					obj_usuario.restablecerPreguntasArray();
				});
				break;
			case 'suspender_array':
				modal.find('.modal-title').html('Suspender usuario');
				modal.find('.modal-body').empty().append(
					'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
					'Los usuarios que ha seleccionado serán suspendidos del sistema. ¿Desea continuar?</p>' );
				modal.find('#btn_confirmar').on('click', function (event) {
					event.preventDefault();
					var obj_usuario = new UsuarioAdmin();
					obj_usuario.suspenderUsuariosArray();
				});
				break;
			case 'reanudar_array':
				modal.find('.modal-title').html('Activar usuario');
				modal.find('.modal-body').empty().append(
					'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
					'Los usuarios que ha seleccionado serán activados. ¿Desea continuar?</p>' );
				modal.find('#btn_confirmar').on('click', function (event) {
					event.preventDefault();
					var obj_usuario = new UsuarioAdmin();
					obj_usuario.activarUsuariosArray();
				});
				break;
		}
		modal.modal('show');
	});

	/**
	 * [Actualizar las pantallas]
	 */
	$('div.container-fluid #contenido').on('click', '.barra-botones [data-toggle="actualizar_html"]', function() {
		var accion = $(this).attr('data-accion');
		new UsuarioAdmin().actualizarHtml(accion);
	});

	/**
	 * [Enviar formulario de búsqueda]
	 */
	$(document).on('submit', '#form-buscar', function(event) {
		event.preventDefault();
		var valor_busqueda = $('#campo_busqueda').val();
		var administrador = $('#administrador_hidden').val();
		if ( !($('#campo_busqueda').val() == null || $('#campo_busqueda').val().length == 0 ||
			/^\s*$/.test($('#campo_busqueda').val())) )
		{
			if (administrador && administrador != 0) // Verifico si estoy en la página de usuarios administrados.
				location.assign('?administrador='+administrador+'&buscar='+valor_busqueda);
			else
				location.assign('?buscar='+valor_busqueda);
			$('#campo_busqueda').autocomplete('close');
		}
	});

	/**
	 * [Activar búsqueda en modo responsive]
	 */
	$('div.container-fluid #contenido').on('click', '.abrir-buscar', function (event) {
		event.preventDefault();
		$(this).hide();
		$('.barra-botones .contenedor-botones').hide(100);
		$('.buscar').animate({'width': '100%'}, 100);
		$('.buscar input[type=text]').show();
		$('.buscar input[type=text]').focus();
		$('.buscar input[type=text]').on('blur', function (event) {
			event.preventDefault();
			if ($(this).val() == '')
			{
				$('.abrir-buscar, .barra-botones .contenedor-botones').show();
				$('.buscar input[type=text]').hide();
				$('.barra-botones .buscar').css('width', '10%');
			}
		});
	});

	/**
	 * [Carga las notificaciones en la ventana ver_detalles al hacer scroll.]
	 */
	$(function () {
		if ($('#id_usuario_hidden').val() != 0)
		{
			$(window).scroll(function () {
				if ($(window).scrollTop() == $(document).height() - $(window).height())
					new Notificacion().cargarVerDetalles();
			});
		}
	});

	/**
	 * El código a partir de aquí se debe ir cambiando progresivamente a POO.
	 */
	$(function() {
		var loc_actual = location.search.substring(1,7);
		$('div.container-fluid #contenido').on('switchChange.bootstrapSwitch', 'input[name="my-checkbox"]', function(event, state) {
			var myCheckboxes = new Array();
			$("#contenido input[name='my-checkbox']").each(function() {
				if ($(this).is(':checked') == false) {
					myCheckboxes.push($(this).val());
					if (loc_actual != 'id_usu')
						$(this).parent().parent().parent().parent().addClass('check-sel');
					else
						$(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().attr("class","panel panel-warning")
				}
				else
				{
					if (loc_actual != 'id_usu')
						$(this).parent().parent().parent().parent().removeAttr('class');
					else
						$(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().attr("class","panel panel-info");
				}
			});
			(myCheckboxes == "") ? $(".barra-botones .btn-group2").css("display","none") : $(".barra-botones .btn-group2").css("display","block");
			checkboxes_seleccionados = myCheckboxes;
		});
		$('div.container-fluid #contenido').on('switchChange.bootstrapSwitch', 'input[name="my-checkbox2"]', function(event, state){
			var myCheckboxes = new Array();
			$("#contenido input[name='my-checkbox2']").each(function() {
				if ($(this).is(':checked') == false){
					myCheckboxes.push($(this).val());
					if (loc_actual != 'id_usu')
						$(this).parent().parent().parent().parent().addClass('check-sel');
					else
						$(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().attr("class","panel panel-warning");
				}
				else
				{
					if (loc_actual != 'id_usu')
						$(this).parent().parent().parent().parent().removeAttr('class');
					else
						$(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().attr("class","panel panel-info");
				}
			});
			(myCheckboxes == "") ? $(".barra-botones .btn-group2").css("display","none") : $(".barra-botones .btn-group2").css("display","block");
			checkboxes_seleccionados = myCheckboxes;
		});
		$('div.container-fluid #contenido').on('switchChange.bootstrapSwitch', 'input[name="my-checkbox-todos1"]', function(event, state){
			var myCheckboxes = new Array();
			$("#contenido input[name='my-checkbox-todos1']").each(function() {
				if ($(this).is(':checked') == false){
					myCheckboxes.push($(this).val());
					if (loc_actual != 'id_usu')
						$(this).parent().parent().parent().parent().addClass('check-sel');
					else
						$(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().attr("class","panel panel-warning");
				}
				else
				{
					if (loc_actual != 'id_usu')
						$(this).parent().parent().parent().parent().removeAttr('class');
					else
						$(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().attr("class","panel panel-info");
				}
			});
			checkboxes_seleccionados = myCheckboxes;
			array_fixed = checkboxes_seleccionados.concat(checkboxes_seleccionados2);
			(array_fixed == "") ? $(".barra-botones .btn-group2").css("display","none") : $(".barra-botones .btn-group2").css("display","block");
		});
		$('div.container-fluid #contenido').on('switchChange.bootstrapSwitch', 'input[name="my-checkbox-todos2"]', function(event, state){
			var myCheckboxes2 = new Array();
			$("#contenido input[name='my-checkbox-todos2']").each(function() {
				if ($(this).is(':checked') == false){
					myCheckboxes2.push($(this).val());
					if (loc_actual != 'id_usu')
						$(this).parent().parent().parent().parent().addClass('check-sel');
					else
						$(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().attr("class","panel panel-warning");
				}
				else
				{
					if (loc_actual != 'id_usu')
						$(this).parent().parent().parent().parent().removeAttr('class');
					else
						$(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().attr("class","panel panel-info");
				}
			});
			checkboxes_seleccionados2 = myCheckboxes2;
			array_fixed = checkboxes_seleccionados.concat(checkboxes_seleccionados2);
			(array_fixed == "") ? $(".barra-botones .btn-group2").css("display","none") : $(".barra-botones .btn-group2").css("display","block");
		});
	});

	/**
	 * [Manejo de las funciones para la asignación del responsable.]
	 */

	// [Restableciendo todo el formulario al cerrar modal responsable.]
	$(function () {
		var modal_responsable = $('#modal_responsable');
		$(modal_responsable).on('hidden.bs.modal', function () {
			modal_responsable.find('#list_responsables').empty()
			modal_responsable.find('#datos-usuaro-seleccionado').hide();
			modal_responsable.find('#collapse_nuevo_responsable').attr('class', 'collapse');
         modal_responsable.find('#collapse_nuevo_responsable').css('height', '0px');
		});
	});

	var Responsable = function()
	{
		var __this = this;

		this.aceptar = function(modal, id, nombre)
		{
			$('#id_responsable').val(id);
			$('#nombre_responsable').removeAttr('class');
			$('#nombre_responsable').html('Responsable seleccionado: ' + nombre);
			modal.modal('hide');
		}

		this.validar = function(id)
		{
			var aux = true;

			$("[data-toggle='requerido']").each(function () {
				if (!id)
				{
					aux = false;
					$('#list_responsables').addClass('requerido');
					$('#list_responsables').next('.error').html('Seleccione un responsable');
				}
			});

			return aux;
		}
	} /* [fin clase Responsable] */

	/**
	 * [Enviar form seleccion responsable.]
	 */
	$('#modal_responsable').on('show.bs.modal', function() {
		$('#modal_responsable').find('.modal-content').load(
			'/cl/formularios/form_asignar_responsable.html', function() {
			$('#form-responsable').submit(function (event) {
				event.preventDefault();
				var id = $('#list_responsables option:selected').val();
				var max = $('#list_responsables option:selected').data('max');
				var conteo = $('#list_responsables option:selected').data('conteo');
				var nombre = $('#list_responsables option:selected').data('nombre');
				var obj_responsable = new Responsable();
				if (obj_responsable.validar(id))
					obj_responsable.aceptar($('#modal_responsable'), id, nombre);
			});
		});
	});

});