var accion = '';

$(document).ready(function() {

	function actualizarPagina() {
		$.ajax({
			cache: false,
			dataType: 'JSON',
			type: 'POST',
			url: url_controladores,
			data: { accion: 'actualizar_pagina_set_interval' },
			success: function(data) {
				if (data.datos != 0) {
					window.location = url_controlador_logout;
				}
				if (data.notificaciones > 0) {
					$('li.notificaciones a').empty().append(
						'Notificaciones <span class="badge">'+data.notificaciones+'</span>');
				}
			}
		});
	} setInterval(actualizarPagina, 210000);

	function actualizarLeidas() {
		$.post(url_controladores, { accion: 'actualizar_notificaciones_leidas' } );
	} actualizarLeidas();

	function initElementos() {
		$('button').tooltip();
	} initElementos();

	function bloquear() {
		$('.modal input, .modal button, .modal a').attr('disabled', 'disabled');
	}

	function desbloquear() {
		$('.modal input, .modal button, .modal a').removeAttr('disabled');
	}

	function controlValidacionCampos() {
		$('[data-toggle="requerido"]').click(function() {
			$(this).removeClass('requerido');
			$(this).next(".error").html('');
		});
	}

	function cerrarModal() {
		$('.modal').modal('hide');
	}

	/**
	 * [Estructura de la clase Notificacion]
	 */
	var Notificacion = function()
	{
		var _this = this;

		function nombreActividad(numero_actividad)
		{
			var nombre_actividad = [
				'',
				'Inició sesión por primera vez con el número de IP: ', // 1
				'Inició sesión con nuevo número de IP: ', // 2
				'Inició sesión', // 3
				'Intentó iniciar sesión con un número de IP diferente: ', // 4
				'Intentó iniciar sesión con la cuenta suspendida', // 5
				'',
				'Pregunta de seguridad restablecida', // 7
				'Intento fallido de conexión simultánea', // 8
				'La suscripción ha caducado', // 9
				'Intentó iniciar sesión con la suscripción caducada', // 10
				'Suscripción renovada', // 11
				'Intentó iniciar sesión con suscripción semanal inválida', // 12
				'Intentó iniciar sesión con suscripción de administrador caducada', // 13
				'Intentó iniciar sesión con la cuenta de administrador suspendida' ]; // 14

			return nombre_actividad[numero_actividad];
		}

		function listItemActividad(numero_actividad)
		{
			var list_item = [
				'',
				'list-group-item',
				'list-group-item',
				'list-group-item',
				'list-group-item list-group-item-warning',
				'list-group-item list-group-item-warning',
				'list-group-item',
				'list-group-item',
				'list-group-item list-group-item-warning',
				'list-group-item list-group-item-success',
				'list-group-item list-group-item-warning',
				'list-group-item',
				'list-group-item list-group-item-warning',
				'list-group-item list-group-item-warning',
				'list-group-item list-group-item-warning' ];

			return list_item[numero_actividad];
		}

		function mostrarCantidadPendientes(cantidad_notificaciones)
		{
			if (cantidad_notificaciones > 0)
			{
				$('li.notificaciones a').empty().append(
					'Notificaciones <span class="badge">'+cantidad_notificaciones+'</span>');
			}
		} // [mostrarCantidadPendientes::Notificacion]

		this.cargarScroll = function()
		{
			var accion = 'cargar_notificaciones_scroll_vista_principal';

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: { accion: accion },
				beforeSend: function() {
					$('#cargar_entradas_footer span').html('Cargando datos...');
				},
				success: function(data) {
					if (data.datos)
					{
						for (var i=0; i<data.datos.length; i++)
						{
							direccion_ip = (data.datos[i]['direccion_ip']) ? data.datos[i]['direccion_ip'] : '';

							fila = '<li class="'+listItemActividad(data.datos[i]['actividad'])+'">'+
								'<a href="todos.php?id_usuario='+data.datos[i]['usuario_id']+'">'+
									'<i class="glyphicon glyphicon-user"></i> '+data.datos[i]['nombre']+
								'</a>'+
								'<span style="font-weight:bold; float:right">'+data.datos[i]['fecha']+'</span>'+
								'<p class="list-group-item-text">'+
									'<span style="float:right; color:#8899A6; font-size:12px; font-weight:bold">'+
									data.datos[i]['fecha_formato_hora']+'</span>'+
									nombreActividad(data.datos[i]['actividad'])+direccion_ip+
								'</p>'+
							'</li>';

							$('.list-group li:last').after(fila);
						}
					}
					$('#cargar_entradas_footer span').html('...');
				}
			});
		} // [cargarScroll::Notificacion]

		this.eliminar = function(accion)
		{
			accion = 'eliminar_notificaciones_' + accion;

			$.ajax({
				cache: false,
				dataType: 'JSON',
				url: url_controladores,
				type: 'POST',
				data: { accion: accion },
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					if (data.datos)
						$('#contenido').html('').append(data.table);
					cerrarModal();
					desbloquear();
					initElementos();
					actualizarLeidas();
					mostrarCantidadPendientes(data.notificaciones);
				}
			});
		} // [eliminar::Notificacion]

		this.actualizarHtml = function()
		{
			var accion = 'actualizar_notificaciones';

			$.ajax({
				cache: false,
				dataType: 'JSON',
				url: url_controladores,
				type: 'POST',
				data: { accion: accion },
				beforeSend: function() {
					$('.barra-botones [data-toggle="actualizar_html"]').attr('disabled','disabled');
				},
				success: function(data) {
					$('#contenido').html('').append(data.datos);
					initElementos();
					actualizarLeidas();
					mostrarCantidadPendientes(data.notificaciones);
					$('.barra-botones [data-toggle="actualizar_html"]').removeAttr('disabled');
				}
			});
		} // [actualizarHtml::Notificacion]

	} /* [fin clase Notificación] */

	/**
	 * [Carga las notificaciones al hacer scroll.]
	 */
	$(function() {
		$(window).scroll(function () {
			if ($(window).scrollTop() == $(document).height() - $(window).height())
				new Notificacion().cargarScroll();
		});
	});

	/**
	 * [Actualizar la pantalla.]
	 */
	$('#contenido').on('click', '.barra-botones [data-toggle="actualizar_html"]', function() {
		new Notificacion().actualizarHtml();
	});

	/**
	 * [Abrir confirmar eliminar.]
	 */
	$('#contenido').on('click', '.barra-botones [data-toggle="eliminar"]', function(event) {
		event.preventDefault();
		accion = $(this).attr('data-accion');
		var modal = $('#modal_confirmar');
		var msj_confirmar = '';
		var msj_general = ' serán eliminadas permanentemente del sistema. ¿Desea continuar?';
		switch (accion)
		{
			case 'hoy':
				msj_confirmar = ' Las notificaciones de  hoy';
				break;
			case 'semana':
				msj_confirmar = ' Las notificaciones de la última semana';
				break;
			case 'mes':
				msj_confirmar = ' Las notificaciones del último mes';
				break;
			case 'anio':
				msj_confirmar = ' Las notificaciones del último año';
				break;
			case 'todo':
				msj_confirmar = ' Todas las notificaciones';
				break;
		}
		modal.modal('show');
		modal.find('.modal-body > p').empty().append(
			'<span class="glyphicon glyphicon-warning-sign"></span>' + msj_confirmar + msj_general );
	});

	/**
	 * [Eliminar notificaciones.]
	 */
	$('#modal_confirmar #continuar_btn').on('click', function(event) {
		event.preventDefault();
		new Notificacion().eliminar(accion);
	});

});