$(document).ready(function () {

	function actualizarPagina() {
		$.ajax({
			cache: false,
			dataType: 'JSON',
			type: 'POST',
			url: url_controladores,
			data: { accion: 'actualizar_pagina_set_interval' },
			success: function(data) {
				if (data.datos != 0) {
					window.location = url_controlador_logout;
				}
				if (data.notificaciones > 0) {
					$('li.notificaciones a').empty().append(
						'Notificaciones <span class="badge">'+data.notificaciones+'</span>');
				}
			}
		});
	} setInterval(actualizarPagina, 210000);

	function initElementos() {
		$("button, a, i, .estado").tooltip();
		$('.date').datepicker();
	} initElementos();

	function bloquear() {
		$('.modal input, .modal button, .modal textarea, .modal a, .modal select').attr('disabled', 'disabled');
	}

	function desbloquear() {
		$('.modal input, .modal button, .modal textarea, .modal a, .modal select').removeAttr('disabled');
	}

	function cerrarModal() {
		$('.modal').modal('hide');
	}

	$(function() {
		var modal_usuario = $('#modal_usuario');
		$(modal_usuario).on('hidden.bs.modal', function () {
			modal_usuario.find('.modal-content').html('');
		});
	});

	/**
	 * Reportes
	 */
	var Reporte = function()
	{
		var _this = this;

		this.consultarPorDia = function(hash, fecha)
		{
			location.assign('?f1=' + fecha + hash);
		}

		this.consultarPorSemana = function(hash, semana)
		{
			location.assign('?sem=' + semana + hash);
		}

		/* Este método sirve para verificar que el hash coincida con
			los tipos de reportes que manejo.
			El array 'tipos_reportes' guarda todos los tipos de reportes. */
		this.validaLocationHash = function(hash)
		{
			var tipos_reportes = ['#rep1', '#rep2'];
			
			// Retorna -1 si no encontró el hash, de lo contrario retorna la posición.
			return $.inArray(hash, tipos_reportes);
		}

		this.cargarFormularios = function(hash)
		{
			switch (hash)
			{
				case '#rep1':
					var fecha_get = $('#f1').val();
					$('.form-tipo-reporte').load('/cl/formularios/reportes/por_dia.html', function() {
						$('.container-form-reporte h5.title').html('Reporte por día');
						if (fecha_get != 0)
							$('.datepicker').val(fecha_get);
						$('#form-reporte').submit(function(event) {
							event.preventDefault();
							var fecha = $('.datepicker').val();
							if (fecha != null && fecha.length != 0)
								new Reporte().consultarPorDia(location.hash, fecha);
						});
					});
					break;
				case '#rep2':
					var semana_get = $('#sem').val();
					$('.form-tipo-reporte').load('/cl/formularios/reportes/por_semana.html', function() {
						$('.container-form-reporte h5.title').html('Reporte por semana');
						if (semana_get != 0)
							$('.datepicker').val(semana_get);
						$('#form-reporte').submit(function(event) {
							event.preventDefault();
							var semana = $('.datepicker').val();
							if (semana != null && semana.length != 0)
								new Reporte().consultarPorSemana(location.hash, semana);
						});
					});
					break;
			}
		}

		this.actualizarHtml = function(hash)
		{
			var f1_get = $('#f1').val();
			var sem_get = $('#sem').val();
			var pag_num_get = $('#pag_num').val();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				url: url_controladores,
				type: 'POST',
				data: {
					accion: 'actualizar_reportes',
					f1: f1_get,
					sem: sem_get,
					pag_num: pag_num_get
				},
				beforeSend: function() {
					$('.barra-botones [data-toggle="actualizar_html"]').attr('disabled','disabled');
				},
				success: function(data) {
					$('#contenido').html('').append(data.datos);
					initElementos();
					$('.barra-botones [data-toggle="actualizar_html"]').removeAttr('disabled');
					new Reporte().cargarFormularios(hash);
				}
			});
		} // [actualizarHtml::Reporte]

	} /* [fin clase Reporte] */

	$(function() {
		var obj_reporte = new Reporte();
		var location_hash = location.hash;
		if (obj_reporte.validaLocationHash(location_hash) >= 0)
			obj_reporte.cargarFormularios(location_hash);
		$('#contenido').on('click', '.reporte a', function(event) {
			var seleccion = $(this).attr('href');
			obj_reporte.cargarFormularios(seleccion);
		});
	});

	/**
	 * [Actualizar pantalla]
	 */
	$('div.container-fluid #contenido').on('click', '.barra-botones [data-toggle="actualizar_html"]', function() {
		var obj_reporte = new Reporte();
		obj_reporte.actualizarHtml(location.hash);
	});

});