<?php

require_once(dirname(__FILE__).'/'.'Admin.php');
include_once 'Conexion.php';
include_once 'Paginacion.php';

class Administrador extends Admin
{
   public function guardarUsuario($nombre, $clave, $privilegios, $suscripcion, $tiempo_suscripcion,
      $id_usuario_session)
   {
      $bd = new Conexion();
      $aux = 0;

      if ($nombre != '' && $clave != '' && $privilegios != '')
      {
         $query_buscar = 'SELECT id_usuario FROM registrados
            WHERE nombre = "'.$nombre.'"';

         $query_guardar = 'INSERT INTO registrados (ip, nombre, clave, privilegios, id_administrador)
            VALUES ("Usuario nuevo", trim("'.$nombre.'"), trim("'.$clave.'"), "'.$privilegios.'",
               "'.$id_usuario_session.'")';

         if ($estc = $bd->ejecutar($query_buscar))
         {
            if ($bd->obtenerCantidadFilas($estc) > 0)
               $aux = 2; # nombre de usuario repetido
            else if ($this->validarUsuariosPermitidosAdministrador($id_usuario_session, $privilegios) == false)
               $aux = 4; # intento de crear un usuario no permitido
            else if ($this->validarConteoAdministrador($id_usuario_session, $privilegios) == 0)
               $aux = 3; # ya no puede registrar más usuarios
            else if ($bd->ejecutar($query_guardar))
            {
               $aux = 1; # usuario registrado exitosamente

               $ultimo_id = $bd->ultimoId();
               $obj_suscripcion = new Suscripcion();
               $obj_suscripcion->guardar($ultimo_id, $suscripcion, $tiempo_suscripcion, $_POST['dias_suscripcion']);
               $this->incrementarConteoAdministrador($id_usuario_session, $privilegios);
            }
         }

         $bd->cerrar();
      }

      return $aux;
   }

   public function modificarUsuario($id_usuario_modificar, $nombre, $privilegios, $suscripcion,
      $tiempo_suscripcion, $clave_nueva, $clave_confirmar, $id_usuario_session)
   {
      $bd = new Conexion();
      $aux = 0;

      if ( $nombre != '' && $privilegios != '' )
      {
         $query_buscar = 'SELECT id_usuario FROM registrados
            WHERE nombre COLLATE utf8_bin = "'.$nombre.'" AND id_usuario <> "'.$id_usuario_modificar.'"';

         if ($estc = $bd->ejecutar($query_buscar))
         {
            if ($bd->obtenerCantidadFilas($estc) > 0)
               $aux = 2; # nombre de usuario repetido
            else
            {
               if (($clave_nueva != '') && ($clave_confirmar != ''))
               {
                  if ($clave_nueva == $clave_confirmar)
                  {
                     $query_actualizar = 'UPDATE registrados
                        SET nombre = "'.trim($nombre).'", clave = "'.trim($clave_nueva).'",
                        privilegios = "'.trim($privilegios).'"
                        WHERE id_usuario = "'.$id_usuario_modificar.'"';
                  }
               }
               else
               {
                  $query_actualizar = 'UPDATE registrados
                     SET nombre = "'.trim($nombre).'", privilegios = "'.trim($privilegios).'"
                     WHERE id_usuario = "'.$id_usuario_modificar.'"';
               }

               if ($privilegios == 2)
               {
                  $bd->ejecutar($query_actualizar);
                  $aux = 1;
               }
               else if ($privilegios > 2)
               {
                  if ($this->validarUsuariosPermitidosAdministrador($id_usuario_session, $privilegios) == false)
                     $aux = 4; # intento de crear un usuario no permitido
                  else
                  {
                     $privilegios_actual = $this->obtenerPrivilegiosUsuario($id_usuario_modificar);

                     if ($privilegios != $privilegios_actual)
                     {
                        if ($this->validarConteoAdministrador($id_usuario_session, $privilegios) == 0)
                           $aux = 3; # ya no puede registrar más usuarios
                        else
                        {
                           $this->decrementarConteoAdministrador($id_usuario_session, 1, $privilegios_actual);
                           $this->incrementarConteoAdministrador($id_usuario_session, $privilegios);
                           $bd->ejecutar($query_actualizar);
                           $obj_suscripcion = new Suscripcion();
                           $obj_suscripcion->actualizar($id_usuario_modificar, $suscripcion, $tiempo_suscripcion,
                              $_POST['dias_suscripcion']);
                           $aux = 1;
                        }
                     }
                     else
                     {
                        $bd->ejecutar($query_actualizar);
                        $obj_suscripcion = new Suscripcion();
                        $obj_suscripcion->actualizar($id_usuario_modificar, $suscripcion, $tiempo_suscripcion,
                           $_POST['dias_suscripcion']);
                        $aux = 1;
                     }
                  }
               }
            }
         }
      }

      return $aux;
   }

   public function eliminarUsuario($id_usuario_eliminar, $id_usuario_session)
   {
      $bd = new Conexion();
      $aux = 0;

      $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario_eliminar);

      if ($privilegios_usuario > 2)
      {
         if ($this->eliminarUsuarioEstandar($id_usuario_eliminar))
         {
            $this->decrementarConteoAdministrador($id_usuario_session, 1, $privilegios_usuario);
            $this->eliminarEnlaceUsuarioSuperadmin($id_usuario_eliminar);
            $aux = 1;
         }
      }

      $bd->cerrar();

      return $aux;
   }

   public function eliminarArrayUsuarios($id_usuario_session)
   {
      $bd = new Conexion();
      $aux = 0;

      if (!empty($_POST['seleccion']))
      {
         $aux = 1;

         foreach ($_POST['seleccion'] as $id_usuario_eliminar)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario_eliminar);

            if ($privilegios_usuario > 2)
            {
               if ($this->eliminarUsuarioEstandar($id_usuario_eliminar))
               {
                  $this->decrementarConteoAdministrador($id_usuario_session, 1, $privilegios_usuario);
                  $this->eliminarEnlaceUsuarioSuperadmin($id_usuario_eliminar);
               }
            }
         }
      }

      if (!empty($_POST['seleccion2']))
      {
         $aux = 1;

         foreach ($_POST['seleccion2'] as $id_usuario_eliminar)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario_eliminar);

            if ($privilegios_usuario > 2)
            {
               if ($this->eliminarUsuarioEstandar($id_usuario_eliminar))
               {
                  $this->decrementarConteoAdministrador($id_usuario_session, 1, $privilegios_usuario);
                  $this->eliminarEnlaceUsuarioSuperadmin($id_usuario_eliminar);
               }
            }
         }
      }

      $bd->cerrar();

      return $aux;
   }

   public function suspenderUsuariosArray()
   {
      $bd = new Conexion();
      $aux = 0;

      if (!empty($_POST['seleccion']))
      {
         foreach ($_POST['seleccion'] as $id_usuario)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario);
            $obj_suscripcion = new Suscripcion();

            if ($privilegios_usuario > 2)
               $this->suspenderUsuario($id_usuario);
            if ($obj_suscripcion->get_tipo($id_usuario) >= 2)
            {
               $obj_pago = new Pago();
               $obj_pago->guardar($id_usuario);
            }
         }

         $aux = 1;
      }

      if (!empty($_POST['seleccion2']))
      {
         foreach ($_POST['seleccion2'] as $id_usuario)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario);
            $obj_suscripcion = new Suscripcion();

            if ($privilegios_usuario > 2)
               $this->suspenderUsuario($id_usuario);
            if ($obj_suscripcion->get_tipo($id_usuario) >= 2)
            {
               $obj_pago = new Pago();
               $obj_pago->guardar($id_usuario);
            }
         }

         $aux = 1;
      }

      $bd->cerrar();

      return $aux;
   }

   /**
    * [Suma las columas max_ y conteo_ para mostrar el total de usuarios que
    *  puede administrar y el total de usuarios que ha registrado.]
    */
   public function obtenerMaxConteo($id_administrador)
   {
      $bd = new Conexion();
      $max = '';
      $conteo = '';

      $query = 'SELECT (max_nacionales + max_americanas + max_an) AS max,
         (conteo_nacionales + conteo_americanas + conteo_an) AS conteo
         FROM conteo_administradores
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $max = $fila['max'];
         $conteo = $fila['conteo'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      $salida_json = json_encode([
         'max' => $max,
         'conteo' => $conteo ]);

      return $salida_json;
   }

   private function consultaUsuariosOnline($paginacion, $id_administrador_session)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status = 0 AND registrados.online = 1) AND ('.$restriccion.')
         ORDER BY registrados.privilegios, registrados.nombre ASC
         LIMIT '.$paginacion->getOffset().', '.$paginacion->getFilasPagina().'';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasUsuariosOnline($id_administrador_session)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT id_usuario FROM registrados
         WHERE (registrados.status = 0 AND registrados.online = 1) AND ('.$restriccion.')';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   private function consultaVerDetallesUsuarioOnline($id_usuario_get, $id_administrador_session)
   {
      $bd = new Conexion();
      $fila = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2, suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status = 0 AND registrados.online = 1
            AND registrados.id_usuario = "'.$id_usuario_get.'") AND ('.$restriccion.')';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   private function consultaBusquedaUsuariosOnline($filtro_busqueda, $id_administrador_session)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2, suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status = 0 AND registrados.online = 1
            AND registrados.nombre LIKE "%'.$filtro_busqueda.'%") AND ('.$restriccion.')
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function consultaUsuariosOffline($paginacion, $id_administrador_session)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status != 1 AND registrados.online = 0) AND ('.$restriccion.')
         ORDER BY registrados.privilegios, registrados.nombre ASC
         LIMIT '.$paginacion->getOffset().', '.$paginacion->getFilasPagina().'';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasUsuariosOffline($id_administrador_session)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT id_usuario FROM registrados
         WHERE (registrados.status != 1 AND registrados.online = 0) AND ('.$restriccion.')';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   private function consultaVerDetallesUsuarioOffline($id_usuario_get, $id_administrador_session)
   {
      $bd = new Conexion();
      $fila = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2, suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status != 1 AND registrados.online = 0
            AND registrados.id_usuario = "'.$id_usuario_get.'") AND ('.$restriccion.')';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   private function consultaBusquedaUsuariosOffline($filtro_busqueda, $id_administrador_session)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2, suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status != 1 AND registrados.online = 0
            AND registrados.nombre LIKE "%'.$filtro_busqueda.'%") AND ('.$restriccion.')
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function consultaUsuariosSuspendidos($paginacion, $id_administrador_session)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE registrados.status = 1 AND ('.$restriccion.')
         ORDER BY registrados.privilegios, registrados.nombre ASC
         LIMIT '.$paginacion->getOffset().', '.$paginacion->getFilasPagina().'';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasUsuariosSuspendidos($id_administrador_session)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT id_usuario FROM registrados
         WHERE registrados.status = 1 AND ('.$restriccion.')';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   private function consultaVerDetallesUsuarioSuspendido($id_usuario_get, $id_administrador_session)
   {
      $bd = new Conexion();
      $fila = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2, suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status = 1 AND registrados.id_usuario = "'.$id_usuario_get.'")
            AND ('.$restriccion.')';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   private function consultaBusquedaUsuariosSuspendidos($filtro_busqueda, $id_administrador_session)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2, suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status = 1 AND registrados.nombre LIKE "%'.$filtro_busqueda.'%")
            AND ('.$restriccion.')
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function consultaUsuariosTodos($paginacion, $id_administrador_session)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE ('.$restriccion.')
         ORDER BY registrados.privilegios, registrados.nombre ASC
         LIMIT '.$paginacion->getOffset().', '.$paginacion->getFilasPagina().'';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasUsuariosTodos($id_administrador_session)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT id_usuario FROM registrados
         WHERE ('.$restriccion.')';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   private function consultaVerDetallesUsuarioTodos($id_usuario_get, $id_administrador_session)
   {
      $bd = new Conexion();
      $fila = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2, suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.id_usuario = "'.$id_usuario_get.'") AND ('.$restriccion.')';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   private function consultaBusquedaUsuariosTodos($filtro_busqueda, $id_administrador_session)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $restriccion = 'registrados.id_usuario = "'.$id_administrador_session.'"
         OR registrados.id_administrador = "'.$id_administrador_session.'"';

      $query = 'SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2, suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.nombre LIKE "%'.$filtro_busqueda.'%") AND ('.$restriccion.')
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   public function consultarMisUsuariosModal($id_administrador)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.*, suscripcion.status AS status_suscripcion,
         suscripcion.status2 AS status_suscripcion2
         FROM registrados
         LEFT JOIN suscripcion ON registrados.id_usuario = suscripcion.id_usuario
         WHERE id_administrador = "'.$id_administrador.'"
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   public function procesarFiltroPriv($privilegios)
   {
      if (!$privilegios)
         $privilegios = 0;
      else if ($privilegios < 3 || $privilegios > 5)
         $privilegios = 0;

      return $privilegios;
   }

   public function __cargarMisUsuariosModal($id_administrador)
   {
      $salida_html = '';

      if ($filas = $this->consultarMisUsuariosModal($id_administrador))
      {
         $salida_html .= '
            <label><input type="checkbox" class="marcar-admin" style="margin-left:8px"></input>
               Seleccionar todos</label>
            <div class="list-group">';

         foreach ($filas as $usuario)
         {
            $salida_html .= '
               <a class="list-group-item" style="padding:5px;cursor:default">';
               $salida_html .= '
                  <label class="checkbox-inline">
                     <input type="checkbox" name="check_administrados" value="'.$usuario["id_usuario"].'"></input> '.$usuario["nombre"].'
                        <span style="color:#8899a6;font-size:12px"> ('.$this->nombrePrivilegios($usuario["privilegios"]).')</span>
                  </label>
                  '.$this->statusUsuarioIcono($usuario['online'], $usuario['status'], $usuario['status2'],
                     $usuario['status_suscripcion'], $usuario['status_suscripcion2']).'
               </a>';
         }

         $salida_html .= '</div>';
      }
      else
         $salida_html .= '<span class="subtitulo2">No hay registros de usuarios administrados.</span>';

      return $salida_html;
   }

   public function __vistaUsuariosHtml($pagina, $id_usuario_get, $busqueda_get,
      $administrador_get, $pag_num_get, $filtro_privilegios_get)
   {
      if ($id_usuario_get)
         $salida_html = $this->__verDetallesUsuariosHtml($pagina, $id_usuario_get);
      else if ($busqueda_get)
         $salida_html = $this->__usuariosEncontradosHtml($pagina, $busqueda_get, $_SESSION['id_usuario']);
      else
      {
         switch ($pagina)
         {
            case 'act':
               $paginacion = new Paginacion($this->numFilasUsuariosOnline($_SESSION['id_usuario']),
                  $pag_num_get);
               $filas = $this->consultaUsuariosOnline($paginacion, $_SESSION['id_usuario']);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), 0);
               break;
            case 'desc':
               $paginacion = new Paginacion($this->numFilasUsuariosOffline($_SESSION['id_usuario']),
                  $pag_num_get);
               $filas = $this->consultaUsuariosOffline($paginacion, $_SESSION['id_usuario']);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), 0);
               break;
            case 'susp':
               $paginacion = new Paginacion($this->numFilasUsuariosSuspendidos($_SESSION['id_usuario']),
                  $pag_num_get);
               $filas = $this->consultaUsuariosSuspendidos($paginacion, $_SESSION['id_usuario']);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), 0);
               break;
            case 'todos':
               $paginacion = new Paginacion($this->numFilasUsuariosTodos($_SESSION['id_usuario']),
                  $pag_num_get);
               $filas = $this->consultaUsuariosTodos($paginacion, $_SESSION['id_usuario']);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), 0);
               break;
            default:
               $paginacion = new Paginacion($this->numFilasUsuariosTodos($_SESSION['id_usuario']),
                  $pag_num_get);
               $filas = $this->consultaUsuariosTodos($paginacion, $_SESSION['id_usuario']);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), 0);
               break;
         }

         $salida_html = $this->__barraBotonesHtml($pagina);

         $salida_html .= $subtitulo;

         $salida_html .= '
            <div class="table-responsive">
               <table class="table table-usuarios">
                  <thead>
                     <tr>
                        <th>Usuario</th>
                        <th>Dirección IP</th>
                        <th>Privilegios</th>
                        <th>Status</th>
                        <th>Acciones</th>
                     </tr>
                  </thead>
                  <tbody>';

            if ($paginacion->getTotalFilas() > 0)
            {
               foreach ($filas as $usuario)
               {
                  $salida_html .= '
                     <tr>
                        <td>'.$usuario['nombre'].
                           $this->statusUsuarioIcono($usuario['online'], $usuario['status'], $usuario['status2'],
                              $usuario['suscripcion_status'], $usuario['suscripcion_status2']).'
                        </td>
                        <td>'.$usuario['ip'].'</td>
                        <td>'.$this->nombrePrivilegios($usuario['privilegios']).'</td>
                        <td>'.$this->nombreStatus($usuario['status']).'</td>
                        <td>';
                        $salida_html .= '
                           <div class="acciones">
                              <a class="e1" href="?id_usuario='.$usuario['id_usuario'].'" data-accion="ver_detalles"
                                 data-toggle="ver_detalles"><i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
                              </a>
                              <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="restablecer_preguntas"
                                 data-toggle="confirmar"><i class="glyphicon glyphicon-repeat"
                                 title="Restablecer pregunta de seguridad"></i>
                              </a>';
                              if ($usuario['privilegios'] > 2)
                              {
                                 $salida_html .= '<a class="e1" href="'.$usuario['id_usuario'].'" data-accion="eliminar_usuario"
                                    data-toggle="confirmar"><i class="glyphicon glyphicon-trash" title="Eliminar"></i>
                                 </a>';
                              }
                              $salida_html .= '<a class="e1" href="'.$usuario['id_usuario'].'"
                                 data-accion="modificar" data-toggle="actualizar_usuario"
                                 dbd_clave="'.$usuario['clave'].'"
                                 dbd_nombre="'.$usuario['nombre'].'"
                                 dbd_priv="'.$usuario['privilegios'].'"
                                 dbd_susc_tipo="'.$usuario['suscripcion_tipo'].'"
                                 dbd_susc_tiempo2="'.$usuario['suscripcion_tiempo2'].'"
                                 dbd_susc_dias="'.$usuario['suscripcion_dias'].'" >
                                 <i class="glyphicon glyphicon-edit" title="Modificar"></i>
                              </a>
                           </div> ';
                           if ($usuario['privilegios'] > 2)
                              $salida_html .= $this->__htmlCheck($usuario['status'], $usuario['id_usuario']);
                        $salida_html .= '</td>';
                     $salida_html .= '</tr>';
               } # fin foreach
            }
            else
            {
               $salida_html .= '<tr><td class="vacio" colspan="6">
                  No hay resultados.</td></tr>';
            }

                  $salida_html .= '</tbody>
               </table>
            </div>';

            $salida_html .= $paginacion->__html($pagina, 0);
      }

      return $salida_html;
   }

   private function __verDetallesUsuariosHtml($pagina, $id_usuario_get)
   {
      switch ($pagina)
      {
         case 'act':
            $fila = $this->consultaVerDetallesUsuarioOnline($id_usuario_get, $_SESSION['id_usuario']);
            break;
         case 'desc':
            $fila = $this->consultaVerDetallesUsuarioOffline($id_usuario_get, $_SESSION['id_usuario']);
            break;
         case 'susp':
            $fila = $this->consultaVerDetallesUsuarioSuspendido($id_usuario_get, $_SESSION['id_usuario']);
            break;
         case 'todos':
            $fila = $this->consultaVerDetallesUsuarioTodos($id_usuario_get, $_SESSION['id_usuario']);
            break;
         default:
            $fila = null;
            break;
      }

      $salida_html = $this->__barraBotonesVerDetallesHtml($pagina, $id_usuario_get, $fila);

      if ($fila) # Verifico que se haya encontrado algún registro.
      {
         $obj_suscripcion = new Suscripcion();
         $obj_notificacion = new Notificacion();

         $salida_html .= '
            <div class="container">
               <div class="col-xs-12 col-sm-5 col-md-5 col-lg-5">';
                  $salida_html .= $this->__panelVerDetallesHtml($fila, $pagina, $_SESSION['tipo_usuario']);
                  if ($fila['privilegios'] != 1)
                     $salida_html .= $obj_suscripcion->__panelVerDetallesHtml($fila);
               $salida_html .= '</div>'; # <!-- /.col-* -->
               $salida_html .= $obj_notificacion->__panelVerDetallesHtml($id_usuario_get);
            $salida_html .= '</div>'; # <!-- /.container -->
      }
      else
         $salida_html .= '<div class="col-lg-12 subtitulo2">Usuario no encontrado.</div>';

      return $salida_html;
   }

   /**
    * [Muestra los resultados de una búsqueda.]
    */
   private function __usuariosEncontradosHtml($pagina, $filtro_busqueda, $id_usuario_session)
   {
      switch ($pagina)
      {
         case 'act':
            $filas = $this->consultaBusquedaUsuariosOnline($filtro_busqueda, $_SESSION['id_usuario']);
            break;
         case 'desc':
            $filas = $this->consultaBusquedaUsuariosOffline($filtro_busqueda, $_SESSION['id_usuario']);
            break;
         case 'susp':
            $filas = $this->consultaBusquedaUsuariosSuspendidos($filtro_busqueda, $_SESSION['id_usuario']);
            break;
         case 'todos':
            $filas = $this->consultaBusquedaUsuariosTodos($filtro_busqueda, $_SESSION['id_usuario']);
            break;
         default:
            $filas = null;
            break;
      }

      $salida_html = $this->__barraBotonesBusquedaHtml($pagina, $filtro_busqueda);

      $salida_html .= '
         <div class="subtitulo">
            <p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos"
               data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i>
               Resultados de la búsqueda </a><span class="badge" style="background-color:#5bc0de">
               '.count($filas).'</span>
            </p>
         </div>';

      $salida_html .= '
         <div class="table-responsive">
            <table class="table table-usuarios">
               <thead>
                  <tr>
                     <th>Usuario</th>
                     <th>Dirección IP</th>
                     <th>Privilegios</th>
                     <th>Status</th>
                     <th>Acciones</th>
                  </tr>
               </thead>
               <tbody>';

               if ($filas)
               {
                  foreach ($filas as $usuario)
                  {
                     $salida_html .= '<tr>
                        <td>'.$usuario['nombre'].
                           $this->statusUsuarioIcono($usuario['online'], $usuario['status'], $usuario['status2'],
                              $usuario['suscripcion_status'], $usuario['suscripcion_status2']).'
                        </td>
                        <td>'.$usuario['ip'].'</td>
                        <td>'.$this->nombrePrivilegios($usuario['privilegios']).'</td>
                        <td>'.$this->nombreStatus($usuario['status']).'</td>
                        <td>';
                        $salida_html .= '
                           <div class="acciones">
                              <a class="e1" href="?id_usuario='.$usuario['id_usuario'].'" data-accion="ver_detalles"
                                 data-toggle="ver_detalles"><i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
                              </a>
                              <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="restablecer_preguntas"
                                 data-toggle="confirmar"><i class="glyphicon glyphicon-repeat"
                                 title="Restablecer pregunta de seguridad"></i>
                              </a>';
                              if ($usuario['privilegios'] > 2)
                              {
                                 $salida_html .= '<a class="e1" href="'.$usuario['id_usuario'].'" data-accion="eliminar_usuario"
                                    data-toggle="confirmar"><i class="glyphicon glyphicon-trash" title="Eliminar"></i>
                                 </a>';
                              }
                              $salida_html .= '<a class="e1" href="'.$usuario['id_usuario'].'"
                                 data-accion="modificar" data-toggle="actualizar_usuario"
                                 dbd_clave="'.$usuario['clave'].'"
                                 dbd_nombre="'.$usuario['nombre'].'"
                                 dbd_priv="'.$usuario['privilegios'].'"
                                 dbd_susc_tipo="'.$usuario['suscripcion_tipo'].'"
                                 dbd_susc_tiempo2="'.$usuario['suscripcion_tiempo2'].'"
                                 dbd_susc_dias="'.$usuario['suscripcion_dias'].'" >
                                 <i class="glyphicon glyphicon-edit" title="Modificar"></i>
                              </a>
                           </div> ';
                           if ($usuario['privilegios'] > 2)
                              $salida_html .= $this->__htmlCheck($usuario['status'], $usuario['id_usuario']);
                        $salida_html .= '</td>';
                     $salida_html .= '</tr>';
                  } # fin foreach
               }
               else
               {
                  $salida_html .= '<tr><td class="vacio" colspan="6">
                     No hay resultados de usuarios para <strong>'.$filtro_busqueda.'</strong>.</td></tr>';
               }
               $salida_html .= '</tbody>
            </table>
         </div>';

      return $salida_html;
   }

   public function __barraBotonesHtml($pagina)
   {
      $salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
                  <button class="btn btn-info" title="Actualizar" data-toggle="actualizar_html"  data-accion="actualizar_'.$pagina.'" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i>
                  </button>
                  <button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="crear_usuario"
                     data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i>
                  </button>
                  <div class="btn-group2">
                     <button type="button" class="btn btn-info" data-accion="eliminar_usuarios_array" data-toggle="confirmar"
                        title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="suspender_array" data-toggle="confirmar"
                        title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="reanudar_array" data-toggle="confirmar"
                        title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="restablecer_preguntas_array"
                        data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom">
                        <i class="glyphicon glyphicon-repeat"></i>
                     </button>
                  </div>
               </div>
               <div class="buscar">
                  <form id="form-buscar">
                     <input type="text" id="campo_busqueda" placeholder="Buscar usuario">
                     <a href="#" class="abrir-buscar">
                        <i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i>
                     </a>
                  </form>
               </div>
            </div>
         </div>';

      return $salida_html;
   }

   public function __barraBotonesBusquedaHtml($pagina, $filtro_busqueda)
   {
      $salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
                  <button class="btn btn-info" title="Volver" data-placement="bottom" onClick="history.go(-1)">
                     <i class="glyphicon glyphicon-arrow-left"></i>
                  </button>
                  <button class="btn btn-info" title="Actualizar" data-toggle="actualizar_html"  data-accion="actualizar_'.$pagina.'" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i>
                  </button>
                  <button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="crear_usuario"
                     data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i>
                  </button>
                  <div class="btn-group2">
                     <button type="button" class="btn btn-info" data-accion="eliminar_usuarios_array" data-toggle="confirmar"
                        title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="suspender_array" data-toggle="confirmar"
                        title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="reanudar_array" data-toggle="confirmar"
                        title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="restablecer_preguntas_array"
                        data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom">
                        <i class="glyphicon glyphicon-repeat"></i>
                     </button>
                  </div>
               </div>
               <div class="buscar">
                  <form id="form-buscar">
                     <input type="text" id="campo_busqueda" placeholder="Buscar usuario" value="'.$filtro_busqueda.'">
                     <a href="#" class="abrir-buscar">
                        <i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i>
                     </a>
                  </form>
               </div>
            </div>
         </div>';

      return $salida_html;
   }
}

?>