<?php

class Conexion
{
	private $servidor;
	private $bd;
	private $usuario;
	private $clave;
	private $mysqli;
	private $estc;
	private $array;

	function __construct()
	{
		$this->obtenerDatos();
		$this->conectar();
	}

	private function obtenerDatos()
	{
		$this->servidor = SERVIDOR;
		$this->bd = BD;
		$this->usuario = USUARIO;
		$this->clave = CLAVE;
	}

	private function conectar()
	{
		$this->mysqli = new mysqli($this->servidor, $this->usuario, $this->clave, $this->bd);

		if ($this->mysqli->connect_error)
			echo 'Error de conexion';
		else
			$this->mysqli->set_charset('utf8');
	}

	public function cerrar()
	{
		$this->mysqli->close();
	}

	public function ejecutar($sql)
	{
		$this->estc = $this->mysqli->query($sql);

		return $this->estc;
	}

	public function obtenerFilas($estc)
	{
		$this->array = $estc->fetch_assoc();

		return $this->array;
	}

	public function liberarResultados($estc)
	{
		$estc->free();
	}

	public function obtenerCantidadFilas($estc)
	{
		return $estc->num_rows;
	}

	public function ultimoId()
	{
		return $this->mysqli->insert_id;
	}

	public function prepararSql($sql)
	{
		$this->estc = $this->mysqli->prepare($sql);

		return $this->estc;
	}

	public function get_codigo_error()
	{
		return $this->mysqli->errno;
	}
}

?>