<?php

include_once 'Conexion.php';

class Notificacion
{
	public function guardar($id_usuario, $hoy_timestamp, $numero_actividad)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'INSERT INTO entradas (usuario_id, fecha, actividad)
      	VALUES ("'.$id_usuario.'", "'.$hoy_timestamp.'", "'.$numero_actividad.'")';

     	if ($bd->ejecutar($query))
        	$aux = 1;

      $bd->cerrar();

      return $aux;
	}

   public function guardarConIp($id_usuario, $ip, $hoy_timestamp, $numero_actividad)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'INSERT INTO entradas (usuario_id, direccion_ip, fecha, actividad)
         VALUES ("'.$id_usuario.'", "'.$ip.'", "'.$hoy_timestamp.'", "'.$numero_actividad.'")';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

	public function guardarPorLeer($privilegios, $id_notificacion, $id_administrador)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'INSERT INTO entradas_por_leer (id_entrada, id_usuario)
      	VALUES ("'.$id_notificacion.'", "'.$id_administrador.'")';

      if (($privilegios > 2) && ($id_administrador))
      {
      	if ($bd->ejecutar($query))
         	$aux = 1;
      }

      $bd->cerrar();

      return $aux;
	}

	public function pendientes()
	{
		$bd = new Conexion();
		$aux = 0;

		if ($_SESSION['tipo_usuario'] == 1)
		{
			$query = 'SELECT COUNT(*) AS notificaciones_pendientes
				FROM entradas WHERE actividad <> 3 AND leida = 0';
		}
		else if ($_SESSION['tipo_usuario'] == 2)
		{
			$query = 'SELECT COUNT(*) AS notificaciones_pendientes
				FROM entradas_por_leer
				JOIN entradas ON entradas_por_leer.id_entrada = entradas.id
				WHERE entradas_por_leer.id_usuario = "'.$_SESSION['id_usuario'].'"';
		}

		if ($estc = $bd->ejecutar($query))
		{
			$fila = $bd->obtenerFilas($estc);
         $aux = $fila['notificaciones_pendientes'];

         $bd->liberarResultados($estc);
		}

		$bd->cerrar();

		return $aux;
	}

	public function consultaEliminarTodas()
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'DELETE entradas, entradas_por_leer FROM entradas
      	LEFT JOIN entradas_por_leer ON entradas.id = entradas_por_leer.id_entrada';

     	if ($bd->ejecutar($query))
        	$aux = 1;

      $bd->cerrar();

      return $aux;
	}

	public function consultaEliminarHoy($hoy)
	{
		$bd = new Conexion();
      $aux = 0;
		$ultimos_24  = $hoy - (24 * 60 * 60);

      $query = 'DELETE entradas, entradas_por_leer FROM entradas
      	LEFT JOIN entradas_por_leer ON entradas.id = entradas_por_leer.id_entrada
      	WHERE entradas.fecha BETWEEN "'.$ultimos_24.'" AND "'.$hoy.'"';

     	if ($bd->ejecutar($query))
        	$aux = 1;

      $bd->cerrar();

      return $aux;
	}

	public function consultaEliminarSemana($hoy)
	{
		$bd = new Conexion();
      $aux = 0;
		$ultima_semana  = $hoy - (168 * 60 * 60);

      $query = 'DELETE entradas, entradas_por_leer FROM entradas
      	LEFT JOIN entradas_por_leer ON entradas.id = entradas_por_leer.id_entrada
      	WHERE entradas.fecha BETWEEN "'.$ultima_semana.'" AND "'.$hoy.'"';

     	if ($bd->ejecutar($query))
        	$aux = 1;

      $bd->cerrar();

      return $aux;
	}

	public function consultaEliminarMes($hoy)
	{
		$bd = new Conexion();
      $aux = 0;
		$ultimo_mes  = $hoy - (30 * 24 * 60 * 60);

      $query = 'DELETE entradas, entradas_por_leer FROM entradas
      	LEFT JOIN entradas_por_leer ON entradas.id = entradas_por_leer.id_entrada
      	WHERE entradas.fecha BETWEEN "'.$ultimo_mes.'" AND "'.$hoy.'"';

     	if ($bd->ejecutar($query))
        	$aux = 1;

      $bd->cerrar();

      return $aux;
	}

	public function consultaEliminarAnio($hoy)
	{
		$bd = new Conexion();
      $aux = 0;
		$ultimo_anio  = $hoy - (360 * 24 * 60 * 60);

      $query = 'DELETE entradas, entradas_por_leer FROM entradas
      	LEFT JOIN entradas_por_leer ON entradas.id = entradas_por_leer.id_entrada
      	WHERE entradas.fecha BETWEEN "'.$ultimo_anio.'" AND "'.$hoy.'"';

     	if ($bd->ejecutar($query))
        	$aux = 1;

      $bd->cerrar();

      return $aux;
	}

	public function actualizarLeidas($id_usuario_session, $privilegios_usuario_session)
	{
		$bd = new Conexion();
      $aux = 0;

      if ($privilegios_usuario_session == 1)
      	$query = 'UPDATE entradas SET leida = 1';
      else if ($privilegios_usuario_session == 2)
      {
      	$query = 'DELETE FROM entradas_por_leer
      		WHERE id_usuario = "'.$id_usuario_session.'"';
      }

     	if ($bd->ejecutar($query))
        	$aux = 1;

      $bd->cerrar();

      return $aux;
	}

	/**
	 * [Consulta las notificaciones en la ventana principal de las notificaciones.]
	 */
	public function consultaVistaPrincipal($id_usuario_session, $privilegios_usuario_session)
	{
		$bd = new Conexion();
      $data = [];
      $i = 0;

      if ($privilegios_usuario_session == 1)
      {
      	$query = 'SELECT entradas.*, registrados.nombre FROM entradas
      		JOIN registrados ON entradas.usuario_id = registrados.id_usuario
      		WHERE entradas.actividad <> 3
      		ORDER BY fecha DESC
      		LIMIT 0,10';
      }
      else if ($privilegios_usuario_session == 2)
      {
      	$query = 'SELECT entradas.*, registrados.nombre FROM entradas
      		JOIN registrados ON entradas.usuario_id = registrados.id_usuario
      		WHERE entradas.actividad <> 3 AND registrados.id_administrador = "'.$id_usuario_session.'"
      		ORDER BY fecha DESC
      		LIMIT 0,10';
      }

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
	}

	/**
	 * [Consulta todas las notificaciones en la ventana principal
	 *  de las notificaciones al hacer scroll.]
	 */
	public function consultaVistaPrincipalScroll($id_usuario_session, $privilegios_usuario_session)
	{
		$bd = new Conexion();
      $data = [];
      $i = 0;

      $this->validarSessionCantidadCargada();

      if ($privilegios_usuario_session == 1)
      {
      	$query = 'SELECT entradas.direccion_ip, entradas.fecha as fecha, entradas.fecha as fecha_formato_hora,
      		entradas.actividad, registrados.nombre FROM entradas
      		JOIN registrados ON entradas.usuario_id = registrados.id_usuario
      		WHERE entradas.actividad <> 3
      		ORDER BY fecha DESC
      		LIMIT '.$_SESSION['cantidad_cargada'].', 10';
      }
      else if ($privilegios_usuario_session == 2)
      {
      	$query = 'SELECT entradas.direccion_ip, entradas.fecha as fecha, entradas.fecha as fecha_formato_hora,
      		entradas.actividad, registrados.nombre FROM entradas
      		JOIN registrados ON entradas.usuario_id = registrados.id_usuario
      		WHERE entradas.actividad <> 3 AND registrados.id_administrador = "'.$id_usuario_session.'"
      		ORDER BY fecha DESC
      		LIMIT '.$_SESSION['cantidad_cargada'].', 10';
      }

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $data[$i]['fecha'] = date('d/m/Y', $data[$i]['fecha']);
            $data[$i]['fecha_formato_hora'] = date('h:i:s a', $data[$i]['fecha_formato_hora']);
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      $this->incrementarSessionCantidadCargada();

      return $data;
	}

	/**
	 * [Consulta las notificaciones de un usuario en la ventana ver_detalles.]
	 */
	private function consultaVerDetalles($id_usuario)
	{
		$bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT direccion_ip, fecha, actividad
			FROM entradas
			JOIN registrados ON entradas.usuario_id = registrados.id_usuario
			WHERE entradas.usuario_id = "'.$id_usuario.'"
			ORDER BY entradas.fecha DESC LIMIT 0, 10';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
	}

	/**
	 * [Consulta las notificaciones de un usuario en la ventana ver_detalles al
	 *  hacer scroll.]
	 */
	public function consultaVerDetallesScroll($id_usuario)
	{
		$bd = new Conexion();
      $data = [];
      $i = 0;

      $this->validarSessionCantidadCargada();

      $query = 'SELECT direccion_ip, fecha as fecha, fecha as fecha_formato_hora, actividad
			FROM entradas
			JOIN registrados ON entradas.usuario_id = registrados.id_usuario
			WHERE entradas.usuario_id = "'.$id_usuario.'"
			ORDER BY entradas.fecha DESC
			LIMIT '.$_SESSION['cantidad_cargada'].', 10';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $data[$i]['fecha'] = date('d/m/Y', $data[$i]['fecha']);
            $data[$i]['fecha_formato_hora'] = date('h:i:s a', $data[$i]['fecha_formato_hora']);
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      $this->incrementarSessionCantidadCargada();

      return $data;
	}

	public function nombreActividad($numero_actividad)
	{
		$nombre_actividad = [
			1  => 'Inició sesión por primera vez con el número de IP: ',
			2  => 'Inició sesión con nuevo número de IP: ',
			3  => 'Inició sesión',
			4  => 'Intentó iniciar sesión con un número de IP diferente: ',
			5  => 'Intentó iniciar sesión con la cuenta suspendida',
			#6 => 'Inició sesión por primera vez con una conexión eventual',
			7  => 'Pregunta de seguridad restablecida',
			#7 => 'IP restablecida',
			8  => 'Intento fallido de conexión simultánea',
			9  => 'La suscripción ha caducado',
			10 => 'Intentó iniciar sesión con la suscripción caducada',
			11 => 'Suscripción renovada',
			12 => 'Intentó iniciar sesión con suscripción semanal inválida',
			13 => 'Intentó iniciar sesión con suscripción de administrador caducada',
			14 => 'Intentó iniciar sesión con la cuenta de administrador suspendida' ];

		return $nombre_actividad[$numero_actividad];
	}

	public function listItemActividad($numero_actividad)
	{
		$list_item = [
			1  => 'list-group-item',
			2  => 'list-group-item',
			3  => 'list-group-item',
			4  => 'list-group-item list-group-item-warning',
			5  => 'list-group-item list-group-item-warning',
			6  => 'list-group-item',
			7  => 'list-group-item',
			8  => 'list-group-item list-group-item-warning',
			9  => 'list-group-item list-group-item-success',
			10 => 'list-group-item list-group-item-warning',
			11 => 'list-group-item',
			12 => 'list-group-item list-group-item-warning',
			13 => 'list-group-item list-group-item-warning',
			14 => 'list-group-item list-group-item-warning' ];

		return $list_item[$numero_actividad];
	}

	private function validarSessionCantidadCargada()
   {
   	if (!isset($_SESSION['cantidad_cargada']))
			$_SESSION['cantidad_cargada'] = 10;
   }

   private function incrementarSessionCantidadCargada()
   {
   	$_SESSION['cantidad_cargada'] += 10;
   }

   public function resetSessionCantidadCargada()
   {
   	unset($_SESSION['cantidad_cargada']);
   }

   public function __vistaHtml()
   {
   	$salida_html = $this->__barraBotonesHtml();

   	$salida_html .= '
   		<div class="col-xs-12 col-sm-8 col-sm-offset-2 col-md-8 col-md-offset-2 col-lg-6 col-lg-offset-3">
				<div class="panel panel-info">
					<div class="panel-heading">
						<h3 class="panel-title">Historial de notificaciones</h3>
					</div>';

   	if ($filas = $this->consultaVistaPrincipal($_SESSION['id_usuario'], $_SESSION['tipo_usuario']))
   	{
   		$salida_html .= '<ul class="list-group">';

   		foreach ($filas as $notificacion)
   		{
   			$salida_html .= '
   				<li class="'.$this->listItemActividad($notificacion['actividad']).'">
						<a href="todos.php?id_usuario='.$notificacion['usuario_id'].'">
							<i class="glyphicon glyphicon-user"></i> '.$notificacion['nombre'].'
						</a>
						<span style="font-weight:bold;float:right"> '.date('d/m/Y', $notificacion['fecha']).'</span>';

						$direccion_ip = ($notificacion['direccion_ip']) ? $notificacion['direccion_ip'] : '';

					$salida_html .= '
						<p class="list-group-item-text">
							<span style="float:right;color:#8899A6;font-size:12px;font-weight:bold">
							'.date('h:i:s a', $notificacion['fecha']).'</span>
							'.$this->nombreActividad($notificacion['actividad']).''.$direccion_ip.'
						</p>
					</li>';
   		} # fin foreach

   		$salida_html .= '
				</ul>
				<div id="cargar_entradas_footer" class="panel-footer" style="border-top:none;text-align:center">
					<span style="font-weight:bold;color:#5bc0de">...</span>
				</div>';
   	}
   	else
   	{
   		$salida_html .= '
				<div class="panel-body">
					No hay notificaciones hasta los momentos.
				</div>';
   	}

   	$salida_html .= '
   			</div>
   		</div>';

   	return $salida_html;
   }

	/**
    * [Muestra las notificaciones de un usuario en la sección
    *  ver_detalles de cualquier página.]
    */
   public function __panelVerDetallesHtml($id_usuario)
   {
   	$salida_html = '
   		<div class="col-xs-12 col-sm-7 col-md-7 col-lg-7">
				<div class="panel panel-info">
					<div class="panel-heading">
						<h3 class="panel-title">Historial de notificaciones</h3>
					</div>';

					if ($filas = $this->consultaVerDetalles($id_usuario))
					{
						$salida_html .= '<ul class="list-group">';

						foreach ($filas as $notificacion)
						{
							$salida_html .= '
 								<li class="'.$this->listItemActividad($notificacion['actividad']).'">
    								<span style="font-weight:bold" >'.date('d/m/Y', $notificacion['fecha']).'</span>
   								<span class="badge">'.date("h:i:s a", $notificacion['fecha']).'</span>';

   								$direccion_ip = ($notificacion['direccion_ip']) ? $notificacion['direccion_ip'] : '';

									$salida_html .= '<p class="list-group-item-text">
										'.$this->nombreActividad($notificacion['actividad']).''.$direccion_ip.
									'</p>';

  								$salida_html .= '</li>';
						} # fin while

						$salida_html .= '
							</ul>
							<div id="cargar_entradas_footer" class="panel-footer" style="border-top:none;text-align:center">
								<span style="font-weight:bold;color:#5bc0de">...</span>
							</div>';
					}
					else
						$salida_html .= '<div class="panel-body">No hay registros.</div>';

				$salida_html .= '</div>
			</div>';

		return $salida_html;
   }

   public function __barraBotonesHtml()
   {
   	$salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
                  <button class="btn btn-info" title="Actualizar" data-toggle="actualizar_html"
                  	data-accion="actualizar_notificaciones" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i>
                  </button>';
                  if ($_SESSION['tipo_usuario'] == 1)
                  {
							$salida_html .= '
								<div class="btn-group">
									<button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown"
										aria-expanded="false" title="Eliminar" data-placement="bottom">
										<i class="glyphicon glyphicon-trash"></i>
									</button>
								  	<ul class="dropdown-menu" role="menu">
									    <li><a href="#" data-toggle="eliminar" data-accion="hoy">Últimas 24 horas</a></li>
									    <li><a href="#" data-toggle="eliminar" data-accion="semana">Última semana</a></li>
									    <li><a href="#" data-toggle="eliminar" data-accion="mes">Último mes</a></li>
									    <li><a href="#" data-toggle="eliminar" data-accion="anio">Último año</a></li>
									    <li class="divider"></li>
									    <li><a href="#" data-toggle="eliminar" data-accion="todo">Todas</a></li>
								  	</ul>
							  	</div>';
						}
               $salida_html .= '</div>
            </div>
         </div>
      ';

      return $salida_html;
   }
}

?>