<?php

class Paginacion
{
	private $total_filas;
	private $total_paginas;
	private $filas_pagina;
	private $pag_num;
	private $offset;

	function __construct($valor_total_filas, $valor_pag_num)
	{
		$this->setTotalFilas($valor_total_filas);
		$this->setPagNum($valor_pag_num);
		$this->paginar();
	}

	public function setTotalFilas($valor_total_filas)
	{
		$this->total_filas = $valor_total_filas;
	}

	public function getTotalFilas()
	{
		return $this->total_filas;
	}

	public function setPagNum($valor_pag_num)
	{
		$this->pag_num = $valor_pag_num;
	}

	public function getPagNum()
	{
		return $this->pag_num;
	}

	public function getOffset()
	{
		return $this->offset;
	}

	public function getTotalPaginas()
	{
		return $this->total_paginas;
	}

	public function getFilasPagina()
	{
		return $this->filas_pagina;
	}

	private function paginar()
	{
		if($this->getTotalFilas() > 0)
      {
      	$this->filas_pagina = 30;
      	$this->total_paginas = ceil($this->total_filas / $this->filas_pagina);

      	if (isset($_GET['pag']))
      		$this->pag_num = $_GET['pag'];
      	else
      	{
      		if ($this->getPagNum() != 1)
					$this->pag_num = ($this->pag_num > $this->total_paginas) ? $this->pag_num - 1 : $this->pag_num;
				else
					$this->pag_num = $this->pag_num;
      	}

      	$this->offset = ($this->getPagNum() - 1) * $this->filas_pagina;
      }
	}

	public function __html($vista, $parametro_get_extra_priv)
	{
		$salida_html = '';

		$parametro_get_extra_priv = ($parametro_get_extra_priv == 0) ? ''
         : '&priv='.$parametro_get_extra_priv.'';

		if ($this->getTotalPaginas() > 1)
		{
			$salida_html = '<div style="clear:left;text-align:center"><ul class="pagination">';

			if ($this->getPagNum() != 1)
			{
				$salida_html .= '
					<li><a href="/cl/'.$vista.'.php?pag=1'.$parametro_get_extra_priv.'" class="paginate" style="cursor:pointer" title="Primero">
						&laquo;</a></li>
					<li><a href="/cl/'.$vista.'.php?pag='.($this->getPagNum()-1).$parametro_get_extra_priv.'"
						class="paginate" style="cursor:pointer" title="Anterior">&#8249;</a></li>';
			}

			$salida_html .= '<li><a class="paginate2">Página '.$this->getPagNum().' de '.$this->getTotalPaginas().'</a></li>';

			if ($this->getPagNum() != $this->getTotalPaginas())
			{
				$salida_html .= '
					<li><a href="/cl/'.$vista.'.php?pag='.($this->getPagNum() + 1).$parametro_get_extra_priv.'"
						class="paginate" style="cursor:pointer" title="Siguiente">&#8250;</a></li>
					<li><a href="/cl/'.$vista.'.php?pag='.$this->getTotalPaginas().$parametro_get_extra_priv.'"
						class="paginate" style="cursor:pointer" title="Último">&raquo;</a></li>';
			}

			$salida_html .= '</ul></div>';
		}

		return $salida_html;
	}

	/**
	 * [Únicamente para mostrar el paginado en las pantallas de los usuarios
	 *  gestionados por algún administrador.]
	 */
	public function __htmlUsuariosAdministrados($vista, $administrador, $filtro_priv)
	{
		$salida_html = '';

		$filtro_priv = ($filtro_priv == 0) ? '' : '&priv='.$filtro_priv.'';

		if ($this->getTotalPaginas() > 1)
		{
			$salida_html = '<div style="clear:left;text-align:center"><ul class="pagination">';

			if ($this->getPagNum() != 1)
			{
				$salida_html .= '
					<li><a href="/cl/'.$vista.'.php?administrador='.$administrador.$filtro_priv.'&pag=1"
						class="paginate" style="cursor:pointer" title="Primero">&laquo;</a></li>
					<li><a href="/cl/'.$vista.'.php?administrador='.$administrador.$filtro_priv.'&pag='.($this->getPagNum()-1).'"
						class="paginate" style="cursor:pointer" title="Anterior">&#8249;</a></li>';
			}

			$salida_html .= '<li><a class="paginate2">Página '.$this->getPagNum().' de '.$this->getTotalPaginas().'</a></li>';

			if ($this->getPagNum() != $this->getTotalPaginas())
			{
				$salida_html .= '
					<li><a href="/cl/'.$vista.'.php?administrador='.$administrador.$filtro_priv.'&pag='.($this->getPagNum() + 1).'"
						class="paginate" style="cursor:pointer" title="Siguiente">&#8250;</a></li>
					<li><a href="/cl/'.$vista.'.php?administrador='.$administrador.$filtro_priv.'&pag='.$this->getTotalPaginas().'"
						class="paginate" style="cursor:pointer" title="Último">&raquo;</a></li>';
			}

			$salida_html .= '</ul></div>';
		}

		return $salida_html;
	}

	# Únicamente para mostrar el paginado en la pantalla de reportes.
	public function __htmlReportes($fecha1, $semana)
	{
		$salida_html = '';

		if ($fecha1 != 0)
			$filtro1 = ($fecha1 == 0) ? '' : 'f1='.$fecha1.'';
		else if ($semana != 0)
			$filtro1 = ($semana == 0) ? '' : 'sem='.$semana.'';

		if ($this->getTotalPaginas() > 1)
		{
			$salida_html = '<div style="clear:left;text-align:center"><ul class="pagination">';

			if ($this->getPagNum() != 1)
			{
				$salida_html .= '
					<li><a href="/cl/reportes.php?'.$filtro1.'&pag=1"
						class="paginate" style="cursor:pointer" title="Primero">&laquo;</a></li>
					<li><a href="/cl/reportes.php?'.$filtro1.'&pag='.($this->getPagNum()-1).'"
						class="paginate" style="cursor:pointer" title="Anterior">&#8249;</a></li>';
			}

			$salida_html .= '
				<li><a class="paginate2">Página '.$this->getPagNum().' de '.$this->getTotalPaginas().'</a></li>';

			if ($this->getPagNum() != $this->getTotalPaginas())
			{
				$salida_html .= '
					<li><a href="/cl/reportes.php?'.$filtro1.'&pag='.($this->getPagNum() + 1).'"
						class="paginate" style="cursor:pointer" title="Siguiente">&#8250;</a></li>
					<li><a href="/cl/reportes.php?'.$filtro1.'&pag='.$this->getTotalPaginas().'"
						class="paginate" style="cursor:pointer" title="Último">&raquo;</a></li>';
			}

			$salida_html .= '</ul></div>';
		}

		return $salida_html;
	}

	# Paginado para los canales remotos.
	public function __htmlCanalesRemotos()
	{
		$salida_html = '';

		if ($this->getTotalPaginas() > 1)
		{
			$salida_html = '<div style="clear:left;text-align:center"><ul class="pagination">';

			if ($this->getPagNum() != 1)
			{
				$salida_html .= '
					<li><a href="?pag=1" class="paginate" style="cursor:pointer" title="Primero">
						&laquo;</a></li>
					<li><a href="?pag='.($this->getPagNum()-1).'"
						class="paginate" style="cursor:pointer" title="Anterior">&#8249;</a></li>';
			}

			$salida_html .= '<li><a class="paginate2">Página '.$this->getPagNum().' de '.$this->getTotalPaginas().'</a></li>';

			if ($this->getPagNum() != $this->getTotalPaginas())
			{
				$salida_html .= '
					<li><a href="?pag='.($this->getPagNum() + 1).'"
						class="paginate" style="cursor:pointer" title="Siguiente">&#8250;</a></li>
					<li><a href="?pag='.$this->getTotalPaginas().'"
						class="paginate" style="cursor:pointer" title="Último">&raquo;</a></li>';
			}

			$salida_html .= '</ul></div>';
		}

		return $salida_html;
	}
}

?>