<?php

include_once 'Conexion.php';

class PreguntaSeguridad
{
	public function registrar($pregunta, $respuesta, $respuesta_confirmacion,
		$id_usuario_session, $privilegios_usuario_session, $ip_usuario_session, $hoy)
	{
		$bd = new Conexion();
		$aux = 0;
		$window_location = ($privilegios_usuario_session == 5) ? '/mix/index.php' : '/';

		if ($respuesta != $respuesta_confirmacion) # Valido que las respuestas no sean diferentes
			$aux = 2; # Respuestas diferentes
		{
			$query = 'INSERT INTO preguntas (id_usuario, pregunta1, respuesta1)
				VALUES ("'.$id_usuario_session.'", "'.$pregunta.'", "'.$respuesta.'")';

			if ($bd->ejecutar($query))
			{
				$aux = 1; # Pregunta registrada.
				$obj_usuario = new Usuario();
				$obj_notificacion = new Notificacion();

				# Modifico el nuevo ip y el inicio en 1
				$this->consultaModificarIpInicio($id_usuario_session, $ip_usuario_session);

				# Consulto el id del administrador (si existe) para la entrada por leer
				$id_administrador = $obj_usuario->obtenerIdAdministrador($id_usuario_session);

				# Consulto la dirección IP actual del usuario
				$ip_actual = $obj_usuario->consultarValorIp($id_usuario_session);

				# Verifico el valor del IP para registrar el tipo de entrada
				if ($ip_actual == 'Usuario nuevo')
				{
					$obj_notificacion->guardarConIp($id_usuario_session, $ip_usuario_session, $hoy, 1);
					$ultimo_id = $bd->ultimoId();
					$obj_notificacion->guardarPorLeer($privilegios_usuario_session, $ultimo_id, $id_administrador);
				}
				else
				{
					$obj_notificacion->guardarConIp($id_usuario_session, $ip_usuario_session, $hoy, 2);
					$ultimo_id = $bd->ultimoId();
					$obj_notificacion->guardarPorLeer($privilegios_usuario_session, $ultimo_id, $id_administrador);
				}
			}
		}

		$bd->cerrar();

		$salida_json = json_encode([
         'aux' => $aux,
         'window_location' => $window_location ]);

      return $salida_json;
	}

	public function responder($respuesta, $id_usuario_session,
		$privilegios_usuario_session, $ip_usuario_session, $hoy)
	{
		$bd = new Conexion();
		$aux = 0;
		$window_location = ($privilegios_usuario_session == 5) ? '/mix/index.php' : '/';

		if ($this->consultaRespuesta($id_usuario_session) == trim($respuesta))
		{
			$obj_usuario = new Usuario();
			$obj_notificacion = new Notificacion();

			# Modifico el nuevo ip
			$obj_usuario->modificarIp($id_usuario_session, $ip_usuario_session);

			# Consulto el id del administrador (si existe) para la entrada por leer
			$id_administrador = $obj_usuario->obtenerIdAdministrador($id_usuario_session);

			# Registro las notificaciones
			$obj_notificacion->guardarConIp($id_usuario_session, $ip_usuario_session, $hoy, 2);
			$ultimo_id = $bd->ultimoId();
			$obj_notificacion->guardarPorLeer($privilegios_usuario_session, $ultimo_id, $id_administrador);

			$aux = 1; # Las respuestas coinciden.
		}

		$bd->cerrar();

		$salida_json = json_encode([
         'aux' => $aux,
         'window_location' => $window_location ]);

      return $salida_json;
	}

	private function consultaModificarIpInicio($id_usuario_session, $ip_usuario_session)
	{
		$bd = new Conexion();
      $aux = 0;

		$query = 'UPDATE registrados
			SET ip = "'.$ip_usuario_session.'", inicio = 1
			WHERE id_usuario = "'.$id_usuario_session.'"';

		if ($bd->ejecutar($query))
         $aux = 1;

		$bd->cerrar();

      return $aux;
	}

	private function consultaRespuesta($id_usuario_session)
	{
		$bd = new Conexion();
      $aux = 0;

		$query = 'SELECT respuesta1 FROM preguntas
			JOIN registrados ON preguntas.id_usuario = registrados.id_usuario
			WHERE registrados.id_usuario = "'.$id_usuario_session.'"';

		if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['respuesta1'];

         $bd->liberarResultados($estc);
      }

		$bd->cerrar();

      return $aux;
	}

	private function consultaPregunta($id_usuario)
	{
		$bd = new Conexion();
      $aux = 0;

		$query = 'SELECT pregunta1 FROM preguntas
			WHERE id_usuario = "'.$id_usuario.'"';

		if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['pregunta1'];

         $bd->liberarResultados($estc);
      }

		$bd->cerrar();

      return $aux;
	}

	public function getStringPregunta($id_usuario)
	{
		$preguntas = [
			0 => 'Ha ocurrido un error.',
			1 => '¿Donde nació tu padre?',
			2 => '¿Nombre de tu mejor amigo de la infancia?',
			3 => '¿Nombre de tu abuela materna?',
			4 => '¿Cuál es el personaje histórico favorito de tu madre?',
			5 => '¿Nombre de tu abuelo paterno?' ];

		return $preguntas[$this->consultaPregunta($id_usuario)];
	}
}

?>