<?php

include_once 'Conexion.php';
include_once 'Obfuscate.php';
include_once 'Paginacion.php';

class CanalRemoto
{	
   public function guardar($url, $rtmp, $activo, $nombre,
      $iframe_activo, $url_iframe)
   {
      $bd = new Conexion();
      $aux = 0;

      if ($url != '' || $rtmp != ''|| $nombre != '')
      {
         $obj_obfuscate = new Obfuscate();

         $query = 'INSERT INTO canal_remoto
            (url, rtmp, activo, nombre, iframe_url, iframe_status)
            VALUES ("'.$obj_obfuscate->urlObfuscar(trim($url)).'",
            "'.$obj_obfuscate->rtmpObfuscar(trim($rtmp)).'",
            "'.$activo.'", "'.trim($nombre).'",
            "'.trim($url_iframe).'", "'.$iframe_activo.'")';

         if ($bd->ejecutar($query))
            $aux = 1;
         else if ($bd->get_codigo_error() == 1062)
            $aux = 1062;

         $bd->cerrar();
      }

      return $aux;
   }

   public function modificar($id_canal, $url, $rtmp, $activo, $nombre,
      $iframe_activo, $url_iframe)
   {
      $bd = new Conexion();
      $aux = 0;

      if ($url != '' || $rtmp != '' || $nombre != '')
      {
         $obj_obfuscate = new Obfuscate();

         $query = 'UPDATE canal_remoto SET
            url = "'.$obj_obfuscate->urlObfuscar(trim($url)).'",
            rtmp = "'.$obj_obfuscate->rtmpObfuscar(trim($rtmp)).'",
            activo = "'.$activo.'",
            nombre = "'.trim($nombre).'",
            iframe_url = "'.trim($url_iframe).'",
            iframe_status = "'.$iframe_activo.'"
            WHERE id_canal = "'.$id_canal.'"';

         if ($bd->ejecutar($query))
            $aux = 1;
         else if ($bd->get_codigo_error() == 1062)
            $aux = 1062;

         $bd->cerrar();
      }

      return $aux;
   }

   public function eliminar($id_canal)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'DELETE FROM canal_remoto
         WHERE id_canal = "'.$id_canal.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   # Elimina varios registros a la vez.
   public function eliminar_array()
   {
      $bd = new Conexion();
      $aux = 0;
      $seleccionados = $_POST['seleccionados'];

      if (!empty($seleccionados))
      {
         $aux = 1;

         foreach ($seleccionados as $id_canal)
            $this->eliminar($id_canal);
      }

      $bd->cerrar();

      return $aux;
   }

   // Modifica el status de cada canal remoto.
   private function modificar_status($id_canal, $status)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE canal_remoto SET
         activo = "'.$status.'"
         WHERE id_canal = "'.$id_canal.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   // Modifica varios status a la vez.
   public function modificar_status_array($status)
   {
      $bd = new Conexion();
      $aux = 0;
      $seleccionados = $_POST['seleccionados'];

      if (!empty($seleccionados))
      {
         $aux = 1;

         foreach ($seleccionados as $id_canal)
            $this->modificar_status($id_canal, $status);
      }

      $bd->cerrar();

      return $aux;
   }

   // Modifica el atributo canal_menu de cada canal remoto.
   private function modificar_status_canal_menu($id_canal, $status)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE canal_remoto SET
         canal_menu = "'.$status.'"
         WHERE id_canal = "'.$id_canal.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   // Modifica varios atributos canal_menu a la vez.
   public function modificar_status_canal_menu_array($status)
   {
      $bd = new Conexion();
      $aux = 0;
      $seleccionados = $_POST['seleccionados'];

      if (!empty($seleccionados))
      {
         $aux = 1;

         foreach ($seleccionados as $id_canal)
            $this->modificar_status_canal_menu($id_canal, $status);
      }

      $bd->cerrar();

      return $aux;
   }

	public function consultaPorId($id_canal)
	{
		$bd = new Conexion();
		$fila = 0;

		$query = 'SELECT * FROM canal_remoto
			WHERE (id_canal = "'.$id_canal.'" AND activo = 1)';

		if ($estc = $bd->ejecutar($query))
		{
			$fila = $bd->obtenerFilas($estc);

			$bd->liberarResultados($estc);
		}

		$bd->cerrar();

		return $fila;
	}

   // Señal consultada desde el menu canales.
   public function consultaPorIdMenu($id_canal)
   {
      $bd = new Conexion();
      $fila = 0;

      $query = 'SELECT * FROM canal_remoto
         WHERE (id_canal = "'.$id_canal.'" AND activo = 1 AND canal_menu = 1)';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

	public function consultaTodos($paginacion)
	{
		$bd = new Conexion();
		$data = [];
      $i = 0;

		$query = "SELECT * FROM canal_remoto
         LIMIT ".$paginacion->getOffset().", ".$paginacion->getFilasPagina()."";

		if ($estc = $bd->ejecutar($query))
		{
         $obj_obfuscate = new Obfuscate();

			while ($filas = $bd->obtenerFilas($estc))
         {
            $filas['url'] = $obj_obfuscate->urlDesofuscar($filas['url']);
            $filas['rtmp'] = $obj_obfuscate->rtmpDesofuscar($filas['rtmp']);
            $data[$i] = $filas;
            $i++;
         }

			$bd->liberarResultados($estc);
		}

		$bd->cerrar();

		return $data;
	}

   // Consulta todas las señales para su gestión en el menú.
   public function consultaTodosMenu()
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT id_canal, nombre, canal_menu FROM canal_remoto
         WHERE activo = 1';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   # Arroja aquellas señales cuyo atributo canal_menu sea igual a 1.
   public function consultaTodosEnMenu()
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT id_canal, nombre FROM canal_remoto
         WHERE canal_menu = 1';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   // Obtiene la primera señal activa.
   public function consulta_primera()
   {
      $bd = new Conexion();
      $fila = 0;

      $query = 'SELECT * FROM canal_remoto
         WHERE (activo = 1 AND canal_menu = 1)
         LIMIT 1';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   private function numFilasTodos()
   {
      $bd = new Conexion();
      $num_filas = 0;

      $query = 'SELECT * FROM canal_remoto';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   # Busca todos las coincidencias por nombre o id.
   public function buscar($filtro)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT * FROM canal_remoto
         WHERE nombre LIKE "%'.$filtro.'%"
         UNION
         SELECT * FROM canal_remoto
         WHERE id_canal = "'.$filtro.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $obj_obfuscate = new Obfuscate();

         while ($filas = $bd->obtenerFilas($estc))
         {
            $filas['url'] = $obj_obfuscate->urlDesofuscar($filas['url']);
            $filas['rtmp'] = $obj_obfuscate->rtmpDesofuscar($filas['rtmp']);
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasBuscar($filtro)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $query = 'SELECT * FROM canal_remoto
         WHERE nombre LIKE "%'.$filtro.'%"
         UNION
         SELECT * FROM canal_remoto
         WHERE id_canal = "'.$filtro.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

	public function __consultaTodosHtml($nro_pag_get)
	{
		$salida_html = $this->__barraBotonesHtml();

      $paginacion = new Paginacion($this->numFilasTodos(), $nro_pag_get);
     		
		$salida_html .= '
         <div class="subtitulo">
            <p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos"
               data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i> Canales remotos</a>
               <span class="badge" style="background-color:#5bc0de">
               '.$paginacion->getTotalFilas().'</span>
            </p>
         </div>';

		$salida_html .= '
         <div class="table-responsive">
            <table class="table table-usuarios">
               <thead>
                  <tr>
                     <th>#</th>  
                     <th>ID</th>
                     <th>Nombre</th>
                     <th>URL</th>
                     <th>Status</th>
                     <th>Acciones</th>
                  </tr>
               </thead>
               <tbody>';

		if ($filas = $this->consultaTodos($paginacion))
		{
			$i = 1;
			foreach ($filas as $remote)
         {
            $activo = ($remote['activo'] == 1) ? 'Activo' : 'Inactivo';
            $salida_html .= '<tr>
            	<td>'.$i++.'</td>
               <td>'.$remote['id_canal'].'</td>
               <td>'.ucfirst($remote['nombre']).'</a>
               </td>
               <td class="elipse">
                  <a href="../cl/remote/remote_signal.php?id_signal='.$remote['id_canal'].'" target="_blank">
                  https://'.$_SERVER['SERVER_NAME'].
                  '/signal/cl/remote/remote_signal.php?id_signal='.$remote['id_canal'].'</a>
               </td>
               <td>'.$activo.'</td>
               <td>
               	<div class="acciones">
                     <a class="e1" href="'.$remote['id_canal'].'" data-accion="eliminar"
                        data-toggle="confirmar_eliminar">
                        <i class="glyphicon glyphicon-trash" title="Eliminar"></i>
                     </a>
                     <a class="e1" href="'.$remote['id_canal'].'"
                        data-accion="modificar" data-toggle="modificar_remote"
                        dbd_id="'.$remote['id_canal'].'"
                        dbd_nombre="'.$remote['nombre'].'"
                        dbd_url="'.$remote['url'].'"
                        dbd_rtmp="'.$remote['rtmp'].'"
                        dbd_activo="'.$remote['activo'].'"
                        dbd_iframe_url="'.$remote['iframe_url'].'"
                        dbd_iframe_status="'.$remote['iframe_status'].'">
                        <i class="glyphicon glyphicon-edit" title="Modificar"></i>
                     </a>
                  </div> ';
                  $salida_html .= $this->__htmlCheck($remote['activo'], $remote['id_canal']);
               $salida_html .= '</td>
            </tr>';
         }
         $salida_html .= '
               </tbody>
            </table>
         </div>';
		}
		else
		{
			$salida_html .= '
                  <tr><td class="vacio" colspan="6">No hay resultados.</td></tr>
               </tbody>
            </table>
         </div>';
		}

      $salida_html .= $paginacion->__htmlCanalesRemotos();

		return $salida_html;
	}

   private function __barraBotonesHtml()
   {
      $salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
                  <button class="btn btn-info" title="Nuevo canal remoto" data-toggle="crear_remoto"
                     data-target="#modal_canal_remoto" data-placement="bottom">
                     <i class="glyphicon glyphicon-plus-sign"></i>
                  </button>
                  <button class="btn btn-info" title="Gestionar menú de canales" data-toggle="menu_canales"
                     data-placement="bottom"><i class="glyphicon glyphicon-th-list"></i>
                  </button>
                  <div class="btn-group2">
                     <button type="button" class="btn btn-info" data-toggle="confirmar_eliminar_array"
                        title="Eliminar" data-placement="bottom">
                        <i class="glyphicon glyphicon-trash"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-toggle="confirmar_inactivar"
                        title="Inactivar canal remoto" data-placement="bottom">
                        <i class="glyphicon glyphicon-minus"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-toggle="confirmar_activar"
                        title="Activar canal remotoo" data-placement="bottom">
                        <i class="glyphicon glyphicon-ok"></i>
                     </button>
                  </div>
               </div>
               <div class="buscar">
                  <form id="form-buscar">
                     <input type="text" id="campo_busqueda" placeholder="Buscar canal remoto">
                     <a href="#" class="abrir-buscar">
                        <i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i>
                     </a>
                  </form>
               </div>
            </div>
         </div>';

      return $salida_html;
   }

   private function __consutaBusquedaHtml($busqueda_get)
   {
      $salida_html = $this->__barraBotonesBusquedaHtml($busqueda_get);
         
      $salida_html .= '
         <div class="subtitulo">
            <p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos"
               data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i>
               Resultados de la búsqueda</a>
               <span class="badge" style="background-color:#5bc0de">
               '.$this->numFilasBuscar($busqueda_get).'</span>
            </p>
         </div>';

      $salida_html .= '
         <div class="table-responsive">
            <table class="table table-usuarios">
               <thead>
                  <tr>
                     <th>#</th>  
                     <th>ID</th>
                     <th>Nombre</th>
                     <th>URL</th>
                     <th>Status</th>
                     <th>Acciones</th>
                  </tr>
               </thead>
               <tbody>';

      if ($filas = $this->buscar($busqueda_get))
      {
         $i = 1;
         foreach ($filas as $remote)
         {
            $activo = ($remote['activo'] == 1) ? 'Activo' : 'Inactivo';
            $salida_html .= '<tr>
               <td>'.$i++.'</td>
               <td>'.$remote['id_canal'].'</td>
               <td>'.ucfirst($remote['nombre']).'</a>
               </td>
               <td class="elipse">
                  <a href="../cl/remote/remote_signal.php?id_signal='.$remote['id_canal'].'" target="_blank">
                  https://'.$_SERVER['SERVER_NAME'].
                  '/signal/cl/remote/remote_signal.php?id_signal='.$remote['id_canal'].'</a>
               </td>
               <td>'.$activo.'</td>
               <td>
                  <div class="acciones">
                     <a class="e1" href="'.$remote['id_canal'].'" data-accion="eliminar"
                        data-toggle="confirmar_eliminar">
                        <i class="glyphicon glyphicon-trash" title="Eliminar"></i>
                     </a>
                     <a class="e1" href="'.$remote['id_canal'].'"
                        data-accion="modificar" data-toggle="modificar_remote"
                        dbd_id="'.$remote['id_canal'].'"
                        dbd_nombre="'.$remote['nombre'].'"
                        dbd_url="'.$remote['url'].'"
                        dbd_rtmp="'.$remote['rtmp'].'"
                        dbd_activo="'.$remote['activo'].'"
                        dbd_iframe_url="'.$remote['iframe_url'].'"
                        dbd_iframe_status="'.$remote['iframe_status'].'">
                        <i class="glyphicon glyphicon-edit" title="Modificar"></i>
                     </a>
                  </div> ';
                  $salida_html .= $this->__htmlCheck($remote['activo'], $remote['id_canal']);
               $salida_html .= '</td>
            </tr>';
         }
         $salida_html .= '
               </tbody>
            </table>
         </div>';
      }
      else
      {
         $salida_html .= '
                  <tr><td class="vacio" colspan="6">No hay resultados.</td></tr>
               </tbody>
            </table>
         </div>';
      }

      return $salida_html;
   }

   private function __barraBotonesBusquedaHtml($busqueda_get)
   {
      $salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
                   <button class="btn btn-info" title="Volver" data-placement="bottom"
                     onClick="history.go(-1)"><i class="glyphicon glyphicon-arrow-left"></i>
                  </button>
                  <button class="btn btn-info" title="Nuevo canal remoto" data-toggle="crear_remoto"
                     data-target="#modal_canal_remoto" data-placement="bottom">
                     <i class="glyphicon glyphicon-plus-sign"></i>
                  </button>
                  <button class="btn btn-info" title="Gestionar menú de canales" data-toggle="menu_canales"
                     data-placement="bottom"><i class="glyphicon glyphicon-th-list"></i>
                  </button>
                  <div class="btn-group2">
                     <button type="button" class="btn btn-info" data-toggle="confirmar_eliminar_array"
                        title="Eliminar" data-placement="bottom">
                        <i class="glyphicon glyphicon-trash"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-toggle="confirmar_inactivar"
                        title="Inactivar canal remoto" data-placement="bottom">
                        <i class="glyphicon glyphicon-minus"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-toggle="confirmar_activar"
                        title="Activar canal remotoo" data-placement="bottom">
                        <i class="glyphicon glyphicon-ok"></i>
                     </button>
                  </div>
               </div>
               <div class="buscar">
                  <form id="form-buscar">
                     <input type="text" id="campo_busqueda" placeholder="Buscar canal remoto"
                        value="'.$busqueda_get.'">
                     <a href="#" class="abrir-buscar">
                        <i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i>
                     </a>
                  </form>
               </div>
            </div>
         </div>';

      return $salida_html;
   }

   public function __htmlCheck($id_remote)
   {
      return '<input type="checkbox" name="my-checkbox" class="bootstrap-switch-mini"
         value="'.$id_remote.'" checked>';
   }

   public function __html($busqueda_get, $nro_pag_get)
   {
      if ($busqueda_get)
         return $this->__consutaBusquedaHtml($busqueda_get);
      else
         return $this->__consultaTodosHtml($nro_pag_get);
   }
}

?>