<?php

require_once(dirname(__FILE__).'/'.'Admin.php');
include_once 'Conexion.php';
include_once 'Paginacion.php';

class SuperAdministrador extends Admin
{
   public function guardarUsuario($id_super_administrador, $nombre, $clave, $privilegios,
      $suscripcion, $tiempo_suscripcion, $id_responsable)
   {
      $aux = 0;

      if ($privilegios == 1 || $privilegios == 2)
      {
         $aux = $this->guardarUsuarioAdmin($id_super_administrador, $nombre, $clave, $privilegios,
            $suscripcion, $tiempo_suscripcion);
      }
      else if ($privilegios >= 3)
      {
         $aux = $this->guardarUsuarioEstandar($id_super_administrador, $nombre, $clave, $privilegios,
            $suscripcion, $tiempo_suscripcion, $id_responsable);
      }

      return $aux;
   }

   /**
    * [Guarda usuarios con privilegios de superadministrador o administrador.]
    */
   private function guardarUsuarioAdmin($id_super_administrador, $nombre, $clave, $privilegios,
      $suscripcion, $tiempo_suscripcion)
   {
      $bd = new Conexion();
      $aux = 0;

      if ($nombre != '' && $clave != '')
      {
         $query_buscar = 'SELECT id_usuario FROM registrados
            WHERE nombre = "'.$nombre.'"';

         $query_guardar = 'INSERT INTO registrados (ip, nombre, clave, privilegios)
            VALUES ("Usuario nuevo", trim("'.$nombre.'"), trim("'.$clave.'"), "'.$privilegios.'")';

         if ($estc = $bd->ejecutar($query_buscar))
         {
            if ($bd->obtenerCantidadFilas($estc) > 0)
               $aux = 2; # nombre de usuario repetido
            else if ($bd->ejecutar($query_guardar))
            {
               $aux = 1; # usuario registrado exitosamente

               if ($privilegios == 2)
               {
                  $ultimo_id = $bd->ultimoId();
                  $obj_suscripcion = new Suscripcion();
                  $obj_suscripcion->guardar($ultimo_id, $suscripcion, $tiempo_suscripcion, $_POST['dias_suscripcion']);
                  $this->enlazarUsuarioSuperadmin($id_super_administrador, $ultimo_id);
                  $this->guardarConteoAdministrador($ultimo_id, $_POST['usuarios_permitidos'],
                     $_POST['cantidad_usuarios_permitidos']);
               }
            }
         }

         $bd->cerrar();
      }

      return $aux;
   }

   /**
    * [Guarda usuarios con privilegios de estandar.]
    */
   private function guardarUsuarioEstandar($id_super_administrador, $nombre, $clave, $privilegios,
      $suscripcion, $tiempo_suscripcion, $id_responsable)
   {
      $bd = new Conexion();
      $aux = 0;

      if ($nombre != '' && $clave != '' && $id_responsable)
      {
         $query_buscar = 'SELECT id_usuario FROM registrados
            WHERE nombre = "'.$nombre.'"';

         $query_guardar = 'INSERT INTO registrados (ip, nombre, clave, privilegios, id_administrador)
            VALUES ("Usuario nuevo", trim("'.$nombre.'"), trim("'.$clave.'"), "'.$privilegios.'", "'.$id_responsable.'")';

         if ($estc = $bd->ejecutar($query_buscar))
         {
            if ($bd->obtenerCantidadFilas($estc) > 0)
               $aux = 2; # nombre de usuario repetido
            else if ($this->validarUsuariosPermitidosAdministrador($id_responsable, $privilegios) == false)
               $aux = 5; # asignación (responsable) de un usuario no permitido
            else if ($this->validarConteoAdministrador($id_responsable, $privilegios) == 0)
               $aux = 5; # el responsable no puede tener más usuarios
            else if ($bd->ejecutar($query_guardar))
            {
               $aux = 1; # usuario registrado exitosamente

               $ultimo_id = $bd->ultimoId();
               $obj_suscripcion = new Suscripcion();
               $obj_suscripcion->guardar($ultimo_id, $suscripcion, $tiempo_suscripcion, $_POST['dias_suscripcion']);
               $this->enlazarUsuarioSuperadmin($id_super_administrador, $ultimo_id);
               $this->incrementarConteoAdministrador($id_responsable, $privilegios);
            }
         }

         $bd->cerrar();
      }

      return $aux;
   }

   public function modificarUsuario($id_usuario_modificar, $nombre, $privilegios, $suscripcion,
      $tiempo_suscripcion, $clave_nueva, $clave_confirmar, $id_responsable)
   {
      $bd = new Conexion();
      $aux = 0;

      if ( $nombre != '' && $privilegios != '' )
      {
         $query_buscar = 'SELECT id_usuario FROM registrados
            WHERE nombre COLLATE utf8_bin="'.$nombre.'" AND id_usuario <> "'.$id_usuario_modificar.'"';

         $id_administrador = $this->obtenerIdAdministrador($id_usuario_modificar);

         if ($estc = $bd->ejecutar($query_buscar))
         {
            if ($bd->obtenerCantidadFilas($estc) > 0)
               $aux = 2; # nombre de usuario repetido
            else if (($privilegios > 2 && $id_administrador != $id_responsable)
               && ($this->validarUsuariosPermitidosAdministrador($id_responsable, $privilegios) == false))
            {
               $aux = 5; # asignación (responsable) de un usuario no permitido
            }
            else if (($privilegios > 2 && $id_administrador != $id_responsable)
               && ($this->validarConteoAdministrador($id_responsable, $privilegios) == 0))
            {
               $aux = 5; # el responsable no puede tener más usuarios
            }
            else
            {
               $privilegios_actual = $this->obtenerPrivilegiosUsuario($id_usuario_modificar);

               if (($privilegios_actual > 2 && $privilegios > 2) && ($privilegios_actual != $privilegios)
                  && ($this->validarUsuariosPermitidosAdministrador($id_responsable, $privilegios) == false))
               {
                  $aux = 5; # asignación (responsable) de un usuario no permitido
               }
               else if (($privilegios_actual > 2 && $privilegios > 2) && ($privilegios_actual != $privilegios)
                  && ($this->validarConteoAdministrador($id_responsable, $privilegios) == 0))
               {
                  $aux = 5; # el responsable no puede tener más usuarios
               }
               else
               {
                  /**
                   * Valido para que solo pueda modificarse a si mismo o a otro usuario
                   * que no sea super_administrador.
                   */
                  if (($id_usuario_modificar == $_SESSION['id_usuario']) || ($privilegios_actual != 1))
                  {
                     if (($clave_nueva != '') && ($clave_confirmar != ''))
                     {
                        if ($clave_nueva == $clave_confirmar)
                        {
                           $query_actualizar = 'UPDATE registrados
                              SET nombre = "'.trim($nombre).'", clave = "'.trim($clave_nueva).'",
                              privilegios = "'.trim($privilegios).'"
                              WHERE id_usuario = "'.$id_usuario_modificar.'"';
                        }
                     }
                     else
                     {
                        $query_actualizar = 'UPDATE registrados
                              SET nombre = "'.trim($nombre).'", privilegios = "'.trim($privilegios).'"
                              WHERE id_usuario = "'.$id_usuario_modificar.'"';
                     }

                     $obj_suscripcion = new Suscripcion();

                     if ($id_administrador)
                     {
                        if ($privilegios <= 2)
                        {
                           $this->resetAdministrador($id_usuario_modificar);
                           $this->decrementarConteoAdministrador($id_administrador, 1, $privilegios_actual);

                           if ($privilegios == 1)
                           {
                              $this->modificarStatus($id_usuario_modificar, 0);
                              $obj_suscripcion->eliminar($id_usuario_modificar);
                           }
                           else if ($privilegios == 2)
                           {
                              $this->guardarConteoAdministrador($id_usuario_modificar, $_POST['usuarios_permitidos'],
                                 $_POST['cantidad_usuarios_permitidos']);
                              $obj_suscripcion->actualizar($id_usuario_modificar, $suscripcion, $tiempo_suscripcion,
                                 $_POST['dias_suscripcion']);
                           }
                        }
                        else
                        {
                           $obj_suscripcion->actualizar($id_usuario_modificar, $suscripcion, $tiempo_suscripcion,
                              $_POST['dias_suscripcion']);

                           $this->asignarResponsable($id_usuario_modificar, $privilegios, $privilegios_actual,
                                 $id_responsable, $id_administrador);
                        }
                     }
                     else
                     {
                        if ($privilegios == 2)
                        {
                           if ($this->obtenerIdAdministradorDesdeConteoAdministrador($id_usuario_modificar) != 0)
                           {
                              $this->modificarConteoAdministrador($id_usuario_modificar, $_POST['usuarios_permitidos'],
                                 $_POST['cantidad_usuarios_permitidos']);
                           }
                           else
                           {
                              $this->guardarConteoAdministrador($id_usuario_modificar, $_POST['usuarios_permitidos'],
                                 $_POST['cantidad_usuarios_permitidos']);
                           }

                           $obj_suscripcion->actualizar($id_usuario_modificar, $suscripcion, $tiempo_suscripcion,
                              $_POST['dias_suscripcion']);
                        }
                        else
                        {
                           $this->eliminarConteoAdministrador($id_usuario_modificar);

                           if ($privilegios == 1)
                              $obj_suscripcion->eliminar($id_usuario_modificar);
                           if ($privilegios > 2)
                           {
                              $obj_suscripcion->actualizar($id_usuario_modificar, $suscripcion, $tiempo_suscripcion,
                                 $_POST['dias_suscripcion']);

                              $this->asignarResponsable($id_usuario_modificar, $privilegios, $privilegios_actual,
                                 $id_responsable, $id_administrador);
                           }
                        }
                     }

                     $bd->ejecutar($query_actualizar);
                     $aux = 1;
                  }
               }
            }
         }
      }

      return $aux;
   }

   public function eliminarUsuario($id_usuario_eliminar)
   {
      $bd = new Conexion();
      $aux = 0;

      $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario_eliminar);

      if ($privilegios_usuario == 2)
      {
         if ($this->eliminarUsuarioAdministrador($id_usuario_eliminar))
            $aux = 1;
      }
      else if ($privilegios_usuario > 2)
      {
         $id_administrador = $this->obtenerIdAdministrador($id_usuario_eliminar);

         if ($this->eliminarUsuarioEstandar($id_usuario_eliminar))
         {
            $this->decrementarConteoAdministrador($id_administrador, 1, $privilegios_usuario);
            $aux = 1;
         }
      }

      $this->eliminarEnlaceUsuarioSuperadmin($id_usuario_eliminar);

      $bd->cerrar();

      return $aux;
   }

   public function eliminarArrayUsuarios()
   {
      $bd = new Conexion();
      $aux = 0;

      if (!empty($_POST['seleccion']))
      {
         $aux = 1;

         foreach ($_POST['seleccion'] as $id_usuario_eliminar)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario_eliminar);

            if ($privilegios_usuario == 2)
               $this->eliminarUsuarioAdministrador($id_usuario_eliminar);
            else if ($privilegios_usuario > 2)
            {
               $id_administrador = $this->obtenerIdAdministrador($id_usuario_eliminar);

               if ($this->eliminarUsuarioEstandar($id_usuario_eliminar))
                  $this->decrementarConteoAdministrador($id_administrador, 1, $privilegios_usuario);
            }

            $this->eliminarEnlaceUsuarioSuperadmin($id_usuario_eliminar);
         }
      }

      if (!empty($_POST['seleccion2']))
      {
         $aux = 1;

         foreach ($_POST['seleccion2'] as $id_usuario_eliminar)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario_eliminar);

            if ($privilegios_usuario == 2)
               $this->eliminarUsuarioAdministrador($id_usuario_eliminar);
            else if ($privilegios_usuario > 2)
            {
               $id_administrador = $this->obtenerIdAdministrador($id_usuario_eliminar);

               if ($this->eliminarUsuarioEstandar($id_usuario_eliminar))
                  $this->decrementarConteoAdministrador($id_administrador, 1, $privilegios_usuario);
            }

            $this->eliminarEnlaceUsuarioSuperadmin($id_usuario_eliminar);
         }
      }

      $bd->cerrar();

      return $aux;
   }

   public function suspenderUsuariosArray()
   {
      $bd = new Conexion();
      $aux = 0;

      if (!empty($_POST['seleccion']))
      {
         foreach ($_POST['seleccion'] as $id_usuario)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario);
            $obj_suscripcion = new Suscripcion();

            if (($privilegios_usuario != 1) && ($privilegios_usuario != $_SESSION['tipo_usuario']))
            {
               $this->suspenderUsuario($id_usuario);

               if ($privilegios_usuario == 2)
                  $this->suspenderUsuarioDeAdministrador($id_usuario);
               if ($obj_suscripcion->get_tipo($id_usuario) >= 2)
               {
                  $obj_pago = new Pago();
                  $obj_pago->guardar($id_usuario);
               }
            }
         }

         $aux = 1;
      }

      if (!empty($_POST['seleccion2']))
      {
         foreach ($_POST['seleccion2'] as $id_usuario)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario);
            $obj_suscripcion = new Suscripcion();

            if (($privilegios_usuario != 1) && ($privilegios_usuario != $_SESSION['tipo_usuario']))
            {
               $this->suspenderUsuario($id_usuario);

               if ($privilegios_usuario == 2)
                  $this->suspenderUsuarioDeAdministrador($id_usuario);
               if ($obj_suscripcion->get_tipo($id_usuario) >= 2)
               {
                  $obj_pago = new Pago();
                  $obj_pago->guardar($id_usuario);
               }
            }
         }

         $aux = 1;
      }

      $bd->cerrar();

      return $aux;
   }

   /**
    * [Modifica el valor de status2 en 1 y online en 0 de cualquier usuario
    *  manejado por el administrador que se le pase como parámetro.]
    */
   private function suspenderUsuarioDeAdministrador($id_administrador)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE registrados SET status2 = 1, online = 0
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   private function eliminarUsuarioAdministrador($id_administrador)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'DELETE registrados, conteo_administradores
         FROM conteo_administradores
         LEFT JOIN registrados ON conteo_administradores.id_administrador = registrados.id_administrador
         WHERE conteo_administradores.id_administrador = "'.$id_administrador.'"';

      if ($bd->ejecutar($query))
      {
         $aux = 1;

         $query = 'DELETE registrados, entradas, preguntas, suscripcion, entradas_por_leer
            FROM registrados
            LEFT JOIN entradas ON registrados.id_usuario = entradas.usuario_id
            LEFT JOIN preguntas ON registrados.id_usuario = preguntas.id_usuario
            LEFT JOIN suscripcion ON registrados.id_usuario = suscripcion.id_usuario
            LEFT JOIN entradas_por_leer ON entradas_por_leer.id_usuario = registrados.id_usuario
            WHERE registrados.id_usuario = "'.$id_administrador.'"';

         $bd->ejecutar($query);
      }

      $bd->cerrar();

      return $aux;
   }

   public function modificarUsuariosPermitidos($id_administrador)
   {
      $bd = new Conexion();
      $aux = 0;

      $usuarios_permitidos = ($_POST['array_permitidos']) ? implode(',', $_POST['array_permitidos']) : '';

      $query = 'UPDATE conteo_administradores
         SET usuarios_permitidos = "'.$usuarios_permitidos.'"
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function eliminarUsuarioDesdeModal($id_administrador)
   {
      $aux = 0;

      if (!empty($_POST['array_seleccion_modal']))
      {
         foreach ($_POST['array_seleccion_modal'] as $id_usuario)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario);

            $this->eliminarUsuarioEstandar($id_usuario);
            $this->decrementarConteoAdministrador($id_administrador, 1, $privilegios_usuario);
         }

         $aux = 1;
      }

      return $aux;
   }

   public function desvincularUsuarioDesdeModal($id_administrador)
   {
      $aux = 0;

      if (!empty($_POST['array_seleccion_modal']))
      {
         $obj_suscripcion = new Suscripcion();

         foreach ($_POST['array_seleccion_modal'] as $id_usuario)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario);

            $this->desvincularUsuario($id_usuario);
            $obj_suscripcion->actualizarStatus(0, $id_usuario);
            $this->decrementarConteoAdministrador($id_administrador, 1, $privilegios_usuario);
         }

         $aux = 1;
      }

      return $aux;
   }

   /**
    * [Ejecuta la consulta necesaria para desvincular un usuario estandar
    *  de su usuario administrador responsable.]
    */
   private function desvincularUsuario($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE registrados SET id_administrador = 0, status2 = 0
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function obtenerIdAdministradorDesdeConteoAdministrador($id_administrador)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT id_administrador FROM conteo_administradores
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $aux = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   /**
    * [Consulta el nombre de un administrador para cargarlo en el
    *  campo responsable al momento de modificar cualquier usuario estandar.]
    */
   public function obtenerNombreAdministrador($id_administrador)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT nombre FROM registrados
         WHERE id_usuario = "'.$id_administrador.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['nombre'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   private function guardarConteoAdministrador($id_administrador, $usuarios_permitidos,
      $cantidad_usuarios_permitidos)
   {
      $bd = new Conexion();
      $aux = 0;

      $max_nacionales = (in_array('3', $usuarios_permitidos)) ? $cantidad_usuarios_permitidos[0] : 0;
      $max_americanas = (in_array('4', $usuarios_permitidos)) ? $cantidad_usuarios_permitidos[1] : 0;
      $max_an = (in_array('5', $usuarios_permitidos)) ? $cantidad_usuarios_permitidos[2] : 0;
      $usuarios_permitidos = ($usuarios_permitidos) ? implode(',', $usuarios_permitidos) : '';

      $query = 'INSERT INTO conteo_administradores (id_administrador, usuarios_permitidos,
         max_nacionales, max_americanas, max_an)
         VALUES ("'.$id_administrador.'", "'.$usuarios_permitidos.'", "'.$max_nacionales.'",
         "'.$max_americanas.'", "'.$max_an.'")';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function modificarConteoAdministrador($id_administrador, $usuarios_permitidos,
      $cantidad_usuarios_permitidos)
   {
      $bd = new Conexion();
      $aux = 0;

      $max_nacionales = (in_array('3', $usuarios_permitidos, true)) ? $cantidad_usuarios_permitidos[0] : 0;
      $max_americanas = (in_array('4', $usuarios_permitidos, true)) ? $cantidad_usuarios_permitidos[1] : 0;
      $max_an = (in_array('5', $usuarios_permitidos, true)) ? $cantidad_usuarios_permitidos[2] : 0;
      $usuarios_permitidos = ($usuarios_permitidos) ? implode(',', $usuarios_permitidos) : '';

      $query = 'UPDATE conteo_administradores
         SET usuarios_permitidos = "'.$usuarios_permitidos.'", max_nacionales = "'.$max_nacionales.'",
            max_americanas = "'.$max_americanas.'", max_an = "'.$max_an.'"
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   private function eliminarConteoAdministrador($id_administrador)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'DELETE FROM conteo_administradores
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   private function resetAdministrador($id_administrador)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE registrados
         JOIN suscripcion ON registrados.id_usuario = suscripcion.id_usuario
         SET registrados.id_administrador = 0, registrados.status2 = 0, suscripcion.status = 0
         WHERE registrados.id_usuario = "'.$id_administrador.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   /**
    * [Método que asigna un responsable al modificar un usuario estandar.]
    */
   private function asignarResponsable($id_usuario_estandar, $privilegios_nuevo, $privilegios_actual,
      $id_responsable, $id_responsable_actual)
   {
      $bd = new Conexion();
      $aux = 0;

      if ($id_responsable_actual != 0) # Si tiene ya un responsable asignado
      {
         if ($privilegios_nuevo != $privilegios_actual)
         {
            $this->decrementarConteoAdministrador($id_responsable_actual, 1, $privilegios_actual);
            $this->incrementarConteoAdministrador($id_responsable_actual, $privilegios_nuevo);

            $aux = 1;
         }
      }
      else
      {
         $query = 'UPDATE registrados SET id_administrador = "'.$id_responsable.'"
            WHERE id_usuario = "'.$id_usuario_estandar.'"';

         if ($bd->ejecutar($query))
         {
            $aux = 1;

            $this->incrementarConteoAdministrador($id_responsable, $privilegios_nuevo);
         }
      }

      $bd->cerrar();

      return $aux;
   }

   private function enlazarUsuarioSuperadmin($id_super_administrador, $id_usuario_creado)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'INSERT INTO usuarios_superadmin (id_superadmin, id_usuario_creado)
         VALUES ("'.$id_super_administrador.'", "'.$id_usuario_creado.'")';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   private function consultarUsuariosOnline($filtro_privilegios, $paginacion)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

      $query = "SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE registrados.status = 0 AND registrados.online = 1
            ".$filtrar_por_privilegios."
         ORDER BY registrados.privilegios, registrados.nombre ASC
         LIMIT ".$paginacion->getOffset().", ".$paginacion->getFilasPagina()."";

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasUsuariosOnline($filtro_privilegios)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

      $query = 'SELECT id_usuario FROM registrados
         WHERE registrados.status = 0 AND registrados.online = 1
            '.$filtrar_por_privilegios.'';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   private function consultaVerDetallesUsuarioOnline($id_usuario_get, $id_usuario_session)
   {
      $bd = new Conexion();
      $fila = 0;

      if ($id_usuario_session == $id_usuario_get)
      {
         $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
            conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
            suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
            suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
            suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
            suscripcion.fecha AS suscripcion_fecha
            FROM registrados
            LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
            LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
            WHERE registrados.id_usuario = "'.$id_usuario_get.'"';
      }
      else
      {
         $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
            conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
            suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
            suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
            suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
            suscripcion.fecha AS suscripcion_fecha
            FROM registrados
            LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
            LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
            WHERE (registrados.status = 0 AND registrados.online = 1
               AND registrados.id_usuario = "'.$id_usuario_get.'")';
      }

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   private function consultaBusquedaUsuariosOnline($filtro_busqueda)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
         suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status = 0 AND registrados.online = 1
            AND registrados.nombre LIKE "%'.$filtro_busqueda.'%")
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function consultarUsuariosOffline($filtro_privilegios, $paginacion)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

       $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

      $query = "SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE registrados.status != 1 AND registrados.online = 0
            ".$filtrar_por_privilegios."
         ORDER BY registrados.privilegios, registrados.nombre ASC
         LIMIT ".$paginacion->getOffset().", ".$paginacion->getFilasPagina()."";

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasUsuariosOffline($filtro_privilegios)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

      $query = 'SELECT id_usuario FROM registrados
         WHERE status != 1 AND online = 0
            '.$filtrar_por_privilegios.'';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   private function consultaVerDetallesUsuarioOffline($id_usuario_get, $id_usuario_session)
   {
      $bd = new Conexion();
      $fila = 0;

      $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
         suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE registrados.privilegios != 1 AND registrados.id_usuario = "'.$id_usuario_get.'"
            AND registrados.status != 1 AND online = 0';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   private function consultaBusquedaUsuariosOffline($filtro_busqueda)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
         suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status != 1 AND online = 0 AND
            registrados.nombre LIKE "%'.$filtro_busqueda.'%")
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function consultarUsuariosSuspendidos($filtro_privilegios, $paginacion)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

       $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

      $query = "SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE registrados.status = 1
            ".$filtrar_por_privilegios."
         ORDER BY registrados.privilegios, registrados.nombre ASC
         LIMIT ".$paginacion->getOffset().", ".$paginacion->getFilasPagina()."";

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasUsuariosSuspendidos($filtro_privilegios)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

      $query = 'SELECT id_usuario FROM registrados
         WHERE status = 1
            '.$filtrar_por_privilegios.'';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   private function consultaVerDetallesUsuarioSuspendido($id_usuario_get, $id_usuario_session)
   {
      $bd = new Conexion();
      $fila = 0;

      $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
         suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE registrados.privilegios != 1 AND registrados.id_usuario = "'.$id_usuario_get.'"
            AND registrados.status = 1';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   private function consultaBusquedaUsuariosSuspendidos($filtro_busqueda)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
         suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.status = 1 AND registrados.nombre LIKE "%'.$filtro_busqueda.'%")
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function consultarUsuariosTodos($filtro_privilegios, $paginacion)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : 'WHERE registrados.privilegios = '.$filtro_privilegios.' ';

      $query = "SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         ".$filtrar_por_privilegios."
         ORDER BY registrados.privilegios, registrados.nombre ASC
         LIMIT ".$paginacion->getOffset().", ".$paginacion->getFilasPagina()."";

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasUsuariosTodos($filtro_privilegios)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : 'WHERE registrados.privilegios = '.$filtro_privilegios.' ';

      $query = 'SELECT id_usuario FROM registrados
            '.$filtrar_por_privilegios.'';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   private function consultaVerDetallesUsuarioTodos($id_usuario_get, $id_usuario_session)
   {
      $bd = new Conexion();
      $fila = 0;

      if ($id_usuario_session == $id_usuario_get)
      {
         $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
            conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
            suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
            suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
            suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
            suscripcion.fecha AS suscripcion_fecha
            FROM registrados
            LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
            LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
            WHERE registrados.id_usuario = "'.$id_usuario_get.'"';
      }
      else
      {
         $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
            conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
            suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
            suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
            suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
            suscripcion.fecha AS suscripcion_fecha
            FROM registrados
            LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
            LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
            WHERE registrados.privilegios != 1 AND registrados.id_usuario = "'.$id_usuario_get.'"';
      }

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   private function consultaBusquedaUsuariosTodos($filtro_busqueda)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
         suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE registrados.nombre LIKE "%'.$filtro_busqueda.'%"
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function consultarMisUsuarios($filtro_privilegios, $paginacion)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      if ($filtro_privilegios == 2)
      {
         $query = "SELECT registrados.*, conteo_administradores.usuarios_permitidos,
            conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
            (conteo_administradores.max_nacionales+conteo_administradores.max_americanas+conteo_administradores.max_an) AS max,
            (conteo_administradores.conteo_nacionales+conteo_administradores.conteo_americanas+conteo_administradores.conteo_an) AS conteo,
            suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
            suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
            suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
            FROM registrados
            JOIN usuarios_superadmin ON registrados.id_usuario = usuarios_superadmin.id_usuario_creado
            LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
            LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
            WHERE usuarios_superadmin.id_superadmin = ".$_SESSION['id_usuario']."
               AND registrados.privilegios = 2
            ORDER BY registrados.privilegios, registrados.nombre ASC
            LIMIT ".$paginacion->getOffset().", ".$paginacion->getFilasPagina()."";
      }
      else
      {
         $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
            : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

         $query = "SELECT registrados.*, conteo_administradores.usuarios_permitidos,
            conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
            suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
            suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
            suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
            FROM registrados
            JOIN usuarios_superadmin ON registrados.id_usuario = usuarios_superadmin.id_usuario_creado
            LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
            LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
            WHERE usuarios_superadmin.id_superadmin = ".$_SESSION['id_usuario']."
               ".$filtrar_por_privilegios."
            ORDER BY registrados.privilegios, registrados.nombre ASC
            LIMIT ".$paginacion->getOffset().", ".$paginacion->getFilasPagina()."";
      }

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   public function consultaBusquedaMisUsuarios($filtro_busqueda)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
         FROM registrados
         JOIN usuarios_superadmin ON registrados.id_usuario = usuarios_superadmin.id_usuario_creado
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (usuarios_superadmin.id_superadmin = "'.$_SESSION['id_usuario'].'"
            AND registrados.nombre LIKE "%'.$filtro_busqueda.'%")
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   public function numFilasMisUsuarios($filtro_privilegios)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

      $query = 'SELECT usuarios_superadmin.id_usuario_creado
         FROM usuarios_superadmin
         JOIN registrados ON registrados.id_usuario = usuarios_superadmin.id_usuario_creado
         WHERE usuarios_superadmin.id_superadmin = "'.$_SESSION['id_usuario'].'"
            '.$filtrar_por_privilegios.'';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   public function consultarVerDetallesMisUsuarios($id_usuario)
   {
      $bd = new Conexion();

      $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
         suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         JOIN usuarios_superadmin ON registrados.id_usuario = usuarios_superadmin.id_usuario_creado
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (usuarios_superadmin.id_usuario_creado = "'.$id_usuario.'" AND
            usuarios_superadmin.id_superadmin = "'.$_SESSION['id_usuario'].'")';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   /**
    * [Consulta todos los usuarios que son gestionados por el
    *  administrador pasado como parámetro.]
    */
   public function consultarUsuariosAdministrados($id_administrador, $filtro_privilegios, $paginacion)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

      $query = "SELECT registrados.*, suscripcion.tiempo AS suscripcion_tiempo,
         suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
         suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
         suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE registrados.id_administrador = ".$id_administrador."
            ".$filtrar_por_privilegios."
         ORDER BY registrados.privilegios, registrados.nombre ASC
         LIMIT ".$paginacion->getOffset().", ".$paginacion->getFilasPagina()."";

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   public function buscarUsuariosAministrados($id_administrador, $filtro_busqueda)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.*,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
         FROM registrados
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.id_administrador = "'.$id_administrador.'"
            AND registrados.nombre LIKE "%'.$filtro_busqueda.'%")
         ORDER BY registrados.privilegios, registrados.nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   public function consultaVerDetallesUsuarioAdministrado($id_usuario, $administrador)
   {
      $bd = new Conexion();

      $query = 'SELECT registrados.*, conteo_administradores.usuarios_permitidos,
         conteo_administradores.max_nacionales, conteo_administradores.max_americanas, conteo_administradores.max_an,
         suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2,
         suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
         suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2,
         suscripcion.fecha AS suscripcion_fecha
         FROM registrados
         LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
         WHERE (registrados.id_usuario = "'.$id_usuario.'" AND
            registrados.id_administrador = "'.$administrador.'")';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $fila;
   }

   public function numFilasUsuariosAdministrados($id_administrador,
      $filtro_privilegios)
   {
      $bd = new Conexion();
      $num_filas = 0;

      $filtrar_por_privilegios = ($filtro_privilegios == 0) ? ''
         : ' AND registrados.privilegios = '.$filtro_privilegios.' ';

      $query = 'SELECT id_usuario FROM registrados
         WHERE registrados.id_administrador = "'.$id_administrador.'"
            '.$filtrar_por_privilegios.'';

      if ($estc = $bd->ejecutar($query))
      {
         $num_filas = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $num_filas;
   }

   public function consultaUsuariosAdministradores()
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.id_usuario, registrados.nombre, conteo_administradores.*
         FROM registrados
         JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
         WHERE privilegios = 2
         ORDER BY nombre ASC';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   /**
    * [No se puede filtrar por super_administrador.]
    */
   public function procesarFiltroPrivSu($privilegios)
   {
      if (!$privilegios)
         $privilegios = 0;
      else if ($privilegios < 2 || $privilegios > 5)
         $privilegios = 0;

      return $privilegios;
   }

   /**
    * [Sí se puede filtrar por super_administrador.]
    */
   public function procesarFiltroPriv($privilegios)
   {
      if (!$privilegios)
         $privilegios = 0;
      else if ($privilegios < 1 || $privilegios > 5)
         $privilegios = 0;

      return $privilegios;
   }

   public function __vistaUsuariosHtml($pagina, $id_usuario_get, $busqueda_get,
      $administrador_get, $pag_num_get, $filtro_privilegios_get)
   {
      if ($id_usuario_get)
         $salida_html = $this->__verDetallesUsuariosHtml($pagina, $id_usuario_get, 0);
      else if ($busqueda_get)
         $salida_html = $this->__usuariosEncontradosHtml($pagina, $busqueda_get, $_SESSION['id_usuario']);
      else
      {
         switch ($pagina)
         {
            case 'act':
               $paginacion = new Paginacion($this->numFilasUsuariosOnline($filtro_privilegios_get), $pag_num_get);
               $filas = $this->consultarUsuariosOnline($filtro_privilegios_get, $paginacion);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), $filtro_privilegios_get);
               break;
            case 'desc':
               $paginacion = new Paginacion($this->numFilasUsuariosOffline($filtro_privilegios_get), $pag_num_get);
               $filas = $this->consultarUsuariosOffline($filtro_privilegios_get, $paginacion);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), $filtro_privilegios_get);
               break;
            case 'susp':
               $paginacion = new Paginacion($this->numFilasUsuariosSuspendidos($filtro_privilegios_get), $pag_num_get);
               $filas = $this->consultarUsuariosSuspendidos($filtro_privilegios_get, $paginacion);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), $filtro_privilegios_get);
               break;
            case 'todos':
               $paginacion = new Paginacion($this->numFilasUsuariosTodos($filtro_privilegios_get), $pag_num_get);
               $filas = $this->consultarUsuariosTodos($filtro_privilegios_get, $paginacion);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), $filtro_privilegios_get);
               break;
            default:
               $paginacion = new Paginacion($this->numFilasUsuariosTodos($filtro_privilegios_get), $pag_num_get);
               $filas = $this->consultarUsuariosTodos($filtro_privilegios_get, $paginacion);
               $subtitulo = $this->__nombreSubtituloHtml($pagina, $paginacion->getTotalFilas(), $filtro_privilegios_get);
               break;
         }

         $salida_html = $this->__barraBotonesHtml($pagina);

         $salida_html .= $subtitulo;

         $salida_html .= '
            <div class="table-responsive">
               <table class="table table-usuarios">
                  <thead>
                     <tr>
                        <th>Usuario</th>
                        <th>Dirección IP</th>';
                        if ($filtro_privilegios_get == 0)
                           $salida_html .= '<th>Privilegios</th>';
                        else
                        {
                           if ($filtro_privilegios_get != 1)
                              $salida_html .= '<th>Responsable</th>';
                        }
                        $salida_html .= '<th>Status</th>
                        <th>Acciones</th>
                     </tr>
                  </thead>
                  <tbody>';

            if ($paginacion->getTotalFilas() > 0)
            {
               foreach ($filas as $usuario)
               {
                  $salida_html .= '
                     <tr>
                        <td>'.$usuario['nombre'].
                           $this->statusUsuarioIcono($usuario['online'], $usuario['status'], $usuario['status2'],
                              $usuario['suscripcion_status'], $usuario['suscripcion_status2']).'
                        </td>
                        <td>'.$usuario['ip'].'</td>';
                        if ($filtro_privilegios_get == 0)
                           $salida_html .= '<td>'.$this->nombrePrivilegios($usuario['privilegios']).'</td>';
                        else
                        {
                           if ($filtro_privilegios_get != 1)
                           {
                              $salida_html .= '<td>'.$this->__columnaResponsable(
                                 $usuario['id_usuario'], $usuario['privilegios'], $usuario['id_administrador']).'</td>';
                           }
                        }
                        $salida_html .= '<td>'.$this->nombreStatus($usuario['status']).'</td>
                        <td>';
                        if (($usuario['id_usuario'] == $_SESSION['id_usuario']) || $usuario['privilegios'] != 1)
                        {
                           $salida_html .= '<div class="acciones">
                              <a class="e1" href="?id_usuario='.$usuario['id_usuario'].'" data-accion="ver_detalles"
                                 data-toggle="ver_detalles"><i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
                              </a>
                              <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="restablecer_preguntas"
                                 data-toggle="confirmar"><i class="glyphicon glyphicon-repeat"
                                 title="Restablecer pregunta de seguridad"></i>
                              </a>
                              <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="eliminar_usuario"
                                 data-toggle="confirmar"><i class="glyphicon glyphicon-trash" title="Eliminar"></i>
                              </a>
                              <a class="e1" href="'.$usuario['id_usuario'].'"
                                 data-accion="modificar" data-toggle="actualizar_usuario"
                                 dbd_clave="'.$usuario['clave'].'"
                                 dbd_nombre="'.$usuario['nombre'].'"
                                 dbd_priv="'.$usuario['privilegios'].'"
                                 dbd_max_nacionales="'.$usuario['max_nacionales'].'"
                                 dbd_max_americanas="'.$usuario['max_americanas'].'"
                                 dbd_max_an="'.$usuario['max_an'].'"
                                 dbd_usuarios_permitidos="'.$usuario['usuarios_permitidos'].'"
                                 dbd_susc_tipo="'.$usuario['suscripcion_tipo'].'"
                                 dbd_susc_tiempo2="'.$usuario['suscripcion_tiempo2'].'"
                                 dbd_susc_dias="'.$usuario['suscripcion_dias'].'"
                                 dbd_id_administrador="'.$usuario['id_administrador'].'" >
                                 <i class="glyphicon glyphicon-edit" title="Modificar"></i>
                              </a>
                           </div>
                           '.$this->__htmlCheck($usuario['status'], $usuario['id_usuario']).'';
                        }
                        $salida_html .= '</td>';
                     $salida_html .= '</tr>';
               } # fin foreach
            }
            else
            {
               $salida_html .= '<tr><td class="vacio" colspan="8">
                  No hay resultados.</td></tr>';
            }

                  $salida_html .= '</tbody>
               </table>
            </div>';

            $salida_html .= $paginacion->__html($pagina, $filtro_privilegios_get);
      }

      return $salida_html;
   }

   public function __vistaMisUsuariosHtml($filtro_privilegios, $pag_num,
      $busqueda, $administrador, $id_usuario_get)
   {
      $salida_html = '';
      $tabla_col = 6;

      if ($administrador)
      {
         $salida_html = $this->__usuariosAdministradosHtml('mis_usuarios', $administrador,
            $busqueda, $pag_num, $filtro_privilegios, $id_usuario_get);
      }
      else if ($id_usuario_get)
         $salida_html = $this->__verDetallesUsuariosHtml('mis_usuarios', $id_usuario_get, $administrador);
      else if ($busqueda)
         $salida_html = $this->__usuariosEncontradosHtml('mis_usuarios', $busqueda, $_SESSION['id_usuario']);
      else
      {
         $salida_html .= $this->__barraBotonesHtml('mis_usuarios');

         $paginacion = new Paginacion($this->numFilasMisUsuarios($filtro_privilegios), $pag_num);

         $salida_html .= $this->__nombreSubtituloHtml('mis_usuarios', $paginacion->getTotalFilas(),
            $filtro_privilegios);

         $salida_html .= '
            <div class="table-responsive">
               <table class="table table-usuarios">
                  <thead>
                     <tr>
                        <th>Usuario</th>
                        <th>Contraseña</th>
                        <th>Dirección IP</th>';
                        if ($filtro_privilegios == 0)
                           $salida_html .= '<th>Privilegios</th>';
                        else if ($filtro_privilegios == 2)
                        {
                           $salida_html .= '
                              <th>Clientes</th>
                              <th>Tope</th>';
                        }
                        else if ($filtro_privilegios > 2)
                           $salida_html .= '<th>Responsable</th>';
                        $salida_html .= '<th>Status</th>
                        <th>Acciones</th>
                     </tr>
                  </thead>
                  <tbody>';

                  if ($paginacion->getTotalFilas() > 0)
                  {
                     $filas = $this->consultarMisUsuarios($filtro_privilegios, $paginacion);

                        foreach ($filas as $usuario)
                        {
                           $salida_html .= '<tr>
                              <td>'.$usuario['nombre'].
                                 $this->statusUsuarioIcono($usuario['online'], $usuario['status'], $usuario['status2'],
                                    $usuario['suscripcion_status'], $usuario['suscripcion_status2']).'
                              </td>
                              <td>'.$usuario['clave'].'</td>
                              <td>'.$usuario['ip'].'</td>';
                              if ($filtro_privilegios == 0)
                                 $salida_html .= '<td>'.$this->nombrePrivilegios($usuario['privilegios']).'</td>';
                              else if ($filtro_privilegios == 2)
                              {
                                 $salida_html .= '
                                    <td>'.$usuario['conteo'].'</td>
                                    <td>'.$usuario['max'].'</td>';
                              }
                              else if ($filtro_privilegios > 2)
                                 $salida_html .= '<td>'.$this->__columnaResponsable(0, 0, $usuario['id_administrador']).'</td>';
                              $salida_html .= '<td>'.$this->nombreStatus($usuario['status']).'</td>
                              <td>
                                 <div class="acciones">
                                    <a class="e1" href="?id_usuario='.$usuario['id_usuario'].'" data-accion="ver_detalles"
                                       data-toggle="ver_detalles"><i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
                                    </a>';
                                    if ($usuario['privilegios'] == 2)
                                    {
                                       $salida_html .= '
                                          <a class="e1" href="?administrador='.$usuario['id_usuario'].'">
                                          <i class="glyphicon glyphicon-user" title="Ver usuarios administrados"></i></a> ';
                                    }
                                    $salida_html .= '<a class="e1" href="'.$usuario['id_usuario'].'" data-accion="restablecer_preguntas" data-toggle="confirmar"><i class="glyphicon glyphicon-repeat"
                                       title="Restablecer pregunta de seguridad"></i></a>
                                    <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="eliminar_usuario"
                                       data-toggle="confirmar"><i class="glyphicon glyphicon-trash" title="Eliminar"></i>
                                    </a>
                                    <a class="e1" href="'.$usuario['id_usuario'].'"
                                       data-accion="modificar" data-toggle="actualizar_usuario"
                                       dbd_clave="'.$usuario['clave'].'"
                                       dbd_nombre="'.$usuario['nombre'].'"
                                       dbd_priv="'.$usuario['privilegios'].'"
                                       dbd_max_nacionales="'.$usuario['max_nacionales'].'"
                                       dbd_max_americanas="'.$usuario['max_americanas'].'"
                                       dbd_max_an="'.$usuario['max_an'].'"
                                       dbd_usuarios_permitidos="'.$usuario['usuarios_permitidos'].'"
                                       dbd_susc_tipo="'.$usuario['suscripcion_tipo'].'"
                                       dbd_susc_tiempo2="'.$usuario['suscripcion_tiempo2'].'"
                                       dbd_susc_dias="'.$usuario['suscripcion_dias'].'"
                                       dbd_id_administrador="'.$usuario['id_administrador'].'" >
                                       <i class="glyphicon glyphicon-edit" title="Modificar"></i>
                                    </a>
                                 </div>
                                 '.$this->__htmlCheck($usuario['status'], $usuario['id_usuario']).'
                              </td>';
                           $salida_html .= '</tr>';
                        } # fin foreach

                  }
                  else
                  {
                     $salida_html .= '<tr><td class="vacio" colspan="8">
                        No hay resultados.</td></tr>';
                  }

                  $salida_html .= '</tbody>
               </table>
            </div>';

            $salida_html .= $paginacion->__html('mis_usuarios', $filtro_privilegios);
      }

      return $salida_html;
   }

   /**
    * [Muestra los resultados de una búsqueda.]
    */
   private function __usuariosEncontradosHtml($pagina, $filtro_busqueda, $id_usuario_session)
   {
      switch ($pagina)
      {
         case 'act':
            $filas = $this->consultaBusquedaUsuariosOnline($filtro_busqueda);
            break;
         case 'desc':
            $filas = $this->consultaBusquedaUsuariosOffline($filtro_busqueda);
            break;
         case 'susp':
            $filas = $this->consultaBusquedaUsuariosSuspendidos($filtro_busqueda);
            break;
         case 'todos':
            $filas = $this->consultaBusquedaUsuariosTodos($filtro_busqueda);
            break;
         case 'mis_usuarios':
            $filas = $this->consultaBusquedaMisUsuarios($filtro_busqueda);
            break;
         default:
            $filas = null;
            break;
      }

      $salida_html = $this->__barraBotonesBusquedaHtml($pagina, $filtro_busqueda);

      $salida_html .= '
         <div class="subtitulo">
            <p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos"
               data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i>
               Resultados de la búsqueda </a><span class="badge" style="background-color:#5bc0de">
               '.count($filas).'</span>
            </p>
         </div>';

      $salida_html .= '
         <div class="table-responsive">
            <table class="table table-usuarios">
               <thead>
                  <tr>
                     <th>Usuario</th>';
                     if ($pagina == 'mis_usuarios')
                        $salida_html .= '<th>Contraseña</th>';
                     $salida_html .= '<th>Dirección IP</th>
                     <th>Privilegios</th>
                     <th>Status</th>
                     <th>Acciones</th>
                  </tr>
               </thead>
               <tbody>';

               if ($filas)
               {
                  foreach ($filas as $usuario)
                  {
                     $salida_html .= '<tr>
                        <td>'.$usuario['nombre'].
                           $this->statusUsuarioIcono($usuario['online'], $usuario['status'], $usuario['status2'],
                              $usuario['suscripcion_status'], $usuario['suscripcion_status2']).'
                        </td>';
                        if ($pagina == 'mis_usuarios')
                           $salida_html .= '<td>'.$usuario['clave'].'</td>';
                        $salida_html .= '<td>'.$usuario['ip'].'</td>
                        <td>'.$this->nombrePrivilegios($usuario['privilegios']).'</td>
                        <td>'.$this->nombreStatus($usuario['status']).'</td>
                        <td>';
                        if (($usuario['id_usuario'] == $_SESSION['id_usuario']) || $usuario['privilegios'] != 1)
                        {
                           $salida_html .= '
                              <div class="acciones">
                                 <a class="e1" href="?id_usuario='.$usuario['id_usuario'].'" data-accion="ver_detalles"
                                    data-toggle="ver_detalles"><i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
                                 </a>';
                              if ($usuario['privilegios'] == 2 && $pagina == 'mis_usuarios')
                              {
                                 $salida_html .= '
                                    <a class="e1" href="?administrador='.$usuario['id_usuario'].'">
                                       <i class="glyphicon glyphicon-user" title="Ver usuarios administrados"></i>
                                    </a> ';
                              }
                              $salida_html .='
                                 <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="restablecer_preguntas"
                                    data-toggle="confirmar"><i class="glyphicon glyphicon-repeat"
                                    title="Restablecer pregunta de seguridad"></i>
                                 </a>
                                 <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="eliminar_usuario"
                                    data-toggle="confirmar"><i class="glyphicon glyphicon-trash" title="Eliminar"></i>
                                 </a>
                                 <a class="e1" href="'.$usuario['id_usuario'].'"
                                    data-accion="modificar" data-toggle="actualizar_usuario"
                                    dbd_clave="'.$usuario['clave'].'"
                                    dbd_nombre="'.$usuario['nombre'].'"
                                    dbd_priv="'.$usuario['privilegios'].'"
                                    dbd_max_nacionales="'.$usuario['max_nacionales'].'"
                                    dbd_max_americanas="'.$usuario['max_americanas'].'"
                                    dbd_max_an="'.$usuario['max_an'].'"
                                    dbd_usuarios_permitidos="'.$usuario['usuarios_permitidos'].'"
                                    dbd_susc_tipo="'.$usuario['suscripcion_tipo'].'"
                                    dbd_susc_tiempo2="'.$usuario['suscripcion_tiempo2'].'"
                                    dbd_susc_dias="'.$usuario['suscripcion_dias'].'"
                                    dbd_id_administrador="'.$usuario['id_administrador'].'" >
                                    <i class="glyphicon glyphicon-edit" title="Modificar"></i>
                                 </a>
                              </div>
                              '.$this->__htmlCheck($usuario['status'], $usuario['id_usuario']).'';
                        }
                        $salida_html .= '</td>';
                     $salida_html .= '</tr>';
                  } # fin foreach
               }
               else
               {
                  $salida_html .= '<tr><td class="vacio" colspan="6">
                     No hay resultados de usuarios para <strong>'.$filtro_busqueda.'</strong>.</td></tr>';
               }
               $salida_html .= '</tbody>
            </table>
         </div>';

      return $salida_html;
   }

   private function __verDetallesUsuariosHtml($pagina, $id_usuario_get, $administrador)
   {
      switch ($pagina)
      {
         case 'act':
            $fila = $this->consultaVerDetallesUsuarioOnline($id_usuario_get, $_SESSION['id_usuario']);
            break;
         case 'desc':
            $fila = $this->consultaVerDetallesUsuarioOffline($id_usuario_get, $_SESSION['id_usuario']);
            break;
         case 'susp':
            $fila = $this->consultaVerDetallesUsuarioSuspendido($id_usuario_get, $_SESSION['id_usuario']);
            break;
         case 'todos':
            $fila = $this->consultaVerDetallesUsuarioTodos($id_usuario_get, $_SESSION['id_usuario']);
            break;
         case 'mis_usuarios':
            if ($administrador)
               $fila = $this->consultaVerDetallesUsuarioAdministrado($id_usuario_get, $administrador);
            else
               $fila = $this->consultarVerDetallesMisUsuarios($id_usuario_get);
            break;
         default:
            $fila = null;
            break;
      }

      $salida_html = $this->__barraBotonesVerDetallesHtml($pagina, $id_usuario_get, $fila);

      if ($fila) # Verifico que se haya encontrado algún registro.
      {
         $obj_suscripcion = new Suscripcion();
         $obj_notificacion = new Notificacion();

         $salida_html .= '
            <div class="container">
               <div class="col-xs-12 col-sm-5 col-md-5 col-lg-5">';
                  $salida_html .= $this->__panelVerDetallesHtml($fila, $pagina, $_SESSION['tipo_usuario']);
                  if ($fila['privilegios'] != 1)
                     $salida_html .= $obj_suscripcion->__panelVerDetallesHtml($fila);
               $salida_html .= '</div>'; # <!-- /.col-* -->
               $salida_html .= $obj_notificacion->__panelVerDetallesHtml($id_usuario_get);
            $salida_html .= '</div>'; # <!-- /.container -->
      }
      else
         $salida_html .= '<div class="col-lg-12 subtitulo2">Usuario no encontrado.</div>';

      return $salida_html;
   }

   /**
    * [Ventana principal donde se puede realizar cualquier acción sobre
    *  los usuarios gestionados por algún administrador.]
    */
   public function __usuariosAdministradosHtml($pagina, $administrador, $busqueda,
      $pag_num, $filtro_privilegios, $id_usuario_get)
   {
      $salida_html = '';

      $filtro_privilegios = ($filtro_privilegios >= 3 && $filtro_privilegios <= 5)
         ? $filtro_privilegios : 0;

      if ($id_usuario_get)
         $salida_html = $this->__verDetallesUsuariosHtml($pagina, $id_usuario_get, $administrador);
      else if ($busqueda)
         $salida_html = $this->__usuariosAdministradosEncontradosHtml($pagina, $administrador, $busqueda);
      else
      {
         $salida_html = $this->__barraBotonesUsuariosAdministradosHtml($pagina, $administrador);

         $paginacion = new Paginacion($this->numFilasUsuariosAdministrados(
            $administrador, $filtro_privilegios), $pag_num);

         $salida_html .= '
            <div class="subtitulo">
               <p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos"
                  data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i>';
                  $subtitulo = ($filtro_privilegios != 0)
                     ? ' Usuarios administrados por '.$this->obtenerNombreUsuario($administrador).':
                        '.$this->nombrePrivilegiosPlural($filtro_privilegios)
                     : ' Usuarios administrados por '.$this->obtenerNombreUsuario($administrador);
                  $salida_html .= $subtitulo.'</a>'.
                     ' <span class="badge" style="background-color:#5bc0de">'.$paginacion->getTotalFilas().'</span>
               </p>
            </div>';

         $salida_html .= '
            <div class="table-responsive">
               <table class="table table-usuarios">
                  <thead>
                     <tr>
                        <th>Usuario</th>
                        <th>Contraseña</th>
                        <th>Dirección IP</th>';
                        if ($filtro_privilegios == 0)
                           $salida_html .= '<th>Privilegios</th>';
                        $salida_html .= '<th>Status</th>
                        <th>Acciones</th>
                     </tr>
                  </thead>
                  <tbody>';

         if ($paginacion->getTotalFilas() > 0)
         {
            if ($filas = $this->consultarUsuariosAdministrados($administrador, $filtro_privilegios, $paginacion))
            {
               foreach ($filas as $usuario)
               {
                  $salida_html .= '<tr>
                     <td>'.$usuario['nombre'].
                        $this->statusUsuarioIcono($usuario['online'], $usuario['status'], $usuario['status2'],
                           $usuario['suscripcion_status'], $usuario['suscripcion_status2']).'
                     </td>
                     <td>'.$usuario['clave'].'</td>
                     <td>'.$usuario['ip'].'</td>';
                     if ($filtro_privilegios == 0)
                        $salida_html .= '<td>'.$this->nombrePrivilegios($usuario['privilegios']).'</td>';
                     $salida_html .= '<td>'.$this->nombreStatus($usuario['status']).'</td>
                     <td>
                        <div class="acciones">
                           <a class="e1" href="?administrador='.$administrador.'&id_usuario='.$usuario['id_usuario'].'"
                              data-accion="ver_detalles" data-toggle="ver_detalles"><i class="glyphicon glyphicon-list-alt"
                              title="Ver detalles"></i>
                           </a>
                           <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="restablecer_preguntas"
                              data-toggle="confirmar"><i class="glyphicon glyphicon-repeat"
                              title="Restablecer pregunta de seguridad"></i>
                           </a>
                           <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="eliminar_usuario"
                              data-toggle="confirmar"><i class="glyphicon glyphicon-trash" title="Eliminar"></i>
                           </a>
                           <a class="e1" href="'.$usuario['id_usuario'].'"
                              data-accion="modificar" data-toggle="actualizar_usuario"
                              dbd_clave="'.$usuario['clave'].'"
                              dbd_nombre="'.$usuario['nombre'].'"
                              dbd_priv="'.$usuario['privilegios'].'"
                              dbd_susc_tipo="'.$usuario['suscripcion_tipo'].'"
                              dbd_susc_tiempo2="'.$usuario['suscripcion_tiempo2'].'"
                              dbd_susc_dias="'.$usuario['suscripcion_dias'].'"
                              dbd_id_administrador="'.$usuario['id_administrador'].'" >
                              <i class="glyphicon glyphicon-edit" title="Modificar"></i>
                           </a>
                        </div>
                        '.$this->__htmlCheck($usuario['status'], $usuario['id_usuario']).'
                     </td>';
                  $salida_html .= '</tr>';
               } # fin foreach
            }
         }
         else
         {
            $salida_html .= '<tr><td class="vacio" colspan="6">
               No hay resultados.</td></tr>';
         }

         $salida_html .= '</tbody>
               </table>
            </div>';

         $salida_html .= $paginacion->__htmlUsuariosAdministrados('mis_usuarios', $administrador,
            $filtro_privilegios);
      }

      return $salida_html;
   }

   /**
    * [Ventana donde se muestra la búsqueda de los
    *  los usuarios gestionados por algún administrador.]
    */
   public function __usuariosAdministradosEncontradosHtml($pagina, $administrador, $filtro_busqueda)
   {
      $salida_html = $this->__barraBotonesBusquedaUsuariosAdministradosHtml($pagina,
         $administrador, $filtro_busqueda);

      $filas = $this->buscarUsuariosAministrados($administrador, $filtro_busqueda);

      $salida_html .= '
         <div class="subtitulo">
            <p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos"
               data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i>
               Usuarios administrados por '.$this->obtenerNombreUsuario($administrador).':
               resultados de la búsqueda </a><span class="badge" style="background-color:#5bc0de">
               '.count($filas).'</span>
            </p>
         </div>';

      $salida_html .= '
         <div class="table-responsive">
            <table class="table table-usuarios">
               <thead>
                  <tr>
                     <th>Usuario</th>
                     <th>Contraseña</th>
                     <th>Dirección IP</th>
                     <th>Privilegios</th>
                     <th>Status</th>
                     <th>Acciones</th>
                  </tr>
               </thead>
               <tbody>';

               if ($filas)
               {
                  foreach ($filas as $usuario)
                  {
                     $salida_html .= '<tr>
                        <td>'.$usuario['nombre'].
                           $this->statusUsuarioIcono($usuario['online'], $usuario['status'], $usuario['status2'],
                              $usuario['suscripcion_status'], $usuario['suscripcion_status2']).'
                        </td>
                        <td>'.$usuario['clave'].'</td>
                        <td>'.$usuario['ip'].'</td>
                        <td>'.$this->nombrePrivilegios($usuario['privilegios']).'</td>
                        <td>'.$this->nombreStatus($usuario['status']).'</td>
                        <td>
                           <div class="acciones">
                              <a class="e1" href="?administrador='.$administrador.'&id_usuario='.$usuario['id_usuario'].'"
                                 data-accion="ver_detalles" data-toggle="ver_detalles"><i class="glyphicon glyphicon-list-alt"
                                 title="Ver detalles"></i>
                              </a>
                              <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="restablecer_preguntas" data-toggle="confirmar">
                                 <i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
                              </a>
                              <a class="e1" href="'.$usuario['id_usuario'].'" data-accion="eliminar_usuario"
                                 data-toggle="confirmar"><i class="glyphicon glyphicon-trash" title="Eliminar"></i>
                              </a>
                              <a class="e1" href="'.$usuario['id_usuario'].'"
                                 data-accion="modificar" data-toggle="actualizar_usuario"
                                 dbd_clave="'.$usuario['clave'].'"
                                 dbd_nombre="'.$usuario['nombre'].'"
                                 dbd_priv="'.$usuario['privilegios'].'"
                                 dbd_susc_tipo="'.$usuario['suscripcion_tipo'].'"
                                 dbd_susc_tiempo2="'.$usuario['suscripcion_tiempo2'].'"
                                 dbd_susc_dias="'.$usuario['suscripcion_dias'].'"
                                 dbd_id_administrador="'.$usuario['id_administrador'].'" >
                                 <i class="glyphicon glyphicon-edit" title="Modificar"></i>
                              </a>
                           </div>
                           '.$this->__htmlCheck($usuario['status'], $usuario['id_usuario']).'
                        </td>';
                     $salida_html .= '</tr>';
                  } # fin foreach
               }
               else
               {
                  $salida_html .= '<tr><td class="vacio" colspan="6">
                     No hay resultados de usuarios para <strong>'.$filtro_busqueda.'</strong>.</td></tr>';
               }

               $salida_html .= '</tbody>
            </table>
         </div>';

      return $salida_html;
   }

   public function __barraBotonesHtml($pagina)
   {
      $salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
                  <button class="btn btn-info" title="Actualizar" data-toggle="actualizar_html" data-accion="actualizar_'.$pagina.'"
                     data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i>
                  </button>
                  <button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="crear_usuario"
                     data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i>
                  </button>
                  <div class="btn-group">
                     <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-expanded="false"
                        title="Filtrar por privilegios" data-placement="bottom"><i class="glyphicon glyphicon-filter"></i>
                     </button>
                     <ul class="dropdown-menu" role="menu">
                        <li><a href="'.$pagina.'.php" data-toggle="" data-accion="">Todos</a></li>';

                        if ($pagina != 'mis_usuarios')
                           $salida_html .='<li><a href="?priv=1">Super administradores</a></li>';

                        $salida_html .='<li><a href="?priv=2">Administradores</a></li>
                        <li><a href="?priv=3">Nacionales</a></li>
                        <li><a href="?priv=4">Americanas</a></li>
                        <li><a href="?priv=5">Americanas-Nacionales</a></li>
                     </ul>
                  </div>
                  <div class="btn-group2">
                     <button type="button" class="btn btn-info" data-accion="eliminar_usuarios_array" data-toggle="confirmar"
                        title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="suspender_array" data-toggle="confirmar"
                        title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="reanudar_array" data-toggle="confirmar"
                        title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="restablecer_preguntas_array"
                        data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom">
                        <i class="glyphicon glyphicon-repeat"></i>
                     </button>
                  </div>
               </div>
               <div class="buscar">
                  <form id="form-buscar">
                     <input type="text" id="campo_busqueda" placeholder="Buscar usuario">
                     <a href="#" class="abrir-buscar">
                        <i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i>
                     </a>
                  </form>
               </div>
            </div>
         </div>
      ';

      return $salida_html;
   }

   public function __barraBotonesBusquedaHtml($pagina, $filtro_busqueda)
   {
      $salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
                  <button class="btn btn-info" title="Volver" data-placement="bottom" onClick="history.go(-1)">
                     <i class="glyphicon glyphicon-arrow-left"></i>
                  </button>
                  <button class="btn btn-info" title="Actualizar" data-toggle="actualizar_html" data-accion="actualizar_'.$pagina.'"
                     data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i>
                  </button>
                  <button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="crear_usuario"
                     data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i>
                  </button>
                  <div class="btn-group">
                     <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-expanded="false"
                        title="Filtrar por privilegios" data-placement="bottom"><i class="glyphicon glyphicon-filter"></i>
                     </button>
                     <ul class="dropdown-menu" role="menu">
                        <li><a href="'.$pagina.'.php">Todos</a></li>';

                        if ($pagina != 'mis_usuarios')
                           $salida_html .='<li><a href="?priv=1">Super administradores</a></li>';

                        $salida_html .= '<li><a href="?priv=2">Administradores</a></li>
                        <li><a href="?priv=3">Nacionales</a></li>
                        <li><a href="?priv=4">Americanas</a></li>
                        <li><a href="?priv=5">Americanas-Nacionales</a></li>
                     </ul>
                  </div>
                  <div class="btn-group2">
                     <button type="button" class="btn btn-info" data-accion="eliminar_usuarios_array" data-toggle="confirmar"
                        title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="suspender_array" data-toggle="confirmar"
                        title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="reanudar_array" data-toggle="confirmar"
                        title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="restablecer_preguntas_array"
                        data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom">
                        <i class="glyphicon glyphicon-repeat"></i>
                     </button>
                  </div>
               </div>
               <div class="buscar">
                  <form id="form-buscar">
                     <input type="text" id="campo_busqueda" placeholder="Buscar usuario" value="'.$filtro_busqueda.'">
                     <a href="#" class="abrir-buscar">
                        <i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i>
                     </a>
                  </form>
               </div>
            </div>
         </div>
      ';

      return $salida_html;
   }

   public function __barraBotonesUsuariosAdministradosHtml($pagina, $administrador)
   {
      $salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
                  <button class="btn btn-info" title="Volver" data-placement="bottom" onClick="history.go(-1)">
                     <i class="glyphicon glyphicon-arrow-left"></i>
                  </button>
                  <button class="btn btn-info" title="Actualizar" data-toggle="actualizar_html" data-accion="actualizar_mis_usuarios" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i>
                  </button>';
                  /*<button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="crear_usuario"
                     data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i>
                  </button>';*/
                  if ($pagina == 'mis_usuarios')
                  {
                     $salida_html .= '<div class="btn-group">
                        <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-expanded="false"
                           title="Filtrar por privilegios" data-placement="bottom"><i class="glyphicon glyphicon-filter"></i>
                        </button>
                        <ul class="dropdown-menu" role="menu">
                           <li><a href="?administrador='.$administrador.'" data-toggle="" data-accion="">Todos</a></li>
                           <li><a href="?administrador='.$administrador.'&priv=3" data-toggle="" data-accion="">Nacionales</a></li>
                           <li><a href="?administrador='.$administrador.'&priv=4" data-toggle="" data-accion="">Americanas</a></li>
                           <li><a href="?administrador='.$administrador.'&priv=5" data-toggle="" data-accion="">Americanas-Nacionales</a></li>
                        </ul>
                     </div>';
                  }
                  $salida_html .= '<div class="btn-group2">
                     <button type="button" class="btn btn-info" data-accion="eliminar_usuarios_array" data-toggle="confirmar"
                        title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="suspender_array" data-toggle="confirmar"
                        title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="reanudar_array" data-toggle="confirmar"
                        title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="restablecer_preguntas_array"
                        data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom">
                        <i class="glyphicon glyphicon-repeat"></i>
                     </button>
                  </div>
               </div>
               <div class="buscar">
                  <form id="form-buscar">
                     <input type="text" id="campo_busqueda" placeholder="Buscar usuario">
                     <a href="#" class="abrir-buscar">
                        <i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i>
                     </a>
                  </form>
               </div>
            </div>
         </div>
      ';

      return $salida_html;
   }

   public function __barraBotonesBusquedaUsuariosAdministradosHtml($pagina, $administrador, $filtro_busqueda)
   {
      $salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
                  <button class="btn btn-info" title="Volver" data-placement="bottom" onClick="history.go(-1)">
                     <i class="glyphicon glyphicon-arrow-left"></i>
                  </button>
                  <button class="btn btn-info" title="Actualizar" data-toggle="actualizar_html" data-accion="actualizar_mis_usuarios" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i>
                  </button>';
                  /*<button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="crear_usuario"
                     data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i>
                  </button>';*/
                  if ($pagina == 'mis_usuarios')
                  {
                     $salida_html .= '<div class="btn-group">
                        <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-expanded="false"
                           title="Filtrar por privilegios" data-placement="bottom"><i class="glyphicon glyphicon-filter"></i>
                        </button>
                        <ul class="dropdown-menu" role="menu">
                           <li><a href="?administrador='.$administrador.'" data-toggle="" data-accion="">Todos</a></li>
                           <li><a href="?administrador='.$administrador.'&priv=3" data-toggle="" data-accion="">Nacionales</a></li>
                           <li><a href="?administrador='.$administrador.'&priv=4" data-toggle="" data-accion="">Americanas</a></li>
                           <li><a href="?administrador='.$administrador.'&priv=5" data-toggle="" data-accion="">Americanas-Nacionales</a></li>
                        </ul>
                     </div>';
                  }
                  $salida_html .= '<div class="btn-group2">
                     <button type="button" class="btn btn-info" data-accion="eliminar_usuarios_array" data-toggle="confirmar"
                        title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="suspender_array" data-toggle="confirmar"
                        title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="reanudar_array" data-toggle="confirmar"
                        title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i>
                     </button>
                     <button type="button" class="btn btn-info" data-accion="restablecer_preguntas_array"
                        data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom">
                        <i class="glyphicon glyphicon-repeat"></i>
                     </button>
                  </div>
               </div>
               <div class="buscar">
                  <form id="form-buscar">
                     <input type="text" id="campo_busqueda" placeholder="Buscar usuario" value="'.$filtro_busqueda.'">
                     <a href="#" class="abrir-buscar">
                        <i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i>
                     </a>
                  </form>
               </div>
            </div>
         </div>
      ';

      return $salida_html;
   }
}

?>