<?php

include_once 'Conexion.php';
include_once 'Notificacion.php';
include_once 'Pago.php';

class Suscripcion
{
   public function guardar($ultimo_id, $suscripcion, $tiempo_suscripcion, $dias)
   {
      $bd = new Conexion();
      $aux = 0;
      $fecha = date('Y-m-d H:i:s');

      if ($suscripcion == 1 || $suscripcion == 3)
      {
         $query = 'INSERT INTO suscripcion (id_usuario, tipo, tiempo, tiempo2, fecha)
            VALUES ("'.$ultimo_id.'", "'.trim($suscripcion).'", "'.trim($tiempo_suscripcion).'",
            "'.trim($tiempo_suscripcion).'", "'.$fecha.'")';
      }
      if ($suscripcion == 2)
      {
         $dias = implode(',', $dias);
         $query = 'INSERT INTO suscripcion (id_usuario, tipo, fecha, dias)
            VALUES ("'.$ultimo_id.'", "'.trim($suscripcion).'", "'.$fecha.'", "'.$dias.'")';
      }

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function actualizar($id_usuario, $tipo_suscripcion, $tiempo, $dias)
   {
      $bd = new Conexion();
      $fecha = date('Y-m-d H:i:s');
      $obj_notificacion = new Notificacion();

      if ($fila = $this->consultarSuscripcionMasStatusPrivilegiosIdAdministrador($id_usuario))
      {
         if ($tipo_suscripcion == 1 || $tipo_suscripcion == 3)
         {
            if ($fila['tipo'] != $tipo_suscripcion || $fila['tiempo2'] != $tiempo)
            {
               if ($fila['tiempo2'] == 0)
               {
                  $query = 'UPDATE suscripcion
                     SET tipo = "'.$tipo_suscripcion.'", tiempo = "'.trim($tiempo).'",
                     tiempo2 = "'.trim($tiempo).'", fecha = "'.$fecha.'", dias = ""
                     WHERE id_usuario = "'.$id_usuario.'"';
               }
               else
               {
                  if ($tiempo > $fila['tiempo2'])
                     $tiempo = ($tiempo - $fila['tiempo2']) + $fila['tiempo2'];
                  else
                     $tiempo = $fila['tiempo2'] - ($fila['tiempo2'] - $tiempo);

                  $query = 'UPDATE suscripcion
                     SET tipo = "'.$tipo_suscripcion.'", tiempo = "'.trim($tiempo).'",
                     tiempo2 = "'.trim($tiempo).'", dias = ""
                     WHERE id_usuario = "'.$id_usuario.'"';
               }

               $bd->ejecutar($query);
               $caducidad_suscripcion = $this->calcularCaducidad($tipo_suscripcion, $tiempo, $fecha);

               if ($caducidad_suscripcion <= time())
                  $this->entradaSuscripcion();
               else
               {
                  if ($fila['status2'] != 0)
                  {
                     $obj_notificacion->guardar($id_usuario, time(), 11);
                     $ultimo_id = $bd->ultimoId();
                     $obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
                     $this->actualizarStatus2(0, $id_usuario);

                     # En este punto, se supone que el pago del usuario ya fue procesado
                     # y verificado. Por ello, se elimina el registro del pago.
                     if ($tipo_suscripcion == 3)
                     {
                        $obj_pago = new Pago();
                        $obj_pago->eliminar($id_usuario);
                     }
                  }
                  if ($fila['privilegios'] == 2)
                     $this->habilitarInhabilitarUsuariosEstandar($id_usuario, 0);
               }
            }
         }
         if ($tipo_suscripcion == 2)
         {
            if ($fila['tipo'] != $tipo_suscripcion || $fila['dias'] != $dias)
            {
               $dias = implode(',', $dias);

               $query = 'UPDATE suscripcion
                  SET tipo = "'.$tipo_suscripcion.'", tiempo = 0, tiempo2 = 0, fecha = "'.$fecha.'", dias = "'.$dias.'", status2 = 0
                  WHERE id_usuario = "'.$id_usuario.'"';
               $bd->ejecutar($query);

               if ($fila['status2'] != 0)
               {
                  $obj_notificacion->guardar($id_usuario, time(), 11);
                  $ultimo_id = $bd->ultimoId();
                  $obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
               }
               if ($fila['privilegios'] == 2)
                  $this->habilitarInhabilitarUsuariosEstandar($id_usuario, 0);
            }
         }
      }
      else
      {
         $query = 'INSERT INTO suscripcion (id_usuario, tipo, tiempo, tiempo2, fecha)
            VALUES ("'.$id_usuario.'", "'.$tipo.'", "'.trim($tiempo).'", "'.trim($tiempo).'", "'.$fecha.'")';
         $bd->ejecutar($query);
      }
   }

   public function eliminar($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'DELETE FROM suscripcion
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   private function consultarSuscripcionMasStatusPrivilegiosIdAdministrador($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT suscripcion.*, registrados.status AS status_reg,
         registrados.privilegios, registrados.id_administrador
         FROM suscripcion
         JOIN registrados ON suscripcion.id_usuario = registrados.id_usuario
         WHERE suscripcion.id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila;

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   public function calcularCaducidad($tipo, $tiempo, $fecha)
   {
      $nueva_fecha = new DateTime($fecha);
      $time =  $nueva_fecha->getTimestamp();
      $fecha_caducidad = '';

      if ($tipo == 1)
         $fecha_caducidad = $time + ($tiempo * 60);
      if ($tipo == 3)
      {
         $dias = $tiempo * 30;
         $fecha_caducidad = $time + ($dias * 24 * 60 * 60);
      }

      return $fecha_caducidad;
   }

   public function entradaSuscripcion()
   {
      $bd = new Conexion();
      $hoy_timestamp = time();
      $aux = 0;

      $query = 'SELECT suscripcion.tipo, suscripcion.tiempo, suscripcion.fecha, suscripcion.status2,
         registrados.id_usuario AS id_usuario, registrados.status AS status,
         registrados.id_administrador AS id_administrador, registrados.privilegios AS privilegios,
         entradas.fecha AS fecha_entrada, entradas.actividad AS actividad_entrada
         FROM suscripcion
         JOIN registrados ON suscripcion.id_usuario = registrados.id_usuario
         LEFT JOIN entradas ON entradas.usuario_id = registrados.id_usuario
         GROUP BY registrados.id_usuario
         HAVING suscripcion.status2 = 0';

      if ($estc = $bd->ejecutar($query))
      {
         $aux = 1;
         $obj_notificacion = new Notificacion();
         $obj_pago = new Pago();

         while ($filas = $bd->obtenerFilas($estc))
         {
            if ($filas['tipo'] != 2 && $filas['privilegios'] != 1)
            {
               $caducidad_suscripcion = $this->calcularCaducidad($filas['tipo'], $filas['tiempo'], $filas['fecha']);

               if ($caducidad_suscripcion <= $hoy_timestamp)
               {
                  if ($this->actualizarTiempo2Status2RegistradoOnline($filas['id_usuario']))
                  {
                     $obj_notificacion->guardar($filas['id_usuario'], $hoy_timestamp, 9);
                     $ultimo_id = $bd->ultimoId();
                     $obj_notificacion->guardarPorLeer($filas['privilegios'],
                        $ultimo_id, $filas['id_administrador']);

                     if ($filas['privilegios'] == 2)
                        $this->habilitarInhabilitarUsuariosEstandar($filas['id_usuario'], 1);

                     if ($filas['privilegios'] >= 2 && $filas['tipo'] == 3)
                        $obj_pago->guardar($filas['id_usuario']);
                  }
               }
            }
         } # fin while

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   private function actualizarTiempo2Status2RegistradoOnline($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE suscripcion
         JOIN registrados ON suscripcion.id_usuario = registrados.id_usuario
         SET suscripcion.tiempo2 = 0, suscripcion.status2 = 1, registrados.online = 0
         WHERE suscripcion.id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   /**
    * Este método habilita o inhabilita a los usuarios de un Administrador
    * cuando a éste se le vence la suscripción.
    */
   private function habilitarInhabilitarUsuariosEstandar($id_usuario, $valor_status)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE suscripcion
         LEFT JOIN registrados ON registrados.id_usuario = suscripcion.id_usuario
         SET suscripcion.status = "'.$valor_status.'"
         WHERE registrados.id_administrador = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function actualizarStatus($valor_status, $id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE suscripcion
         SET status = "'.$valor_status.'"
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function actualizarStatus2($valor_status2, $id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE suscripcion
         SET status2 = "'.$valor_status2.'"
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   # Obtiene el tipo de suscripción de cualquier usuario.
   public function get_tipo($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT tipo FROM suscripcion
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['tipo'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   public function nombreTipo($tipo_suscripcion)
   {
      $nombre = [
         1 => 'Prueba',
         2 => 'Semanal',
         3 => 'Mensual' ];

      return $nombre[$tipo_suscripcion];
   }

   public function nombreTiempo($tipo_suscripcion)
   {
      $nombre = [
         1 => 'N° minutos',
         2 => 'Días',
         3 => 'N° meses' ];

      return $nombre[$tipo_suscripcion];
   }

   public function nombreDias()
   {
      $nombre_dias = [
         'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sáb', 'Dom' ];

      return $nombre_dias;
   }

   public function numeroDias()
   {
      $numero_dias = [
         '1', '2', '3', '4', '5', '6', '0' ];

      return $numero_dias;
   }

   public function numeroHoras($tiempo)
   {
      $numero_horas = '';

      if ($tiempo == 1)
         $numero_horas = floor($tiempo / 60);

      return $numero_horas;
   }

   /**
    * [Lleva una fecha al formato d/m/Y h:i:s a]
    */
   public function fechaConFormato($fecha)
   {
      return date('d/m/Y h:i:s a', strtotime($fecha));
   }

   public function arrayDias($dias)
   {
      return str_replace(",",", ", $dias);
   }

   /**
    * [Muestra información de suscripción de un usuario en la sección
    *  ver_detalles de cualquier página.]
    */
   public function __panelVerDetallesHtml($fila)
   {
      $salida_html = '
         <div class="panel panel-info">
            <div class="panel-heading">
               <h3 class="panel-title" style="display:inline"> Suscripción</h3>
            </div>
            <div class="panel-body" style="padding:0">
               <div class="table-responsive">
                  <table class="table table-condensed" style="margin-bottom:0">
                     <tbody>
                        <tr>
                           <th width="125" align="left">Fecha:</th>
                           <td align="right">'.$this->fechaConFormato($fila['suscripcion_fecha']).'</td>
                        </tr>
                        <tr>
                           <th width="125" align="left">Tipo:</th>
                           <td align="right">'.$this->nombreTipo($fila['suscripcion_tipo']).'</td>
                        </tr>';

                        if ($fila['suscripcion_tipo'] == 1 || $fila['suscripcion_tipo'] == 3)
                        {
                           $salida_html .= '
                              <tr>
                                 <th width="100" align="left">'.$this->nombreTiempo($fila['suscripcion_tipo']).':</th>
                                 <td align="right">
                                    '.$fila['suscripcion_tiempo']/*.$this->numeroHoras($fila['suscripcion_tiempo'])*/.'
                                 </td>
                              </tr>
                              <tr>
                                 <th width="150" align="left">Fecha caducidad:</th>
                                 <td align="right">'.date("d/m/Y h:i:s a",
                                    $this->calcularCaducidad($fila['suscripcion_tipo'],
                                       $fila['suscripcion_tiempo'], $fila['suscripcion_fecha'])).'
                                 </td>
                              </tr>';
                        }
                        if ($fila['suscripcion_tipo'] == 2)
                        {
                           $salida_html .= '
                              <tr>
                                 <th width="100" align="left">'.$this->nombreTipo($fila['suscripcion_tipo']).':</th>
                                 <td align="right">'.str_replace($this->numeroDias(), $this->nombreDias(),
                                    $this->arrayDias($fila['suscripcion_dias'])).'
                                 </td>
                              </tr>';
                        }
                     $salida_html .= '</tbody>
                  </table>
               </div>
            </div>
            <div class="panel-footer" style="padding:19px; border-top:0"></div>
         </div>
      ';

      return $salida_html;
   }
}

?>