<?php

include_once 'Conexion.php';

class Usuario
{
	public function actualizarOnline($time, $id_usuario)
	{
		$bd = new Conexion();
      $aux = 0;
		$limite = $time - 2 * 60;

		$query = 'UPDATE registrados SET online = 0
      	WHERE tiempo < "'.$limite.'"';

      if ($bd->ejecutar($query))
      {
      	$aux = 1;
      	$estado_online = $this->consultarValorOnline($id_usuario);

      	if ($estado_online != 0)
      	{
      		$query = 'UPDATE registrados SET tiempo = "'.$time.'"
      			WHERE id_usuario = "'.$id_usuario.'"';
      	}
      	else
      	{
      		$query = 'UPDATE registrados SET online = 1, tiempo = "'.$time.'"
      			WHERE id_usuario = "'.$id_usuario.'"';
      	}

      	$bd->ejecutar($query);
      }

		$bd->cerrar();

      return $aux;
	}

	public function consultarValorOnline($id_usuario)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'SELECT online FROM registrados
      	WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['online'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
	}

	public function consultarValorIp($id_usuario)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'SELECT ip FROM registrados
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['ip'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
	}

   public function inicio($id_usuario)
   {
      $aux = 0;

      if ($id_usuario == 'a_byjkal')
         $aux = 1;
      else
         $aux = $this->consultarValorInicio($id_usuario);

      return $aux;
   }

   public function verificarStatus($id_usuario_conectado, $privilegios_usuario_conectado)
   {
      $bd = new Conexion();
      $aux = 0;

      if ($privilegios_usuario_conectado > 1)
      {
         $query = 'SELECT registrados.status AS status, registrados.status2 AS status2,
            suscripcion.tipo AS tipo_suscripcion, suscripcion.status AS suscripcion_status,
            suscripcion.status2 AS suscripcion_status2
            FROM registrados
            LEFT JOIN suscripcion ON registrados.id_usuario = suscripcion.id_usuario
            WHERE registrados.id_usuario = "'.$id_usuario_conectado.'"';

         if ($estc = $bd->ejecutar($query))
         {
            if ($bd->obtenerCantidadFilas($estc) > 0)
            {
               $fila = $bd->obtenerFilas($estc);

               if ($fila['status'] == 1 || $fila['status2'] == 1 || $fila['suscripcion_status'] == 1
                  || $fila['suscripcion_status2'] == 1)
               {
                  $aux = 1;
               }
               else
               {
                  if ($fila['tipo_suscripcion'] == 2)
                  {
                     $dia_hoy = date('w');

                     if ($this->consultarDiaSemanaSuscripcion($id_usuario_conectado, $dia_hoy) == 0)
                        $aux = 1;
                  }
               }
            }
         }
      }
      else if ($privilegios_usuario_conectado == 1)
      {
         if ($this->consultarValorStatusRegistrados($id_usuario_conectado) != 0)
            $aux = 1;
      }

      return $aux;
   }

   /**
    * [Consulta el valor status de la tabla Registrados.]
    */
   private function consultarValorStatusRegistrados($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT status FROM registrados
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['status'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   private function consultarValorInicio($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT inicio FROM registrados
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['inicio'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   public function modificarIp($id_usuario, $nuevo_ip)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE registrados SET ip = "'.$nuevo_ip.'"
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   private function consultarDiaSemanaSuscripcion($id_usuario, $dia_hoy)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT FIND_IN_SET("'.$dia_hoy.'", dias) AS dia_semana
         FROM suscripcion
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['dia_semana'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   public function obtenerIdAdministrador($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT id_administrador FROM registrados
         WHERE (id_usuario = "'.$id_usuario.'" AND id_administrador != 0)';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['id_administrador'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   /**
    * [Método que se ejecuta cada x segundos por medio de javascript.]
    */
   public function actualizarPaginaSetInterval($id_usuario_conectado,
      $privilegios_usuario_conectado, $hoy)
   {
      $aux = 0;

      if ($this->actualizarOnline($hoy, $id_usuario_conectado))
         $aux = $this->verificarStatus($id_usuario_conectado, $privilegios_usuario_conectado);

      return $aux;
   }
}

?>